/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.core.util;

import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.util.GenericJsonReader;
import com.espressif.idf.core.util.IDFUtil;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

public class ProjectDescriptionReader {
    IProject project;

    public ProjectDescriptionReader(IProject project) {
        this.project = project;
    }

    public IFile getAppElfFile() {
        IFile appElfFile = null;
        try {
            String appElfFileName = this.getAppElfFileName();
            appElfFile = appElfFileName.isEmpty() ? appElfFile : this.project.getFolder("build").getFile(appElfFileName);
        }
        catch (Exception e) {
            Logger.log(e);
        }
        return appElfFile;
    }

    private String getAppElfFileName() {
        String appElfFileName = "";
        try {
            String buildDir = IDFUtil.getBuildDir(this.project);
            String filePath = buildDir + File.separator + "project_description.json";
            GenericJsonReader jsonReader = new GenericJsonReader(filePath);
            appElfFileName = jsonReader.getValue("app_elf");
        }
        catch (CoreException e) {
            Logger.log((Exception)((Object)e));
        }
        return appElfFileName;
    }

    public String getIdfPath() {
        String idfPath = "";
        try {
            String buildDir = IDFUtil.getBuildDir(this.project);
            String filePath = buildDir + File.separator + "project_description.json";
            if (Files.notExists(Paths.get(filePath, new String[0]), new LinkOption[0])) {
                return idfPath;
            }
            GenericJsonReader jsonReader = new GenericJsonReader(filePath);
            idfPath = jsonReader.getValue("idf_path");
        }
        catch (CoreException e) {
            Logger.log((Exception)((Object)e));
        }
        return idfPath;
    }
}

