/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.core.util;

import com.espressif.idf.core.IDFCorePlugin;
import com.espressif.idf.core.IDFEnvironmentVariables;
import com.espressif.idf.core.ProcessBuilderFactory;
import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.util.IDFUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;

public class NvsPartitionGenerator {
    private NvsPartitionGenerator() {
    }

    public static String generateNvsPartititon(boolean isEncrypted, Optional<String> encryptionKeyPathOpt, String size, IFile nvsCsvFile) {
        String resultFileName = nvsCsvFile.getName().replace("csv", "bin");
        if (IDFUtil.getIDFPath() != null && IDFUtil.getIDFPythonEnvPath() != null) {
            ArrayList<String> commands = new ArrayList<String>();
            commands.add(IDFUtil.getIDFPythonEnvPath());
            commands.add(IDFUtil.getNvsGeneratorScriptPath());
            commands.add(isEncrypted ? "encrypt" : "generate");
            commands.add(nvsCsvFile.getName());
            commands.add(resultFileName);
            commands.add(size);
            if (isEncrypted) {
                commands.add(encryptionKeyPathOpt.map(t -> "--inputKey " + t).orElse("--keygen"));
            }
            Map<String, String> envMap = new IDFEnvironmentVariables().getSystemEnvMap();
            return NvsPartitionGenerator.runCommand(commands, envMap, new Path(nvsCsvFile.getProject().getLocationURI().getPath()));
        }
        return "";
    }

    private static String runCommand(List<String> arguments, Map<String, String> env, Path path) {
        String exportCmdOp = "";
        ProcessBuilderFactory processRunner = new ProcessBuilderFactory();
        try {
            IStatus status = processRunner.runInBackground(arguments, (IPath)path, env);
            if (status == null) {
                Logger.log(IDFCorePlugin.getPlugin(), IDFCorePlugin.errorStatus("Status can't be null", null));
                return exportCmdOp;
            }
            exportCmdOp = status.getMessage();
            Logger.log(exportCmdOp);
        }
        catch (Exception e1) {
            Logger.log(IDFCorePlugin.getPlugin(), e1);
        }
        return exportCmdOp;
    }
}

