/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.core.util;

import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.util.Messages;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.channels.FileChannel;
import java.text.MessageFormat;
import java.util.Scanner;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

public class FileUtil {
    public static final String UTF_8 = "UTF-8";
    private static final String EMPTY_STR = "";
    private static final int BUFFER_SIZE = 8192;

    public static IStatus copyDirectory(File source, File destination, IProgressMonitor monitor, int[] count, int updateSize, boolean cancelable) throws IOException {
        if (monitor != null) {
            if (cancelable && monitor.isCanceled()) {
                return new Status(8, "com.espressif.idf.core", 8, EMPTY_STR, null);
            }
            count[0] = count[0] + 1;
            if (updateSize < 2 || count[0] % updateSize == 0) {
                monitor.setTaskName(MessageFormat.format(Messages.FileUtil_CopyingMsg, destination.toString()));
                monitor.worked(1);
            }
        }
        if (source.isDirectory()) {
            String error = null;
            if (!source.canRead()) {
                error = Messages.FileUtil_SourceDirNotavailable;
            } else if (!destination.exists()) {
                if (!destination.mkdir()) {
                    error = Messages.FileUtil_DesDirNotavailable;
                }
            } else if (!destination.isDirectory()) {
                error = Messages.FileUtil_DestinationNotaDir;
            } else if (!destination.canWrite()) {
                error = Messages.FileUtil_WritableProblemMsg;
            }
            if (error == null) {
                String[] stringArray = source.list();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String filename = stringArray[n2];
                    IStatus status = FileUtil.copyDirectory(new File(source, filename), new File(destination, filename), monitor, count, updateSize, cancelable);
                    if (status != null && !status.isOK()) {
                        return status;
                    }
                    ++n2;
                }
            } else {
                String message = MessageFormat.format(Messages.FileUtil_UnableToCopy, source, destination, error);
                Logger.logError(message);
            }
        } else {
            try {
                IFileSystem system = EFS.getLocalFileSystem();
                IFileStore src = system.fromLocalFile(source);
                src.copy(system.fromLocalFile(destination), 2, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                return new Status(4, "com.espressif.idf.core", 4, e.getMessage(), (Throwable)e);
            }
        }
        return Status.OK_STATUS;
    }

    public static IStatus copyDirectory(File source, File destination) throws IOException {
        return FileUtil.copyDirectory(source, destination, null, new int[1], 0, false);
    }

    public static void copyFile(File source, File destination) throws IOException {
        long fileSize = source.length();
        FileInputStream in = new FileInputStream(source);
        FileOutputStream out = new FileOutputStream(destination);
        if (fileSize > 0x1400000L) {
            try {
                FileUtil.pipe(in, out);
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        FileUtil.copy(in, out);
    }

    private static void copy(FileInputStream iStream, FileOutputStream oStream) throws IOException {
        try {
            FileChannel inChannel = iStream.getChannel();
            FileChannel outChannel = oStream.getChannel();
            long fileSize = inChannel.size();
            long offs = 0L;
            long doneCnt = 0L;
            long copyCnt = Math.min(65536L, fileSize);
            do {
                doneCnt = inChannel.transferTo(offs, copyCnt, outChannel);
                offs += doneCnt;
            } while ((fileSize -= doneCnt) > 0L);
        }
        finally {
            try {
                if (iStream != null) {
                    iStream.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (oStream != null) {
                    oStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void write(OutputStream stream, String rawSource, String charset) {
        if (stream == null) {
            return;
        }
        if (rawSource == null) {
            rawSource = EMPTY_STR;
        }
        if (charset == null) {
            charset = UTF_8;
        }
        OutputStreamWriter writer = null;
        try {
            try {
                writer = new OutputStreamWriter(stream, charset);
                writer.write(rawSource);
            }
            catch (IOException e) {
                Logger.log(e);
                try {
                    if (writer != null) {
                        ((Writer)writer).close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                if (writer != null) {
                    ((Writer)writer).close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static void pipe(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[8192];
        int bytes = input.read(buffer);
        while (bytes >= 0) {
            output.write(buffer, 0, bytes);
            bytes = input.read(buffer);
        }
    }

    public static String readFile(IProject project, String relativeFilePath) {
        IFile filePath = project.getFile((IPath)new Path(relativeFilePath));
        if (!filePath.exists()) {
            Logger.log(MessageFormat.format("{0} couldn't find", filePath.toString()));
            return null;
        }
        return FileUtil.readFile(filePath.getRawLocation().toOSString());
    }

    public static String readFile(String absoluteFilePath) {
        StringBuilder fileContents = new StringBuilder();
        try {
            Scanner scanner = new Scanner(new File(absoluteFilePath));
            while (scanner.hasNext()) {
                fileContents.append(scanner.nextLine());
                fileContents.append(System.getProperty("line.separator"));
            }
            scanner.close();
        }
        catch (Exception e) {
            Logger.log(e);
            return null;
        }
        return fileContents.toString();
    }

    public static void writeFile(IProject project, String relativeFilePath, String contents, boolean append) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(contents.getBytes());
        IFile filePath = project.getFile((IPath)new Path(relativeFilePath));
        try {
            if (!filePath.exists()) {
                filePath.create((InputStream)inputStream, true, null);
            } else if (append) {
                filePath.appendContents((InputStream)inputStream, true, true, null);
            } else {
                filePath.setContents((InputStream)inputStream, 1, null);
            }
        }
        catch (Exception e) {
            Logger.log(e);
        }
    }

    public static void deleteDirectory(File file) throws IOException {
        File[] entries;
        if (file.isDirectory() && (entries = file.listFiles()) != null) {
            File[] fileArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                File entry = fileArray[n2];
                FileUtil.deleteDirectory(entry);
                ++n2;
            }
        }
        if (!file.delete()) {
            throw new IOException("Failed to delete " + String.valueOf(file));
        }
    }
}

