/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.core.tools.util;

import com.espressif.idf.core.IDFEnvironmentVariables;
import com.espressif.idf.core.SystemExecutableFinder;
import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.tools.ToolsSystemWrapper;
import com.espressif.idf.core.tools.vo.ToolsVO;
import com.espressif.idf.core.util.FileUtil;
import com.espressif.idf.core.util.IDFUtil;
import com.espressif.idf.core.util.StringUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.tukaani.xz.XZInputStream;

public class ToolsUtility {
    private static final String SLASH = "\\";
    private static final String FORWARD_SLASH = "/";
    public static final String ESPRESSIF_HOME_DIR = System.getProperty("user.home").concat("/.espressif");
    public static final String ESPRESSIF_HOME_TOOLS_DIR = ESPRESSIF_HOME_DIR.concat("/tools");

    public static boolean isToolInstalled(String toolName, String versionsName) {
        File homeDir = new File(ESPRESSIF_HOME_DIR);
        if (!homeDir.exists()) {
            return false;
        }
        File toolDirectory = new File(ESPRESSIF_HOME_TOOLS_DIR.concat(FORWARD_SLASH).concat(toolName).concat(FORWARD_SLASH).concat(versionsName));
        if (toolDirectory.exists()) {
            IDFEnvironmentVariables idfEnvironmentVariables = new IDFEnvironmentVariables();
            String pathValue = idfEnvironmentVariables.getEnvValue("PATH");
            String[] splittedPaths = pathValue.split(File.pathSeparator);
            String directorySplittor = Platform.getOS().equals("win32") ? SLASH : FORWARD_SLASH;
            String[] stringArray = splittedPaths;
            int n = splittedPaths.length;
            int n2 = 0;
            while (n2 < n) {
                String splittedPath = stringArray[n2];
                if (splittedPath.contains(toolName.concat(directorySplittor).concat(versionsName))) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static void removeToolDirectory(String toolName) throws IOException {
        File toolDirectory = new File(ESPRESSIF_HOME_TOOLS_DIR.concat(FORWARD_SLASH).concat(toolName));
        if (!toolDirectory.exists()) {
            return;
        }
        FileUtil.deleteDirectory(toolDirectory);
    }

    public static String getFileExtension(String filename) {
        return Optional.ofNullable(filename).filter(f -> f.contains(".")).map(f -> f.substring(filename.lastIndexOf(".") + 1)).get();
    }

    public static void extractZip(String zipFilePath, String extractDirectory) {
        InputStream inputStream = null;
        try {
            Path filePath = Paths.get(zipFilePath, new String[0]);
            inputStream = Files.newInputStream(filePath, new OpenOption[0]);
            ArchiveStreamFactory archiveStreamFactory = new ArchiveStreamFactory();
            ArchiveInputStream archiveInputStream = archiveStreamFactory.createArchiveInputStream("zip", inputStream);
            ArchiveEntry archiveEntry = null;
            while ((archiveEntry = archiveInputStream.getNextEntry()) != null) {
                Path path = Paths.get(extractDirectory, archiveEntry.getName());
                File file = path.toFile();
                if (archiveEntry.isDirectory()) {
                    if (file.isDirectory()) continue;
                    file.mkdirs();
                    continue;
                }
                File parent = file.getParentFile();
                if (!parent.isDirectory()) {
                    parent.mkdirs();
                }
                Throwable throwable = null;
                Object var11_13 = null;
                try (OutputStream outputStream = Files.newOutputStream(path, new OpenOption[0]);){
                    IOUtils.copy((InputStream)archiveInputStream, (OutputStream)outputStream);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        }
        catch (Exception e) {
            Logger.log(e);
        }
    }

    public static void extractTarGz(String tarFile, String outputDir) {
        Path pathInput = Paths.get(tarFile, new String[0]);
        Path pathOutput = Paths.get(outputDir, new String[0]);
        try {
            TarArchiveInputStream tararchiveinputstream = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream((InputStream)new BufferedInputStream(Files.newInputStream(pathInput, new OpenOption[0]))));
            ArchiveEntry archiveentry = null;
            while ((archiveentry = tararchiveinputstream.getNextEntry()) != null) {
                Path pathEntryOutput = pathOutput.resolve(archiveentry.getName());
                if (archiveentry.isDirectory()) {
                    if (Files.exists(pathEntryOutput, new LinkOption[0])) continue;
                    Files.createDirectories(pathEntryOutput, new FileAttribute[0]);
                    continue;
                }
                Files.createDirectories(pathEntryOutput.getParent(), new FileAttribute[0]);
                Files.copy((InputStream)tararchiveinputstream, pathEntryOutput, StandardCopyOption.REPLACE_EXISTING);
                Runtime.getRuntime().exec("/bin/chmod 755 ".concat(pathEntryOutput.toString()));
            }
            tararchiveinputstream.close();
        }
        catch (Exception e) {
            Logger.log(e);
        }
    }

    public static void extractTarXz(String tarFile, String outputDir) {
        Path pathOutput = Paths.get(outputDir, new String[0]);
        HashMap<Path, Path> symLinks = new HashMap<Path, Path>();
        HashMap<Path, Path> hardLinks = new HashMap<Path, Path>();
        try {
            FileInputStream fileInputStream = new FileInputStream(tarFile);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            XZInputStream xzInputStream = new XZInputStream((InputStream)bufferedInputStream);
            TarArchiveInputStream tararchiveinputstream = new TarArchiveInputStream((InputStream)xzInputStream);
            TarArchiveEntry archiveentry = null;
            while ((archiveentry = tararchiveinputstream.getNextTarEntry()) != null) {
                Path pathEntryOutput = pathOutput.resolve(archiveentry.getName());
                if (archiveentry.isSymbolicLink()) {
                    symLinks.put(pathEntryOutput, pathOutput.resolve(archiveentry.getName()).getParent().resolve(archiveentry.getLinkName()));
                    continue;
                }
                if (archiveentry.isLink()) {
                    hardLinks.put(pathEntryOutput, pathOutput.resolve(archiveentry.getLinkName()));
                    continue;
                }
                if (archiveentry.isDirectory()) {
                    if (Files.exists(pathEntryOutput, new LinkOption[0])) continue;
                    Files.createDirectories(pathEntryOutput, new FileAttribute[0]);
                    continue;
                }
                System.out.println(pathEntryOutput.toString() + " " + archiveentry.getSize());
                Files.copy((InputStream)tararchiveinputstream, pathEntryOutput, StandardCopyOption.REPLACE_EXISTING);
                Runtime.getRuntime().exec("/bin/chmod 755 ".concat(pathEntryOutput.toString()));
            }
            tararchiveinputstream.close();
            xzInputStream.close();
            fileInputStream.close();
            hardLinks.forEach(ToolsUtility::createHardLinks);
            symLinks.forEach(ToolsUtility::createSymLinks);
        }
        catch (Exception e) {
            Logger.log(e);
        }
    }

    private static void createHardLinks(Path link, Path target) {
        try {
            Files.deleteIfExists(link);
            Files.createLink(link, target);
        }
        catch (Exception e) {
            Logger.log(e);
        }
    }

    private static void createSymLinks(Path link, Path target) {
        try {
            Files.deleteIfExists(link);
            Files.createSymbolicLink(link, target.toRealPath(new LinkOption[0]), new FileAttribute[0]);
        }
        catch (Exception e) {
            Logger.log(e);
        }
    }

    public static String getReadableSizeMB(double size) {
        size /= 1024.0;
        DecimalFormat df = new DecimalFormat("0.00");
        return String.valueOf(df.format(size /= 1024.0)).concat(" MB");
    }

    public static Map<String, String> getAvailableToolVersions(ToolsVO toolsVo) {
        HashMap<String, String> availableVersions = new HashMap<String, String>();
        File toolDirectory = new File(ESPRESSIF_HOME_TOOLS_DIR.concat(FORWARD_SLASH).concat(toolsVo.getName()).concat(FORWARD_SLASH));
        if (toolDirectory.exists()) {
            File[] fileArray = toolDirectory.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    availableVersions.put(file.getName(), file.getAbsolutePath());
                }
                ++n2;
            }
        }
        return availableVersions;
    }

    public static String getFileChecksum(MessageDigest digest, File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        byte[] byteArray = new byte[1024];
        int bytesCount = 0;
        while ((bytesCount = fis.read(byteArray)) != -1) {
            digest.update(byteArray, 0, bytesCount);
        }
        fis.close();
        byte[] bytes = digest.digest();
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < bytes.length) {
            sb.append(Integer.toString((bytes[i] & 0xFF) + 256, 16).substring(1));
            ++i;
        }
        return sb.toString();
    }

    public static IPath findAbsoluteToolPath(String toolName, String path) {
        if (StringUtil.isEmpty(path)) {
            Map<String, String> env = IDFUtil.getSystemEnv();
            path = env.containsKey("PATH") ? env.get("PATH") : env.get("Path");
        }
        SystemExecutableFinder systemExecutableFinder = new SystemExecutableFinder(new ToolsSystemWrapper(path));
        return systemExecutableFinder.find(toolName);
    }
}

