/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.core.resources;

import com.espressif.idf.core.IDFCorePlugin;
import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.util.RecheckConfigsHelper;
import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.launchbar.core.ILaunchBarListener;
import org.eclipse.launchbar.core.ILaunchBarManager;

public class ResourceChangeListener
implements IResourceChangeListener {
    ILaunchBarListener launchBarListener;

    public ResourceChangeListener(ILaunchBarListener launchBarListener) {
        this.launchBarListener = launchBarListener;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event == null || event.getDelta() == null) {
            return;
        }
        try {
            event.getDelta().accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) throws CoreException {
                    IProject project;
                    boolean isProjectOpenedOrCopied;
                    boolean isProjectAdded;
                    IResource resource = delta.getResource();
                    int kind = delta.getKind();
                    int flags = delta.getFlags();
                    ResourceChangeListener.this.updateLaunchBar(resource, kind, flags);
                    boolean bl = isProjectAdded = (resource.getType() & 4) != 0 && resource.getProject().isOpen() && kind == 1;
                    if (isProjectAdded) {
                        ResourceChangeListener.this.cleanupBuildFolder(resource);
                    }
                    boolean isProjectRenamed = resource.getType() == 4 && kind == 1 && (flags & 0x1000) != 0;
                    boolean bl2 = isProjectOpenedOrCopied = resource.getType() == 4 && (flags & 0x4000) != 0;
                    if ((isProjectOpenedOrCopied || isProjectRenamed) && (project = (IProject)resource).isOpen()) {
                        RecheckConfigsHelper.revalidateToolchain(project);
                    }
                    return true;
                }
            });
        }
        catch (CoreException e) {
            Logger.log((Exception)((Object)e));
        }
    }

    private void updateLaunchBar(IResource resource, int kind, int flags) throws CoreException {
        if (resource instanceof IProject) {
            ILaunchBarManager launchBarManager = IDFCorePlugin.getService(ILaunchBarManager.class);
            IProject project = (IProject)resource;
            if ((kind & 4) != 0) {
                ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
                ILaunchConfiguration[] configs = launchManager.getLaunchConfigurations();
                launchBarManager.removeListener(this.launchBarListener);
                ILaunchConfiguration[] iLaunchConfigurationArray = configs;
                int n = configs.length;
                int n2 = 0;
                while (n2 < n) {
                    ILaunchConfiguration config = iLaunchConfigurationArray[n2];
                    IResource[] mappedResource = config.getMappedResources();
                    if (mappedResource != null && mappedResource[0].getProject() == project) {
                        if (project.isOpen()) {
                            launchBarManager.launchConfigurationAdded(config);
                        } else {
                            launchBarManager.launchObjectRemoved((Object)config);
                        }
                    }
                    ++n2;
                }
                launchBarManager.addListener(this.launchBarListener);
                if (project.isOpen()) {
                    launchBarManager.launchObjectAdded((Object)project);
                } else {
                    launchBarManager.launchObjectRemoved((Object)project);
                }
            }
        }
    }

    private void cleanupBuildFolder(IResource resource) {
        IProject project = (IProject)resource;
        File buildLocation = new File(String.valueOf(project.getLocation()) + "/build");
        this.deleteDirectory(buildLocation);
    }

    private boolean deleteDirectory(File directoryToBeDeleted) {
        File[] allContents = directoryToBeDeleted.listFiles();
        if (allContents != null) {
            File[] fileArray = allContents;
            int n = allContents.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                this.deleteDirectory(file);
                ++n2;
            }
        }
        return directoryToBeDeleted.delete();
    }
}

