/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.core.logging;

import com.espressif.idf.core.IDFCorePlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

public class Logger {
    public static void log(String message) {
        Logger.log(IDFCorePlugin.getPlugin(), message);
    }

    public static void log(Exception e) {
        Logger.log(IDFCorePlugin.getPlugin(), e);
    }

    public static void log(Exception e, boolean onlyDebugMode) {
        if (onlyDebugMode && Platform.inDebugMode()) {
            Logger.log(IDFCorePlugin.getPlugin(), e);
        }
    }

    public static void log(String msg, boolean onlyDebugMode) {
        if (onlyDebugMode && Platform.inDebugMode()) {
            Logger.log(IDFCorePlugin.getPlugin(), msg);
        }
    }

    public static void logError(String message) {
        Logger.logError(IDFCorePlugin.getPlugin(), message);
    }

    public static void log(Plugin plugin, Exception e) {
        if (plugin == null) {
            return;
        }
        if (e instanceof CoreException) {
            plugin.getLog().log(((CoreException)((Object)e)).getStatus());
        } else {
            String symbolicName = "com.espressif.idf.core";
            if (plugin != null && plugin.getBundle() != null) {
                symbolicName = plugin.getBundle().getSymbolicName();
            }
            plugin.getLog().log((IStatus)new Status(4, symbolicName, e.getLocalizedMessage(), (Throwable)e));
        }
    }

    public static void log(Plugin plugin, String message, Exception e) {
        plugin.getLog().log(Logger.createStatus(message, e));
    }

    public static void log(Plugin plugin, Exception e, boolean onlyDebugMode) {
        if (onlyDebugMode && !Platform.inDebugMode()) {
            return;
        }
        Logger.log(plugin, e);
    }

    public static void log(Plugin plugin, String message) {
        String symbolicName = "com.espressif.idf.core";
        if (plugin != null && plugin.getBundle() != null) {
            symbolicName = plugin.getBundle().getSymbolicName();
        }
        plugin.getLog().log((IStatus)new Status(1, symbolicName, message));
    }

    public static void log(Plugin plugin, String message, boolean onlyDebugMode) {
        if (onlyDebugMode && !Platform.inDebugMode()) {
            return;
        }
        Logger.log(plugin, message);
    }

    public static void log(Plugin plugin, IStatus status) {
        plugin.getLog().log(status);
    }

    public static void logError(Plugin plugin, String message) {
        plugin.getLog().log(Logger.createStatus(message));
    }

    public static void logTrace(Plugin plugin, String message) {
        Logger.log(plugin, message, true);
    }

    public static void logTrace(String message) {
        Logger.log(IDFCorePlugin.getPlugin(), message, true);
    }

    public static IStatus createStatus(String msg) {
        return Logger.createStatus(msg, null);
    }

    public static IStatus createStatus(String msg, Throwable e) {
        return new Status(4, IDFCorePlugin.getId(), msg, e);
    }
}

