/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.core.build;

import com.espressif.idf.core.IDFCorePlugin;
import com.espressif.idf.core.IDFEnvironmentVariables;
import com.espressif.idf.core.build.ActiveLaunchConfigurationProvider;
import com.espressif.idf.core.build.CmakeBuildException;
import com.espressif.idf.core.build.EspIdfErrorParser;
import com.espressif.idf.core.build.Messages;
import com.espressif.idf.core.internal.CMakeConsoleWrapper;
import com.espressif.idf.core.internal.CMakeErrorParser;
import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.util.ClangFormatFileHandler;
import com.espressif.idf.core.util.ClangdConfigFileHandler;
import com.espressif.idf.core.util.DfuCommandsUtil;
import com.espressif.idf.core.util.HintsUtil;
import com.espressif.idf.core.util.IDFUtil;
import com.espressif.idf.core.util.LaunchUtil;
import com.espressif.idf.core.util.LspService;
import com.espressif.idf.core.util.ParitionSizeHandler;
import com.espressif.idf.core.util.ProjectDescriptionReader;
import com.espressif.idf.core.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.cdt.cmake.core.ICMakeToolChainFile;
import org.eclipse.cdt.cmake.core.ICMakeToolChainManager;
import org.eclipse.cdt.cmake.core.internal.CMakeUtils;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ConsoleOutputStream;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.IConsoleParser;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.core.build.CBuildConfiguration;
import org.eclipse.cdt.core.build.IToolChain;
import org.eclipse.cdt.core.build.IToolChainManager;
import org.eclipse.cdt.core.envvar.EnvironmentVariable;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.IBinaryContainer;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.internal.core.model.BinaryRunner;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchMode;
import org.eclipse.launchbar.core.ILaunchBarManager;
import org.eclipse.launchbar.core.target.ILaunchTarget;

public class IDFBuildConfiguration
extends CBuildConfiguration {
    private static final ActiveLaunchConfigurationProvider LAUNCH_CONFIG_PROVIDER = new ActiveLaunchConfigurationProvider();
    private static final String NINJA = "Ninja";
    protected static final String COMPILE_COMMANDS_JSON = "compile_commands.json";
    protected static final String COMPONENTS = "components";
    public static final String CMAKE_GENERATOR = "cmake.generator";
    public static final String CMAKE_ARGUMENTS = "cmake.arguments";
    public static final String CMAKE_ENV = "cmake.environment";
    public static final String BUILD_COMMAND = "cmake.command.build";
    public static final String CLEAN_COMMAND = "cmake.command.clean";
    private ILaunchTarget launchtarget;
    private ICMakeToolChainFile toolChainFile;
    private IProgressMonitor monitor;
    public boolean isProgressSet;

    public IDFBuildConfiguration(IBuildConfiguration config, String name) throws CoreException {
        super(config, name);
    }

    public IDFBuildConfiguration(IBuildConfiguration config, String name, IToolChain toolChain, ICMakeToolChainFile toolChainFile, String launchMode, ILaunchTarget target) {
        super(config, name, toolChain, launchMode, target);
        this.toolChainFile = toolChainFile;
    }

    public java.nio.file.Path getBuildDirectory() throws CoreException {
        return Paths.get(this.getBuildDirectoryURI());
    }

    public IContainer getBuildContainer() throws CoreException {
        IProject project = this.getProject();
        IFolder buildRootFolder = project.getFolder("build");
        NullProgressMonitor monitor = new NullProgressMonitor();
        if (!buildRootFolder.exists()) {
            buildRootFolder.create(1025, true, (IProgressMonitor)monitor);
        }
        return buildRootFolder;
    }

    public IPath getBuildContainerPath() throws CoreException {
        Path path = new Path(IDFUtil.getBuildDir(this.getProject()));
        if (!path.toFile().exists()) {
            path.toFile().mkdirs();
        }
        return path;
    }

    public URI getBuildDirectoryURI() throws CoreException {
        IPath buildContainerPath = this.getBuildContainerPath();
        return buildContainerPath.toFile().toURI();
    }

    public IBinary[] getBuildOutput() throws CoreException {
        IPath outputPath;
        ICProject cproject = CoreModel.getDefault().create(this.getProject());
        IBinaryContainer binaries = cproject.getBinaryContainer();
        IBinary[] outputs = this.getBuildOutput(binaries, outputPath = this.getBuildContainerPath());
        if (outputs.length > 0) {
            return outputs;
        }
        BinaryRunner runner = CModelManager.getDefault().getBinaryRunner(cproject);
        runner.start();
        runner.waitIfRunning();
        return this.getBuildOutput(binaries, outputPath);
    }

    public String getProperty(String name) {
        try {
            ILaunchConfiguration configuration = LAUNCH_CONFIG_PROVIDER.getActiveLaunchConfiguration();
            if (configuration != null && configuration.getType().getIdentifier().equals("com.espressif.idf.debug.gdbjtag.openocd.launchConfigurationType")) {
                configuration = new LaunchUtil(DebugPlugin.getDefault().getLaunchManager()).getBoundConfiguration(configuration);
            }
            String property = configuration == null ? "" : configuration.getAttribute(name, "");
            property = property.isBlank() ? this.getSettings().get(name, "") : property;
            return property;
        }
        catch (CoreException e) {
            Logger.log((Exception)((Object)e));
            return super.getProperty(name);
        }
    }

    private IBinary[] getBuildOutput(IBinaryContainer binaries, IPath outputPath) throws CoreException {
        return (IBinary[])Arrays.stream(binaries.getBinaries()).filter(b -> b.isExecutable() && outputPath.isPrefixOf(b.getPath())).toArray(IBinary[]::new);
    }

    public ICMakeToolChainFile getToolChainFile() throws CoreException {
        ICMakeToolChainManager manager = IDFCorePlugin.getService(ICMakeToolChainManager.class);
        IToolChain toolChain = this.getToolChain();
        if (toolChain == null) {
            throw new CoreException((IStatus)new Status(4, "com.espressif.idf.core", Messages.IDFToolChainsMissingErrorMsg));
        }
        this.toolChainFile = manager.getToolChainFileFor(toolChain);
        return this.toolChainFile;
    }

    private boolean isLocal() throws CoreException {
        IToolChain toolchain = this.getToolChain();
        return (Platform.getOS().equals(toolchain.getProperty("os")) || "linux-container".equals(toolchain.getProperty("os"))) && Platform.getOSArch().equals(toolchain.getProperty("arch"));
    }

    public IProject[] build(int kind, Map<String, String> args, IConsole console, IProgressMonitor monitor) throws CoreException {
        try {
            if (!this.buildPrechecks(console)) {
                return new IProject[]{this.getProject()};
            }
        }
        catch (Exception e) {
            Logger.log(e);
        }
        this.monitor = monitor;
        this.isProgressSet = false;
        IProject project = this.getProject();
        this.toolChainFile = this.getToolChainFile();
        Instant start = Instant.now();
        if (!(this.checkLaunchTarget(console) && this.checkSpacesSupport(project, console) && this.checkToolChainFile(console))) {
            return new IProject[0];
        }
        String generator = this.getProperty(CMAKE_GENERATOR);
        generator = generator.isBlank() ? NINJA : generator;
        project.deleteMarkers("org.eclipse.cdt.core.problem", false, 2);
        ConsoleOutputStream infoStream = console.getInfoStream();
        java.nio.file.Path buildDir = this.getBuildDirectory();
        if (!buildDir.toFile().exists()) {
            buildDir.toFile().mkdir();
        }
        try {
            infoStream.write(String.format(Messages.CMakeBuildConfiguration_BuildingIn, buildDir.toString()));
            this.runCmakeCommand(console, monitor, project, generator, infoStream, buildDir);
            this.runCmakeBuildCommand(console, monitor, project, start, generator, infoStream, buildDir);
            new ClangdConfigFileHandler().update(project);
            new ClangFormatFileHandler(project).update();
            return new IProject[]{project};
        }
        catch (Exception e) {
            throw new CoreException(IDFCorePlugin.errorStatus(String.format(Messages.CMakeBuildConfiguration_Building, project.getName()), e));
        }
    }

    private boolean buildPrechecks(IConsole console) throws Exception {
        ProjectDescriptionReader projectDescriptionReader = new ProjectDescriptionReader(this.getProject());
        String projectDescriptionIdfPath = projectDescriptionReader.getIdfPath();
        java.nio.file.Path pathPdIdfPath = Paths.get(projectDescriptionIdfPath, new String[0]);
        if (StringUtil.isEmpty(projectDescriptionIdfPath)) {
            return true;
        }
        IDFEnvironmentVariables idfEnvironmentVariables = new IDFEnvironmentVariables();
        String envIdfPath = idfEnvironmentVariables.getEnvValue("IDF_PATH");
        java.nio.file.Path pathEnvIdf = Paths.get(envIdfPath, new String[0]);
        boolean samePaths = false;
        samePaths = Platform.getOS().equals("win32") ? pathEnvIdf.toString().equalsIgnoreCase(pathPdIdfPath.toString()) : pathEnvIdf.toString().equals(pathPdIdfPath.toString());
        if (!samePaths) {
            String outputMessage = MessageFormat.format(Messages.IDFBuildConfiguration_PreCheck_DifferentIdfPath, projectDescriptionIdfPath, envIdfPath);
            console.getInfoStream().write(outputMessage);
            return false;
        }
        return true;
    }

    private void runCmakeBuildCommand(IConsole console, IProgressMonitor monitor, IProject project, Instant start, String generator, ConsoleOutputStream infoStream, java.nio.file.Path buildDir) throws CoreException, IOException, CmakeBuildException {
        Throwable throwable = null;
        Object var9_10 = null;
        try (ErrorParserManager epm = new ErrorParserManager(project, this.getBuildDirectoryURI(), (IMarkerGenerator)this, this.getToolChain().getErrorParserIds());){
            IConsoleParser[] iConsoleParserArray;
            epm.setOutputStream((OutputStream)console.getOutputStream());
            List<String> command = new ArrayList<String>();
            String envStr = this.getProperty(CMAKE_ENV);
            ArrayList<EnvironmentVariable> envVars = new ArrayList<EnvironmentVariable>();
            if (envStr != null && !envStr.isBlank()) {
                List envList = CMakeUtils.stripEnvVars((String)envStr);
                for (String s : envList) {
                    int index = s.indexOf("=");
                    if (index == -1) {
                        envVars.add(new EnvironmentVariable(s));
                        continue;
                    }
                    envVars.add(new EnvironmentVariable(s.substring(0, index), s.substring(index + 1)));
                }
            }
            envVars.add(new EnvironmentVariable("IDF_TOOLS_PATH", IDFUtil.getIDFToolsPathFromPreferences()));
            String buildCommand = this.getProperty(BUILD_COMMAND);
            if (buildCommand.isBlank()) {
                command.add("cmake");
                command.add("--build");
                command.add(".");
                if (NINJA.equals(generator)) {
                    command.add("--");
                    command.add("-v");
                }
            } else {
                command.addAll(Arrays.asList(buildCommand.split(" ")));
            }
            Path workingDir = new Path(this.getBuildDirectory().toString());
            Process p = null;
            if (DfuCommandsUtil.isDfu() && DfuCommandsUtil.isDfuSupported(this.launchtarget)) {
                command = DfuCommandsUtil.getDfuBuildCommand();
                workingDir = project.getLocation();
            }
            infoStream.write(String.join((CharSequence)" ", command) + "\n");
            p = this.startBuildProcess(command, envVars.toArray(new IEnvironmentVariable[0]), (IPath)workingDir, console, monitor);
            if (p == null) {
                console.getErrorStream().write(String.format(Messages.CMakeBuildConfiguration_Failure, ""));
                throw new CmakeBuildException();
            }
            boolean buildHintsStatus = Platform.getPreferencesService().getBoolean("com.espressif.idf.core", "automateHintsStatus", true, null);
            if (buildHintsStatus) {
                IConsoleParser[] iConsoleParserArray2 = new IConsoleParser[3];
                iConsoleParserArray2[0] = epm;
                iConsoleParserArray2[1] = new StatusParser();
                iConsoleParserArray = iConsoleParserArray2;
                iConsoleParserArray2[2] = new EspIdfErrorParser(HintsUtil.getReHintsList(new File(HintsUtil.getHintsYmlPath())));
            } else {
                IConsoleParser[] iConsoleParserArray3 = new IConsoleParser[2];
                iConsoleParserArray3[0] = epm;
                iConsoleParserArray = iConsoleParserArray3;
                iConsoleParserArray3[1] = new StatusParser();
            }
            IConsoleParser[] consoleParsers = iConsoleParserArray;
            this.watchProcess(consoleParsers, monitor);
            infoStream.write(String.format(Messages.CMakeBuildConfiguration_BuildingComplete, epm.getErrorCount(), epm.getWarningCount(), buildDir.toString()));
            Instant finish = Instant.now();
            long timeElapsed = Duration.between(start, finish).toMillis();
            if (!monitor.isCanceled() && epm.getErrorCount() == 0) {
                project.refreshLocal(2, monitor);
                ParitionSizeHandler paritionSizeHandler = new ParitionSizeHandler(project, infoStream, console);
                paritionSizeHandler.startCheckingSize();
                LspService lspService = new LspService();
                lspService.updateCompileCommandsDir(buildDir.toString());
                lspService.restartLspServers();
            }
            infoStream.write(MessageFormat.format("Total time taken to build the project: {0} ms", timeElapsed));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void runCmakeCommand(IConsole console, IProgressMonitor monitor, IProject project, String generator, ConsoleOutputStream infoStream, java.nio.file.Path buildDir) throws CoreException, IOException, CmakeBuildException {
        String userArgs;
        String idfTargetName;
        IDFBuildConfiguration.deleteCMakeErrorMarkers(project);
        infoStream.write(String.format(Messages.CMakeBuildConfiguration_Configuring, buildDir));
        ArrayList<Object> command = new ArrayList<Object>();
        command.add("cmake");
        command.add("-G");
        command.add(generator);
        if (this.toolChainFile != null) {
            command.add("-DCMAKE_TOOLCHAIN_FILE=" + this.toolChainFile.getPath().toString());
        }
        command.add("-DPYTHON_DEPS_CHECKED=1");
        command.add("-DPYTHON=" + IDFUtil.getIDFPythonEnvPath());
        command.add("-DESP_PLATFORM=1");
        command.add("-DCMAKE_EXPORT_COMPILE_COMMANDS=ON");
        IDFEnvironmentVariables envVariables = new IDFEnvironmentVariables();
        String ccacheStatus = envVariables.getEnvValue("IDF_CCACHE_ENABLE");
        command.add("-DCCACHE_ENABLE=" + (ccacheStatus.isBlank() ? "0" : ccacheStatus));
        if (this.launchtarget != null && !(idfTargetName = this.launchtarget.getAttribute("com.espressif.idf.launch.serial.core.idfTarget", "")).isEmpty()) {
            command.add("-DIDF_TARGET=" + idfTargetName);
        }
        if (Objects.equals(this.getToolChain().getTypeId(), "org.eclipse.cdt.build.clang")) {
            command.add("-DIDF_TOOLCHAIN=clang");
        }
        if ((userArgs = this.getProperty(CMAKE_ARGUMENTS)) != null && !userArgs.isBlank()) {
            command.addAll(Arrays.asList(userArgs.trim().split("\\s+")));
        }
        IProject srcFolder = project;
        command.add(new File(srcFolder.getLocationURI()).getAbsolutePath());
        infoStream.write(String.join((CharSequence)" ", command) + "\n");
        Path workingDir = new Path(this.getBuildDirectory().toString());
        CMakeConsoleWrapper errConsole = new CMakeConsoleWrapper((IContainer)srcFolder, console);
        EnvironmentVariable bufferEnvVar = new EnvironmentVariable("PYTHONUNBUFFERED", "1");
        EnvironmentVariable idfToolsPathEnvVar = new EnvironmentVariable("IDF_TOOLS_PATH", IDFUtil.getIDFToolsPathFromPreferences());
        Process p = this.startBuildProcess(command, new IEnvironmentVariable[]{bufferEnvVar, idfToolsPathEnvVar}, (IPath)workingDir, errConsole, monitor);
        if (p == null) {
            console.getErrorStream().write(String.format(Messages.CMakeBuildConfiguration_Failure, ""));
            throw new CmakeBuildException();
        }
        Throwable throwable = null;
        Object var18_19 = null;
        try (ErrorParserManager epm = new ErrorParserManager(project, this.getBuildDirectoryURI(), (IMarkerGenerator)this, this.getToolChain().getErrorParserIds());){
            epm.setOutputStream((OutputStream)console.getOutputStream());
            this.watchProcess(new IConsoleParser[]{epm}, monitor);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private boolean checkToolChainFile(IConsole console) {
        try {
            if (this.toolChainFile == null && !this.isLocal()) {
                ICMakeToolChainManager manager = IDFCorePlugin.getService(ICMakeToolChainManager.class);
                this.toolChainFile = manager.getToolChainFileFor(this.getToolChain());
                if (this.toolChainFile == null) {
                    console.getErrorStream().write(Messages.IDFBuildConfiguration_CMakeBuildConfiguration_NoToolchainFile);
                    return false;
                }
            }
        }
        catch (IOException | CoreException e) {
            Logger.log((Exception)e);
        }
        return true;
    }

    private boolean checkSpacesSupport(IProject project, IConsole console) {
        if (!IDFUtil.checkIfIdfSupportsSpaces() && project.getLocation().toOSString().contains(" ")) {
            try {
                console.getErrorStream().write("Project path can\u2019t include space " + project.getLocation().toOSString());
            }
            catch (IOException | CoreException e) {
                Logger.log((Exception)e);
            }
            return false;
        }
        return true;
    }

    private boolean checkLaunchTarget(IConsole console) {
        ILaunchBarManager launchBarManager = IDFCorePlugin.getService(ILaunchBarManager.class);
        try {
            this.launchtarget = launchBarManager.getActiveLaunchTarget();
            ILaunchMode activeLaunchMode = launchBarManager.getActiveLaunchMode();
            if (this.launchtarget != null && !this.launchtarget.getTypeId().equals("com.espressif.idf.launch.serial.core.serialFlashTarget") && activeLaunchMode != null && activeLaunchMode.getIdentifier().equals("run")) {
                console.getErrorStream().write("No esp launch target found. Please create/select the correct 'Launch Target'");
                return false;
            }
        }
        catch (IOException | CoreException e) {
            Logger.log((Exception)e);
        }
        return true;
    }

    public IToolChain getToolChain() throws CoreException {
        String typeId = this.getProperty("cdt.toolChain.type");
        String id = this.getProperty("cdt.toolChain.id");
        IToolChainManager toolChainManager = (IToolChainManager)CCorePlugin.getService(IToolChainManager.class);
        ILaunchBarManager launchBarManager = (ILaunchBarManager)CCorePlugin.getService(ILaunchBarManager.class);
        ILaunchTarget activeTarget = launchBarManager.getActiveLaunchTarget();
        if (activeTarget == null) {
            return super.getToolChain();
        }
        Collection matchedToolChains = toolChainManager.getToolChainsMatching(Map.of("os", activeTarget.getAttribute("com.espressif.idf.launch.serial.core.idfTarget", ""), "cdt.toolChain.type", typeId));
        return matchedToolChains.stream().findAny().orElse(toolChainManager.getToolChain(typeId, id));
    }

    public void clean(IConsole console, IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        try {
            String generator = this.getProperty(CMAKE_GENERATOR);
            project.deleteMarkers("org.eclipse.cdt.core.problem", false, 2);
            ConsoleOutputStream outStream = console.getOutputStream();
            java.nio.file.Path buildDir = this.getBuildDirectory();
            if (!Files.exists(buildDir.resolve("CMakeFiles"), new LinkOption[0])) {
                outStream.write(Messages.CMakeBuildConfiguration_NotFound);
                return;
            }
            ArrayList<String> command = new ArrayList<String>();
            String cleanCommand = this.getProperty(CLEAN_COMMAND);
            if (cleanCommand == null || cleanCommand.isBlank()) {
                if (generator == null || generator.isBlank() || generator.equals(NINJA)) {
                    command.add("ninja");
                    command.add("clean");
                } else {
                    command.add("make");
                    command.add("clean");
                }
            } else {
                command.addAll(Arrays.asList(cleanCommand.split(" ")));
            }
            IEnvironmentVariable[] env = new IEnvironmentVariable[]{};
            outStream.write(String.join((CharSequence)" ", command) + "\n");
            Path workingDir = new Path(this.getBuildDirectory().toString());
            Process p = this.startBuildProcess(command, env, (IPath)workingDir, console, monitor);
            if (p == null) {
                console.getErrorStream().write(String.format(Messages.CMakeBuildConfiguration_Failure, ""));
                return;
            }
            this.watchProcess(console, monitor);
            outStream.write(Messages.CMakeBuildConfiguration_BuildComplete);
            project.refreshLocal(2, monitor);
        }
        catch (IOException e) {
            throw new CoreException(IDFCorePlugin.errorStatus(String.format(Messages.CMakeBuildConfiguration_Cleaning, project.getName()), e));
        }
    }

    public boolean processLine(String line) {
        return true;
    }

    public boolean processLine(String line, List<Job> jobsArray) {
        return true;
    }

    public void shutdown() {
    }

    private static void deleteCMakeErrorMarkers(IProject project) throws CoreException {
        project.deleteMarkers(CMakeErrorParser.CMAKE_PROBLEM_MARKER_ID, false, 2);
    }

    public void setLaunchTarget(ILaunchTarget target) {
        this.launchtarget = target;
    }

    class StatusParser
    implements IConsoleParser {
        StatusParser() {
        }

        public boolean processLine(String line) {
            try {
                String str;
                if (line.indexOf("[") != -1 && line.indexOf("]") != -1 && (str = line.substring(line.indexOf("[") + 1, line.indexOf("]"))).length() > 0) {
                    String[] split = str.split("/");
                    if (!IDFBuildConfiguration.this.isProgressSet && IDFBuildConfiguration.this.monitor != null && split.length > 1) {
                        IDFBuildConfiguration.this.isProgressSet = true;
                        int y = Integer.parseInt(split[1].strip());
                        IDFBuildConfiguration.this.monitor.beginTask("Building", y);
                    }
                    IDFBuildConfiguration.this.monitor.worked(1);
                }
            }
            catch (NumberFormatException e) {
                Logger.log(e, true);
            }
            return true;
        }

        public void shutdown() {
        }
    }
}

