/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.core.actions;

import com.espressif.idf.core.actions.Messages;
import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.util.LaunchTargetHelper;
import java.util.Optional;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.launchbar.core.ILaunchBarManager;
import org.eclipse.launchbar.core.target.ILaunchTarget;
import org.eclipse.launchbar.core.target.ILaunchTargetManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ApplyTargetJob
extends Job {
    private IWizard wizard;
    private ILaunchBarManager launchBarManager;
    private ILaunchTargetManager targetManager;
    private String targetNameAttr;

    public ApplyTargetJob(ILaunchBarManager launchBarManager, ILaunchTargetManager targetManager, String targetNameAttr, IWizard wizard) {
        super(Messages.SettingTargetJob);
        this.launchBarManager = launchBarManager;
        this.targetManager = targetManager;
        this.wizard = wizard;
        this.targetNameAttr = targetNameAttr;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            if (this.launchBarManager.getActiveLaunchConfiguration() == null) {
                return Status.CANCEL_STATUS;
            }
            String targetName = this.launchBarManager.getActiveLaunchConfiguration().getAttribute(this.targetNameAttr, "");
            if (!targetName.isEmpty()) {
                Optional<ILaunchTarget> optSuitableTarget = LaunchTargetHelper.findSuitableTargetForSelectedItem(this.targetManager, this.launchBarManager, targetName);
                if (optSuitableTarget.isPresent()) {
                    this.launchBarManager.setActiveLaunchTarget(optSuitableTarget.get());
                } else {
                    this.showNoTargetMessage(targetName);
                }
            }
            return Status.OK_STATUS;
        }
        catch (CoreException e) {
            Logger.log((Exception)((Object)e));
            return Status.CANCEL_STATUS;
        }
    }

    protected void showNoTargetMessage(String selectedTarget) {
        Display.getDefault().asyncExec(() -> {
            boolean isYes = MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)Messages.IDFLaunchTargetNotFoundIDFLaunchTargetNotFoundTitle, (String)(Messages.IDFLaunchTargetNotFoundMsg1 + selectedTarget + Messages.IDFLaunchTargetNotFoundMsg2 + Messages.IDFLaunchTargetNotFoundMsg3));
            if (isYes) {
                WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), this.wizard);
                dialog.open();
            }
        });
    }
}

