/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.core;

import com.espressif.idf.core.DefaultSystemWrapper;
import com.espressif.idf.core.ExecutableFinder;
import com.espressif.idf.core.SystemWrapper;
import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.util.IDFUtil;
import com.espressif.idf.core.util.StringUtil;
import com.espressif.idf.core.util.WinNativeFileTagOperations;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;

public class SystemExecutableFinder
implements ExecutableFinder {
    private SystemWrapper systemWrapper;

    public SystemExecutableFinder() {
        this.systemWrapper = new DefaultSystemWrapper();
    }

    public SystemExecutableFinder(SystemWrapper systemWrapper) {
        this.systemWrapper = systemWrapper;
    }

    @Override
    public IPath find(String executableName) {
        String[] paths;
        if (executableName == null) {
            return null;
        }
        String pathENV = this.systemWrapper.getPathEnv();
        if (StringUtil.isEmpty(pathENV)) {
            return null;
        }
        String[] stringArray = paths = pathENV.split(File.pathSeparator);
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String pathString = stringArray[n2];
            IPath path = Path.fromOSString((String)pathString).append(executableName);
            IPath execPath = this.findExecutable(path);
            if (execPath != null) {
                return execPath;
            }
            ++n2;
        }
        return null;
    }

    private IPath findExecutable(IPath path) {
        if (this.isPlatformWindows()) {
            String[] extensions;
            String pathExt = this.systemWrapper.getEnvExecutables();
            if (StringUtil.isEmpty(pathExt)) {
                return null;
            }
            String[] stringArray = extensions = this.systemWrapper.getEnvExecutables().split(File.pathSeparator);
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IPath pathWithExt;
                String ext = stringArray[n2];
                if (ext.length() > 0 && ext.charAt(0) == '.') {
                    ext = ext.substring(1);
                }
                if (this.isExecutable(pathWithExt = path.addFileExtension(ext))) {
                    return pathWithExt;
                }
                ++n2;
            }
        } else {
            try {
                Runtime.getRuntime().exec("/bin/chmod 755 ".concat(path.toOSString()));
            }
            catch (IOException e) {
                Logger.log(e);
            }
            if (this.isExecutable(path)) {
                return path;
            }
        }
        return null;
    }

    protected boolean isPlatformWindows() {
        return "win32".equals(Platform.getOS());
    }

    private boolean isExecutable(IPath path) {
        File file = path.toFile();
        if (this.isPlatformWindows() && !file.exists() && WinNativeFileTagOperations.fileExists(file)) {
            return IDFUtil.isReparseTag(file);
        }
        if (!file.exists() || file.isDirectory()) {
            return false;
        }
        return file.canExecute();
    }
}

