/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.debug.gdbjtag.openocd.dsf;

import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.util.IDFUtil;
import com.espressif.idf.debug.gdbjtag.openocd.Activator;
import com.espressif.idf.debug.gdbjtag.openocd.dsf.IdfHardwareWatchpoints;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.embedcdt.core.EclipseUtils;
import org.eclipse.embedcdt.core.StringUtils;
import org.eclipse.embedcdt.debug.gdbjtag.core.DebugUtils;
import org.eclipse.embedcdt.debug.gdbjtag.core.dsf.GnuMcuDebuggerCommandsService;
import org.osgi.framework.BundleContext;

public class DebuggerCommands
extends GnuMcuDebuggerCommandsService {
    public DebuggerCommands(DsfSession session, ILaunchConfiguration lc, String mode) {
        super(session, lc, mode, true);
    }

    protected BundleContext getBundleContext() {
        return Activator.getInstance().getBundle().getBundleContext();
    }

    public IStatus addGdbInitCommandsCommands(List<String> commandsList) {
        String otherInits = ((String)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"com.espressif.idf.debug.gdbjtag.openocd.gdbClientOtherCommands", (Object)"set mem inaccessible-by-default off\nset remotetimeout 20")).trim();
        otherInits = DebugUtils.resolveAll((String)otherInits, (Map)this.fAttributes);
        DebugUtils.addMultiLine((String)otherInits, commandsList);
        return Status.OK_STATUS;
    }

    public IStatus addGnuMcuResetCommands(List<String> commandsList) {
        IStatus status = this.addFirstResetCommands(commandsList);
        if (!status.isOK()) {
            return status;
        }
        status = this.addLoadSymbolsCommands(commandsList);
        if (!status.isOK()) {
            return status;
        }
        if (((Boolean)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"org.eclipse.cdt.debug.gdbjtag.core.loadImage", (Object)false)).booleanValue() && !((Boolean)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"com.espressif.idf.debug.gdbjtag.openocd.doDebugInRam", (Object)false)).booleanValue() && !(status = this.addLoadImageCommands(commandsList)).isOK()) {
            return status;
        }
        return Status.OK_STATUS;
    }

    public IStatus addGnuMcuStartCommands(List<String> commandsList) {
        IStatus status = this.addStartRestartCommands(true, commandsList);
        if (!status.isOK()) {
            return status;
        }
        return Status.OK_STATUS;
    }

    public IStatus addFirstResetCommands(List<String> commandsList) {
        if (((Boolean)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"com.espressif.idf.debug.gdbjtag.openocd.doFirstReset", (Object)true)).booleanValue()) {
            String commandStr = "monitor reset ";
            String resetType = (String)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"com.espressif.idf.debug.gdbjtag.openocd.firstResetType", (Object)"init");
            commandsList.add(commandStr + resetType);
            commandStr = "monitor halt";
            commandsList.add(commandStr);
        }
        String otherInits = ((String)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"com.espressif.idf.debug.gdbjtag.openocd.otherInitCommands", (Object)"mon reset halt\nflushregs\nset remote hardware-watchpoint-limit {IDF_TARGET_CPU_WATCHPOINT_NUM}")).trim();
        otherInits = otherInits.replace("{IDF_TARGET_CPU_WATCHPOINT_NUM}", String.valueOf(IdfHardwareWatchpoints.getWatchpointNumForTarget(IDFUtil.getCurrentTarget())));
        otherInits = DebugUtils.resolveAll((String)otherInits, (Map)this.fAttributes);
        if (this.fDoDoubleBackslash && EclipseUtils.isWindows()) {
            otherInits = StringUtils.duplicateBackslashes((String)otherInits);
        }
        Logger.log((String)("Initialization Commands::" + otherInits));
        DebugUtils.addMultiLine((String)otherInits, commandsList);
        if (((Boolean)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"com.espressif.idf.debug.gdbjtag.openocd.enableSemihosting", (Object)true)).booleanValue()) {
            String commandStr = "monitor arm semihosting enable";
            commandsList.add(commandStr);
        }
        return Status.OK_STATUS;
    }

    public IStatus addStartRestartCommands(boolean doReset, List<String> commandsList) {
        IStatus status;
        if (doReset && ((Boolean)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"com.espressif.idf.debug.gdbjtag.openocd.doSecondReset", (Object)true)).booleanValue()) {
            String commandStr = "monitor reset ";
            String resetType = (String)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"com.espressif.idf.debug.gdbjtag.openocd.secondResetType", (Object)"halt");
            commandsList.add(commandStr + resetType);
            commandStr = "monitor halt";
            commandsList.add(commandStr);
        }
        if (((Boolean)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"org.eclipse.cdt.debug.gdbjtag.core.loadImage", (Object)false)).booleanValue() && ((Boolean)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"com.espressif.idf.debug.gdbjtag.openocd.doDebugInRam", (Object)false)).booleanValue() && !(status = this.addLoadImageCommands(commandsList)).isOK()) {
            return status;
        }
        String userCmd = ((String)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"com.espressif.idf.debug.gdbjtag.openocd.otherRunCommands", (Object)"")).trim();
        userCmd = DebugUtils.resolveAll((String)userCmd, (Map)this.fAttributes);
        if (this.fDoDoubleBackslash && EclipseUtils.isWindows()) {
            userCmd = StringUtils.duplicateBackslashes((String)userCmd);
        }
        DebugUtils.addMultiLine((String)userCmd, commandsList);
        this.addSetPcCommands(commandsList);
        this.addStopAtCommands(commandsList);
        commandsList.add("monitor reg");
        if (((Boolean)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"com.espressif.idf.debug.gdbjtag.openocd.doContinue", (Object)true)).booleanValue()) {
            commandsList.add("continue");
        }
        return Status.OK_STATUS;
    }
}

