/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.overridemethods;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.internal.ui.refactoring.overridemethods.Method;
import org.eclipse.cdt.internal.ui.refactoring.overridemethods.OverrideOptions;
import org.eclipse.jface.viewers.ITreeContentProvider;

public class VirtualMethodContainer
implements ITreeContentProvider {
    private Map<ICPPClassType, List<Method>> fData = new HashMap<ICPPClassType, List<Method>>();
    private final OverrideOptions fOptions;

    public VirtualMethodContainer(OverrideOptions options) {
        this.fOptions = options;
    }

    public Object[] getElements(Object inputElement) {
        if (!(inputElement instanceof Map)) {
            return null;
        }
        return this.fData.keySet().toArray(new ICPPClassType[this.fData.keySet().size()]);
    }

    public Object[] getChildren(Object parentElement) {
        return this.fData.get(parentElement).toArray();
    }

    public List<Method> getMethods(ICPPClassType classType) {
        return this.fData.get(classType);
    }

    public Object getParent(Object element) {
        for (Map.Entry<ICPPClassType, List<Method>> entry : this.fData.entrySet()) {
            if (!entry.getValue().contains(element)) continue;
            return entry.getKey();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        List<Method> list = this.fData.get(element);
        if (list == null) {
            return false;
        }
        return !list.isEmpty();
    }

    public List<Method> getAllMethods() {
        ArrayList<Method> allMethods = new ArrayList<Method>();
        for (Map.Entry<ICPPClassType, List<Method>> entry : this.fData.entrySet()) {
            allMethods.addAll((Collection<Method>)entry.getValue());
        }
        return allMethods;
    }

    public Map<ICPPClassType, List<Method>> getInitialInput() {
        return this.fData;
    }

    private boolean isDuplicate(Method method) {
        for (Map.Entry<ICPPClassType, List<Method>> entry : this.fData.entrySet()) {
            if (!entry.getValue().contains(method)) continue;
            return true;
        }
        return false;
    }

    private void addMethodToClass(ICPPClassType classType, Method method) {
        if (!this.isDuplicate(method)) {
            List<Method> methods = this.fData.get(classType);
            if (methods == null) {
                methods = new ArrayList<Method>();
                this.fData.put(classType, methods);
            }
            methods.add(method);
        }
    }

    public void addMethodsToClass(ICPPClassType classType, ICPPMethod[] methods, IASTDeclSpecifier declSpecifier) {
        ICPPMethod[] iCPPMethodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPMethod icppMethod = iCPPMethodArray[n2];
            this.addMethodToClass(classType, new Method(icppMethod, declSpecifier, this.fOptions));
            ++n2;
        }
    }

    public boolean isEmpty() {
        return this.fData.isEmpty();
    }

    public void remove(ICPPMethod method) {
        for (Map.Entry<ICPPClassType, List<Method>> entry : this.fData.entrySet()) {
            List<Method> methods = entry.getValue();
            if (!methods.remove(new Method(method, this.fOptions))) continue;
            if (!methods.isEmpty()) break;
            this.fData.remove(entry.getKey());
            break;
        }
    }
}

