/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.checkers;

import org.eclipse.cdt.codan.core.cxx.model.AbstractIndexAstChecker;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTReturnStatement;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;

public class ReturnStyleChecker
extends AbstractIndexAstChecker {
    public static final String ERR_ID = "org.eclipse.cdt.codan.internal.checkers.ReturnStyleProblem";

    public boolean runInEditor() {
        return true;
    }

    public void processAst(IASTTranslationUnit ast) {
        ast.accept(new ASTVisitor(){
            {
                this.shouldVisitStatements = true;
            }

            public int visit(IASTStatement statement) {
                if (statement instanceof IASTReturnStatement) {
                    IASTUnaryExpression unaryExpression;
                    boolean isValidStyle = false;
                    IASTNode[] children = statement.getChildren();
                    if (children.length == 0) {
                        isValidStyle = true;
                    } else if (children.length == 1 && children[0] instanceof IASTUnaryExpression && (unaryExpression = (IASTUnaryExpression)children[0]).getOperator() == 11) {
                        isValidStyle = true;
                    }
                    if (!isValidStyle) {
                        ReturnStyleChecker.this.reportProblem(ReturnStyleChecker.ERR_ID, (IASTNode)statement, new Object[0]);
                    }
                }
                return 3;
            }
        });
    }
}

