/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.tracing;

import com.espressif.idf.ui.tracing.AddressInfoVO;
import com.espressif.idf.ui.tracing.DetailsVO;
import com.espressif.idf.ui.tracing.EventsVO;
import com.espressif.idf.ui.tracing.StreamEventsDeserializer;
import com.espressif.idf.ui.tracing.StreamEventsVO;
import com.espressif.idf.ui.tracing.TracingCallerAddressDecoder;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;

public class TracingJsonParser {
    private String jsonFilePath;
    private IFile elfFilePath;
    private Gson gson;
    private int allocEventId;
    private int freeEventId;
    private List<EventsVO> eventsVOs;
    private List<StreamEventsVO> streamEventsVOs;
    private Map<String, AddressInfoVO> callersAddressMap;
    private TracingCallerAddressDecoder tracingCallerAddressDecoder;

    public TracingJsonParser(String jsonFilePath, IFile elfFilePath) throws FileNotFoundException {
        this.jsonFilePath = jsonFilePath;
        this.setElfFilePath(elfFilePath);
        this.gson = new GsonBuilder().registerTypeAdapter(ArrayList.class, (Object)new StreamEventsDeserializer()).create();
        this.tracingCallerAddressDecoder = new TracingCallerAddressDecoder(elfFilePath.getRawLocation().toOSString(), elfFilePath.getProject());
        this.loadJson();
    }

    private void loadJson() throws FileNotFoundException {
        JsonReader jsonReader = new JsonReader((Reader)new FileReader(this.jsonFilePath));
        JsonObject json = (JsonObject)this.gson.fromJson(jsonReader, JsonObject.class);
        this.streamEventsVOs = (List)this.gson.fromJson(json.toString(), ArrayList.class);
        Optional<StreamEventsVO> oStreamEventsVO = this.getStreamEventsVOs().stream().filter(stream -> stream.getStreamName().equals("heap")).findAny();
        if (oStreamEventsVO.isPresent()) {
            this.allocEventId = oStreamEventsVO.get().getStreamEventIdMap().get("alloc");
            this.freeEventId = oStreamEventsVO.get().getStreamEventIdMap().get("free");
        }
        JsonArray eventsArray = json.getAsJsonObject().getAsJsonArray("events");
        this.eventsVOs = new ArrayList<EventsVO>(100);
        int i = 0;
        while (i < eventsArray.size()) {
            EventsVO eventsVO = (EventsVO)new Gson().fromJson(eventsArray.get(i), EventsVO.class);
            this.eventsVOs.add(eventsVO);
            ++i;
        }
        LinkedList<String> callersList = new LinkedList<String>();
        for (EventsVO eventsVO : this.eventsVOs) {
            if (eventsVO.getCallersAddressList() == null) continue;
            callersList.addAll(eventsVO.getCallersAddressList());
        }
        this.setCallersAddressMap(this.tracingCallerAddressDecoder.decodeCallerAddresses(callersList.stream().filter(addr -> !addr.equals("0x0")).collect(Collectors.toList())));
    }

    public List<EventsVO> getAllocEvents() {
        return this.getEventsVOs().stream().filter(event -> event.getEventId() == this.getAllocEventId()).collect(Collectors.toList());
    }

    public List<EventsVO> getFreeEvents() {
        return this.getEventsVOs().stream().filter(event -> event.getEventId() == this.getFreeEventId()).collect(Collectors.toList());
    }

    public int getAllocEventId() {
        return this.allocEventId;
    }

    public int getFreeEventId() {
        return this.freeEventId;
    }

    public List<EventsVO> getEventsVOs() {
        return this.eventsVOs;
    }

    public List<StreamEventsVO> getStreamEventsVOs() {
        return this.streamEventsVOs;
    }

    public void setStreamEventsVOs(List<StreamEventsVO> streamEventsVOs) {
        this.streamEventsVOs = streamEventsVOs;
    }

    public Map<String, Integer> getAllEventsNameIdMap() {
        HashMap<String, Integer> eventsNameIdMap = new HashMap<String, Integer>();
        for (StreamEventsVO streamEventsVO : this.streamEventsVOs) {
            eventsNameIdMap.putAll(streamEventsVO.getStreamEventIdMap());
        }
        return eventsNameIdMap;
    }

    public List<DetailsVO> getDetailsVOs(List<Integer> eventIds) {
        LinkedList<DetailsVO> detailsVOs = new LinkedList<DetailsVO>();
        List events = this.getEventsVOs().stream().filter(event -> eventIds.contains(event.getEventId())).collect(Collectors.toList());
        List<StreamEventsVO> streamEvents = this.getStreamEventsVOs();
        for (EventsVO eventVo : events) {
            DetailsVO detailsVO = new DetailsVO();
            detailsVO.setEventsVO(eventVo);
            Optional<StreamEventsVO> optionalStream = streamEvents.stream().filter(streamEvent -> streamEvent.getStreamEventIdMap().containsValue(eventVo.getEventId())).findAny();
            if (optionalStream.get() == null) continue;
            StreamEventsVO stream = optionalStream.get();
            detailsVO.setStreamName(stream.getStreamName());
            for (String eventName : stream.getStreamEventIdMap().keySet()) {
                if (stream.getStreamEventIdMap().get(eventName).intValue() != eventVo.getEventId()) continue;
                detailsVO.setEventName(eventName);
                break;
            }
            detailsVO.setMemoryLeak(!this.getFreeEvents().stream().filter(event -> event.getAddressOfAllocatedMemoryBlock().equals(eventVo.getAddressOfAllocatedMemoryBlock())).findAny().isPresent());
            detailsVOs.add(detailsVO);
        }
        return detailsVOs;
    }

    public IFile getElfFilePath() {
        return this.elfFilePath;
    }

    public void setElfFilePath(IFile elfFilePath) {
        this.elfFilePath = elfFilePath;
    }

    public Map<String, AddressInfoVO> getCallersAddressMap() {
        return this.callersAddressMap;
    }

    public void setCallersAddressMap(Map<String, AddressInfoVO> callersAddressMap) {
        this.callersAddressMap = callersAddressMap;
    }
}

