/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.tools;

import com.espressif.idf.core.IDFEnvironmentVariables;
import com.espressif.idf.core.build.Messages;
import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.tools.DownloadListener;
import com.espressif.idf.core.tools.EimLoader;
import com.espressif.idf.core.tools.ToolInitializer;
import com.espressif.idf.core.tools.exceptions.EimVersionMismatchException;
import com.espressif.idf.core.tools.vo.EimJson;
import com.espressif.idf.core.tools.watcher.EimJsonChangeListener;
import com.espressif.idf.core.tools.watcher.EimJsonWatchService;
import com.espressif.idf.core.util.IDFUtil;
import com.espressif.idf.core.util.StringUtil;
import com.espressif.idf.ui.GlobalModalLock;
import com.espressif.idf.ui.IDFConsole;
import com.espressif.idf.ui.handlers.EclipseHandler;
import com.espressif.idf.ui.tools.manager.EimEditorInput;
import com.espressif.idf.ui.tools.watcher.EimJsonUiChangeHandler;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.ide.IDE;
import org.osgi.service.prefs.Preferences;

public class EspressifToolStartup
implements IStartup {
    private EimJsonUiChangeHandler eimJsonUiChangeHandler;
    private ToolInitializer toolInitializer;
    private Preferences preferences;
    private EimJson eimJson;
    private EimLoader eimLoader;
    private MessageConsoleStream standardConsoleStream;
    private MessageConsoleStream errorConsoleStream;
    private IDFEnvironmentVariables idfEnvironmentVariables;

    public void earlyStartup() {
        this.preferences = InstanceScope.INSTANCE.getNode("com.espressif.idf.ui");
        this.toolInitializer = new ToolInitializer(this.preferences);
        this.standardConsoleStream = this.getConsoleStream(false);
        this.errorConsoleStream = this.getConsoleStream(true);
        this.idfEnvironmentVariables = new IDFEnvironmentVariables();
        this.eimLoader = new EimLoader((DownloadListener)new StartupClassDownloadEimDownloadListener(), this.standardConsoleStream, this.errorConsoleStream, Display.getDefault());
        this.eimJsonUiChangeHandler = new EimJsonUiChangeHandler(this.preferences);
        EimJsonWatchService.getInstance().addEimJsonChangeListener((EimJsonChangeListener)this.eimJsonUiChangeHandler);
        if (!this.toolInitializer.isEimInstalled() && !this.toolInitializer.isEimIdfJsonPresent()) {
            Logger.log((String)"EIM not installed");
            this.notifyMissingTools();
            return;
        }
        try {
            this.eimJson = this.toolInitializer.loadEimJson();
        }
        catch (EimVersionMismatchException e) {
            Logger.log((Exception)((Object)e));
            return;
        }
        if (this.toolInitializer.isOldEspIdfConfigPresent() && !this.toolInitializer.isOldConfigExported()) {
            Logger.log((String)"Old configuration found and not converted");
            this.closeEspIdfManager();
            boolean isEimInApplications = this.checkIfEimPathMacOsIsInApplications();
            if (!isEimInApplications) {
                this.promptUserToMoveEimToApplications();
            }
            EimJsonWatchService.withPausedListeners(() -> this.handleOldConfigExport());
        } else if (this.toolInitializer.isEimIdfJsonPresent() && !this.toolInitializer.isEspIdfSet()) {
            this.promptUserToOpenToolManager(this.eimJson);
        }
        if (this.eimJson != null) {
            this.idfEnvironmentVariables.addEnvVariable("EIM_PATH", this.eimJson.getEimPath());
        } else {
            this.toolInitializer.findAndSetEimPath();
        }
    }

    private boolean checkIfEimPathMacOsIsInApplications() {
        if (!Platform.getOS().equals("macosx")) {
            return true;
        }
        String eimPath = this.idfEnvironmentVariables.getEnvValue("EIM_PATH");
        if (!StringUtil.isEmpty((String)eimPath) && Files.exists(Paths.get(eimPath, new String[0]), new LinkOption[0])) {
            boolean isInApplications;
            boolean bl = isInApplications = eimPath.startsWith("/Applications/") || eimPath.startsWith(System.getProperty("user.home") + "/Applications/");
            if (!isInApplications) {
                Logger.log((String)("EIM_PATH not in applications: " + eimPath));
                return false;
            }
        }
        return true;
    }

    private void handleOldConfigExport() {
        Display display = Display.getDefault();
        display.asyncExec(() -> this.startExportOldConfig());
    }

    private void startExportOldConfig() {
        try {
            String eimPathEnvVar = this.idfEnvironmentVariables.getEnvValue("EIM_PATH");
            Path eimPath = this.eimJson != null ? Paths.get(this.eimJson.getEimPath(), new String[0]) : (!StringUtil.isEmpty((String)eimPathEnvVar) ? Paths.get(eimPathEnvVar, new String[0]) : this.toolInitializer.getDefaultEimPath());
            IStatus status = this.toolInitializer.exportOldConfig(eimPath);
            Logger.log((String)"Tools Conversion Process Message: ");
            Logger.log((String)status.getMessage());
            if (status.getSeverity() != 4) {
                this.preferences.putBoolean("OLD_CONFIG_EXPORTED_FLAG", true);
                this.writeToStandardConsoleStream(Messages.OldConfigExportCompleteSuccessMsg);
            } else {
                this.writeToErrorConsoleStream(Messages.OldConfigExportCompleteFailMsg);
            }
        }
        catch (IOException e) {
            Logger.log((String)"Error exporting old configuration", (Exception)e);
            this.writeToErrorConsoleStream(Messages.OldConfigExportCompleteFailMsg);
        }
    }

    private void writeToStandardConsoleStream(String msg) {
        try {
            this.standardConsoleStream.write(msg);
        }
        catch (IOException e) {
            Logger.log((Exception)e);
        }
    }

    private void writeToErrorConsoleStream(String msg) {
        try {
            this.errorConsoleStream.write(msg);
        }
        catch (IOException e) {
            Logger.log((Exception)e);
        }
    }

    private void closeEspIdfManager() {
        Display.getDefault().asyncExec(() -> {
            IWorkbenchPage page;
            IWorkbenchWindow window = EclipseHandler.getActiveWorkbenchWindow();
            if (window != null && (page = window.getActivePage()) != null) {
                IEditorReference[] editors;
                IEditorReference[] iEditorReferenceArray = editors = page.getEditorReferences();
                int n = editors.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorPart editor;
                    IEditorReference editorRef = iEditorReferenceArray[n2];
                    if ("com.espressif.idf.ui.manageespidf".equals(editorRef.getId()) && (editor = editorRef.getEditor(false)) != null) {
                        page.closeEditor(editor, false);
                    }
                    ++n2;
                }
            }
        });
    }

    private void notifyMissingTools() {
        GlobalModalLock.showModal(() -> MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)Messages.ToolsInitializationEimMissingMsgBoxTitle, (String)Messages.ToolsInitializationEimMissingMsgBoxMessage), response -> {
            if (response.booleanValue()) {
                this.downloadAndLaunchEim();
            } else {
                Logger.log((String)"User selected No to download EIM");
            }
        });
    }

    private void downloadAndLaunchEim() {
        Job downloadJob = new Job("Download and Launch EIM"){

            protected IStatus run(IProgressMonitor monitor) {
                EspressifToolStartup.this.eimLoader.downloadEim(monitor);
                return Status.OK_STATUS;
            }
        };
        downloadJob.setUser(true);
        downloadJob.schedule();
    }

    private MessageConsoleStream getConsoleStream(boolean errorStream) {
        IDFConsole idfConsole = new IDFConsole();
        return idfConsole.getConsoleStream("EIM Launch Console", null, errorStream);
    }

    private void promptUserToOpenToolManager(EimJson eimJson) {
        Display.getDefault().syncExec(() -> {
            String testRunValue = System.getProperty("testRun");
            Logger.log((String)("testRun: " + testRunValue));
            if (!StringUtil.isEmpty((String)testRunValue) && Boolean.parseBoolean(testRunValue)) {
                this.openEspIdfManager(eimJson);
                return;
            }
            Shell shell = Display.getDefault().getActiveShell();
            MessageBox messageBox = new MessageBox(shell, 200);
            messageBox.setText(Messages.NoActiveEspIdfInWorkspaceMsgTitle);
            messageBox.setMessage(Messages.NoActiveEspIdfInWorkspaceMsg);
            GlobalModalLock.showModal(() -> ((MessageBox)messageBox).open(), response -> {
                if (response == 64) {
                    this.openEspIdfManager(eimJson);
                }
            });
        });
    }

    private void promptUserToMoveEimToApplications() {
        GlobalModalLock.showModal(() -> {
            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.EIMNotInApplicationsTitle, (String)Messages.EIMNotInApplicationsMessage);
            return null;
        }, ignored -> {});
    }

    private void openEspIdfManager(EimJson eimJson) {
        Display.getDefault().asyncExec(() -> {
            IWorkbenchWindow window = EclipseHandler.getActiveWorkbenchWindow();
            try {
                EimEditorInput input = new EimEditorInput(eimJson);
                input.setFirstStartup(true);
                IDE.openEditor((IWorkbenchPage)window.getActivePage(), (IEditorInput)input, (String)"com.espressif.idf.ui.manageespidf");
                IDFUtil.closeWelcomePage((IWorkbenchWindow)window);
            }
            catch (PartInitException e) {
                Logger.log((Exception)((Object)e));
            }
        });
    }

    private class StartupClassDownloadEimDownloadListener
    implements DownloadListener {
        private StartupClassDownloadEimDownloadListener() {
        }

        public void onProgress(int percent) {
            Display.getDefault().asyncExec(() -> {
                try {
                    int blocks = percent / 10;
                    String bar = "[" + "#".repeat(blocks) + " ".repeat(10 - blocks) + "] " + percent + "%";
                    EspressifToolStartup.this.standardConsoleStream.write("\r" + bar);
                }
                catch (IOException e) {
                    Logger.log((Exception)e);
                }
            });
        }

        public void onCompleted(String filePath) {
            Display.getDefault().syncExec(() -> {
                try {
                    EspressifToolStartup.this.standardConsoleStream.write("\nEIM Downloaded to: " + filePath + "\nLaunching...\n");
                }
                catch (IOException e) {
                    Logger.log((Exception)e);
                }
            });
            Process process = null;
            String appToLaunch = filePath;
            try {
                if (filePath.endsWith(".dmg")) {
                    appToLaunch = EspressifToolStartup.this.eimLoader.installAndLaunchDmg(Paths.get(filePath, new String[0]));
                }
                EspressifToolStartup.this.idfEnvironmentVariables.addEnvVariable("EIM_PATH", appToLaunch);
                process = EspressifToolStartup.this.eimLoader.launchEim(appToLaunch);
            }
            catch (IOException | InterruptedException e) {
                Logger.log((Exception)e);
            }
            EspressifToolStartup.this.eimLoader.waitForEimClosure(process, () -> {
                if (EspressifToolStartup.this.toolInitializer.isOldEspIdfConfigPresent() && !EspressifToolStartup.this.toolInitializer.isOldConfigExported()) {
                    Logger.log((String)"Old configuration found and not converted");
                    EspressifToolStartup.this.handleOldConfigExport();
                }
                try {
                    EspressifToolStartup.this.eimJson = EspressifToolStartup.this.toolInitializer.loadEimJson();
                }
                catch (EimVersionMismatchException e) {
                    Logger.log((Exception)((Object)e));
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)e.msgTitle(), (String)e.getMessage());
                    return;
                }
                EspressifToolStartup.this.openEspIdfManager(EspressifToolStartup.this.eimJson);
            });
        }

        public void onError(String message, Exception e) {
            Display.getDefault().asyncExec(() -> {
                try {
                    EspressifToolStartup.this.errorConsoleStream.write("Download Failed: " + e.getMessage());
                }
                catch (IOException e1) {
                    Logger.log((Exception)e1);
                }
            });
        }
    }
}

