/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.size;

import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.ui.size.IDFSizeDataManager;
import com.espressif.idf.ui.size.Messages;
import org.eclipse.core.resources.IFile;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class IDFSizeOverviewComposite {
    private Table table;
    private JSONObject overviewJson;
    private Font boldFont;
    private MemoryUnit selectedUnit = MemoryUnit.KILOBYTES;

    public void createPartControl(Composite parent, IFile file, String targetName) {
        String[] columns;
        parent.setLayout((Layout)new GridLayout(2, false));
        parent.setBackground(parent.getDisplay().getSystemColor(1));
        Label title = new Label(parent, 0);
        title.setText(Messages.IDFSizeOverviewComposite_ApplicatoinMemoryUsage);
        title.setFont(this.applyBold(title.getFont()));
        title.setBackground(parent.getBackground());
        GridData titleData = new GridData(16384, 128, true, false, 2, 1);
        title.setLayoutData((Object)titleData);
        Label unitLabel = new Label(parent, 0);
        unitLabel.setText(Messages.IDFSizeChartsComposite_SizeUnit);
        unitLabel.setBackground(parent.getBackground());
        Combo unitCombo = new Combo(parent, 12);
        unitCombo.setItems(new String[]{"Bytes", "KB", "MB"});
        unitCombo.select(1);
        unitCombo.addListener(13, e -> {
            this.selectedUnit = switch (unitCombo.getSelectionIndex()) {
                case 0 -> MemoryUnit.BYTES;
                case 2 -> MemoryUnit.MEGABYTES;
                default -> MemoryUnit.KILOBYTES;
            };
            this.populateTable();
        });
        this.table = new Table(parent, 592384);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.table.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        String[] stringArray = columns = new String[]{"Region", "Used", "Free", "Total", "Usage"};
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            String colName = stringArray[n2];
            TableColumn col = new TableColumn(this.table, 0);
            col.setText(colName);
            col.setWidth(150);
            ++n2;
        }
        this.overviewJson = this.getIDFSizeOverviewData(file, targetName);
        this.populateTable();
        Font headerFont = this.applyBold(this.table.getFont());
        this.table.setFont(headerFont);
    }

    private void populateTable() {
        this.table.removeAll();
        if (this.overviewJson == null || this.overviewJson.isEmpty() || !this.overviewJson.containsKey((Object)"layout")) {
            TableItem errorItem = new TableItem(this.table, 0);
            errorItem.setText(0, Messages.IDFSizeOverviewComposite_NoExpectedOutputMsg);
            errorItem.setForeground(0, this.table.getDisplay().getSystemColor(3));
            return;
        }
        JSONArray layout = (JSONArray)this.overviewJson.get((Object)"layout");
        long grandUsed = 0L;
        long grandFree = 0L;
        int rowIndex = 0;
        for (Object obj : layout) {
            JSONObject section = (JSONObject)obj;
            String name = (String)section.get((Object)"name");
            long used = (Long)section.get((Object)"used");
            long free = (Long)section.get((Object)"free");
            long total = (Long)section.get((Object)"total");
            grandUsed += used;
            grandFree += free;
            TableItem item = new TableItem(this.table, 0);
            item.setText(new String[]{name, this.formatMemory(used), this.formatMemory(free), this.formatMemory(total), ""});
            this.applyBoldToColumn(item, 0);
            this.createProgressBar(rowIndex, used, total);
            ++rowIndex;
        }
        TableItem totalRow = new TableItem(this.table, 0);
        totalRow.setText(new String[]{"Total:", this.formatMemory(grandUsed), this.formatMemory(grandFree), this.formatMemory(grandUsed + grandFree), ""});
        int i = 0;
        while (i < 5) {
            this.applyBoldToColumn(totalRow, i);
            ++i;
        }
        this.createProgressBar(rowIndex, grandUsed, grandUsed + grandFree);
    }

    private void createProgressBar(int rowIndex, long used, long total) {
        if (total == 0L) {
            return;
        }
        TableEditor editor = new TableEditor(this.table);
        editor.grabHorizontal = true;
        editor.grabVertical = true;
        editor.horizontalAlignment = 4;
        Composite barComposite = new Composite((Composite)this.table, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        barComposite.setLayout((Layout)layout);
        barComposite.setBackground(this.table.getBackground());
        ProgressBar bar = new ProgressBar(barComposite, 256);
        bar.setMaximum((int)total);
        bar.setSelection((int)used);
        GridData barData = new GridData(4, 0x1000000, true, false);
        barData.widthHint = 100;
        bar.setLayoutData((Object)barData);
        Label percent = new Label(barComposite, 0);
        percent.setText(this.getUsagePercent(used, total));
        percent.setBackground(barComposite.getBackground());
        percent.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        editor.setEditor((Control)barComposite, this.table.getItem(rowIndex), 4);
    }

    private void applyBoldToColumn(TableItem item, int columnIndex) {
        Font bold = this.applyBold(item.getFont());
        item.setFont(columnIndex, bold);
    }

    private String formatMemory(long bytes) {
        double value = (double)bytes / (double)this.selectedUnit.getDivider();
        return String.format("%.1f %s", value, this.selectedUnit.getLabel());
    }

    private String getUsagePercent(long used, long total) {
        if (total == 0L) {
            return "-";
        }
        double percent = (double)used / (double)total * 100.0;
        return String.format("%.1f%%", percent);
    }

    private Font applyBold(Font original) {
        FontData[] data;
        if (this.boldFont != null) {
            return this.boldFont;
        }
        FontData[] fontDataArray = data = original.getFontData();
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            FontData d = fontDataArray[n2];
            d.setStyle(1);
            ++n2;
        }
        this.boldFont = new Font(original.getDevice(), data);
        return this.boldFont;
    }

    protected JSONObject getIDFSizeOverviewData(IFile file, String targetName) {
        try {
            return new IDFSizeDataManager().getIDFSizeOverview(file);
        }
        catch (Exception e) {
            Logger.log((Exception)e);
            return null;
        }
    }

    private static enum MemoryUnit {
        BYTES(1L, "B"),
        KILOBYTES(1024L, "KB"),
        MEGABYTES(0x100000L, "MB");

        private final long divider;
        private final String label;

        private MemoryUnit(long divider, String label) {
            this.divider = divider;
            this.label = label;
        }

        public long getDivider() {
            return this.divider;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

