/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.partitiontable.handlers;

import com.espressif.idf.core.util.PartitionTableDataUtil;
import com.espressif.idf.core.util.SDKConfigJsonReader;
import com.espressif.idf.ui.EclipseUtil;
import com.espressif.idf.ui.partitiontable.dialog.PartitionTableEditorDialog;
import com.espressif.idf.ui.partitiontable.handlers.Messages;
import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class PartitionTableEditorHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        PartitionTableEditorDialog dialog = new PartitionTableEditorDialog(Display.getDefault().getActiveShell());
        IProject selectedProject = EclipseUtil.getSelectedProjectInExplorer();
        SDKConfigJsonReader reader = new SDKConfigJsonReader(selectedProject);
        String csvName = reader.getValue("PARTITION_TABLE_CUSTOM_FILENAME");
        if (csvName == null || csvName.isBlank()) {
            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.PartitionTableEditorHandler_InformationTitle, (String)Messages.PartitionTableEditorHandler_InformationMsg);
            return null;
        }
        IFile csvFile = selectedProject.getFile(csvName);
        if (!csvFile.exists()) {
            ArrayList emptyList = new ArrayList();
            PartitionTableDataUtil.saveCsv((IFile)csvFile, emptyList);
        }
        dialog.create(csvFile);
        dialog.open();
        return null;
    }
}

