/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.menuitem;

import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.util.EclipseIniUtil;
import com.espressif.idf.ui.handlers.Messages;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class LanguageDynamicMenuItem
extends ContributionItem {
    private static final String LANGUAGE_SWITCH = "-nl";
    private EclipseIniUtil eclipseIniUtil;

    public LanguageDynamicMenuItem() {
        try {
            this.eclipseIniUtil = new EclipseIniUtil();
        }
        catch (Exception e) {
            Logger.log((Exception)e);
        }
    }

    public void fill(Menu menu, int index) {
        IConfigurationElement[] configElements;
        IConfigurationElement[] iConfigurationElementArray = configElements = Platform.getExtensionRegistry().getConfigurationElementsFor("com.espressif.idf.ui.locale.support");
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
            MenuItem menuItem = new MenuItem(menu, 8);
            final String langCode = iConfigurationElement.getAttribute("id");
            String langName = iConfigurationElement.getAttribute("name");
            menuItem.setText(langName);
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    if (LanguageDynamicMenuItem.this.eclipseIniUtil != null) {
                        try {
                            if (LanguageDynamicMenuItem.this.eclipseIniUtil.containsEclipseSwitchInEclipseIni(LanguageDynamicMenuItem.LANGUAGE_SWITCH)) {
                                if (!LanguageDynamicMenuItem.this.eclipseIniUtil.getEclipseIniSwitchValue(LanguageDynamicMenuItem.LANGUAGE_SWITCH).equals(langCode)) {
                                    LanguageDynamicMenuItem.this.eclipseIniUtil.setEclipseSwitchValue(LanguageDynamicMenuItem.LANGUAGE_SWITCH, langCode);
                                    LanguageDynamicMenuItem.this.restartEclipse();
                                }
                            } else {
                                LanguageDynamicMenuItem.this.eclipseIniUtil.setEclipseSwitchValue(LanguageDynamicMenuItem.LANGUAGE_SWITCH, langCode);
                                LanguageDynamicMenuItem.this.restartEclipse();
                            }
                        }
                        catch (Exception e) {
                            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.LanguageChange_ErrorTitle, (String)Messages.LanguageChange_ErrorMessage);
                            Logger.log((Exception)e);
                        }
                    }
                }
            });
            ++n2;
        }
    }

    private void restartEclipse() throws Exception {
        ProcessBuilder processBuilder = new ProcessBuilder(System.getProperty("eclipse.launcher"));
        processBuilder.start();
        PlatformUI.getWorkbench().close();
    }
}

