/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.handlers;

import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.ui.UIPlugin;
import com.espressif.idf.ui.dialogs.SelectDebugConfigDialog;
import com.espressif.idf.ui.handlers.Messages;
import com.espressif.idf.ui.handlers.StopLaunchBuildHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.ILaunchMode;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.launchbar.core.ILaunchBarManager;
import org.eclipse.launchbar.ui.ILaunchBarUIManager;
import org.eclipse.launchbar.ui.NewLaunchConfigWizard;
import org.eclipse.launchbar.ui.NewLaunchConfigWizardDialog;
import org.eclipse.launchbar.ui.internal.commands.LaunchActiveCommandHandler;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class RunActionHandler
extends LaunchActiveCommandHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            ILaunchBarManager launchBarManager = UIPlugin.getService(ILaunchBarManager.class);
            new StopLaunchBuildHandler().stop();
            ILaunchConfiguration config = launchBarManager.getActiveLaunchConfiguration();
            if (config == null) {
                return Status.OK_STATUS;
            }
            boolean isEspLaunchConfig = config.getType().getIdentifier().contentEquals("com.espressif.idf.launch.serial.launchConfigurationType");
            boolean isEspDebugConfig = config.getType().getIdentifier().contentEquals("com.espressif.idf.debug.gdbjtag.openocd.launchConfigurationType");
            if (!isEspLaunchConfig && !isEspDebugConfig) {
                return super.execute(event);
            }
            ILaunchMode launchMode = launchBarManager.getActiveLaunchMode();
            if (launchMode == null) {
                return Status.OK_STATUS;
            }
            int returnCode = 0;
            String projectName = config.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "");
            if (projectName.isBlank()) {
                Boolean isYes = MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)Messages.RunActionHandler_NoProjectQuestionTitle, (String)Messages.RunActionHandler_NoProjectQuestionText);
                if (Boolean.TRUE.equals(isYes)) {
                    ILaunchBarUIManager uiManager = UIPlugin.getService(ILaunchBarUIManager.class);
                    uiManager.openConfigurationEditor(launchBarManager.getActiveLaunchDescriptor());
                }
                return Status.CANCEL_STATUS;
            }
            if (launchMode.getIdentifier().equals("debug") && isEspLaunchConfig) {
                List<String> suitableDescNames = this.findSuitableDescNames(projectName, "com.espressif.idf.debug.gdbjtag.openocd.launchConfigurationType");
                if (suitableDescNames.isEmpty()) {
                    this.showMessage(Messages.DebugConfigurationNotFoundMsg);
                    return Status.CANCEL_STATUS;
                }
                returnCode = this.runActionBasedOnDescCount(launchBarManager, suitableDescNames);
            } else if (launchMode.getIdentifier().equals("run") && isEspDebugConfig) {
                List<String> suitableDescNames = this.findSuitableDescNames(projectName, "com.espressif.idf.launch.serial.launchConfigurationType");
                returnCode = this.runActionBasedOnDescCount(launchBarManager, suitableDescNames);
            }
            if (returnCode == 0) {
                launchBarManager.setActiveLaunchMode(launchMode);
                config = launchBarManager.getActiveLaunchConfiguration();
                DebugUITools.launch((ILaunchConfiguration)config, (String)launchMode.getIdentifier());
            }
            return Status.OK_STATUS;
        }
        catch (CoreException e) {
            return e.getStatus();
        }
    }

    private int runActionBasedOnDescCount(ILaunchBarManager launchBarManager, List<String> suitableDescNames) throws CoreException {
        return suitableDescNames.size() == 1 ? this.setLaunchBarWithFirstAppropriateDescriptor(launchBarManager, suitableDescNames) : new SelectDebugConfigDialog(Display.getDefault().getActiveShell(), suitableDescNames).open();
    }

    private int setLaunchBarWithFirstAppropriateDescriptor(ILaunchBarManager launchBarManager, List<String> suitableDescNames) throws CoreException {
        Stream.of(launchBarManager.getLaunchDescriptors()).filter(desc -> desc.getName().equals(suitableDescNames.get(0))).findFirst().ifPresent(desc -> {
            try {
                launchBarManager.setActiveLaunchDescriptor(desc);
            }
            catch (CoreException e) {
                Logger.log((Exception)((Object)e));
            }
        });
        return 0;
    }

    private List<String> findSuitableDescNames(String projectName, String configType) {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        List<Object> configList = new ArrayList();
        try {
            configList = Arrays.asList(launchManager.getLaunchConfigurations(launchManager.getLaunchConfigurationType(configType)));
        }
        catch (CoreException e) {
            Logger.log((Exception)((Object)e));
        }
        return configList.stream().filter(config -> {
            try {
                return config.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "").contentEquals(projectName);
            }
            catch (CoreException e) {
                Logger.log((Exception)((Object)e));
                return false;
            }
        }).map(config -> config.getName()).toList();
    }

    private void showMessage(String message) {
        Display.getDefault().asyncExec(() -> {
            Shell activeShell = Display.getDefault().getActiveShell();
            boolean isYes = MessageDialog.openQuestion((Shell)activeShell, (String)Messages.MissingDebugConfigurationTitle, (String)message);
            if (isYes) {
                NewLaunchConfigWizard wizard = new NewLaunchConfigWizard();
                NewLaunchConfigWizardDialog dialog = new NewLaunchConfigWizardDialog(activeShell, (IWizard)wizard);
                dialog.open();
                try {
                    wizard.getWorkingCopy().doSave();
                }
                catch (CoreException e) {
                    Logger.log((Exception)((Object)e));
                }
            }
        });
    }
}

