/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.core.util;

import com.espressif.idf.core.logging.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.utils.WindowsRegistry;

public class PyWinRegistryReader {
    private static String PY_REG_PATH = "SOFTWARE\\Python\\PythonCore";
    private static String PY_INSTALL_PATH = "InstallPath";
    private static String PY_EXE_PATH = "ExecutablePath";

    public Map<String, String> getPythonVersions() {
        String installLocation;
        String compKey;
        String version;
        HashMap<String, String> pythonRegistryMap = new HashMap<String, String>();
        WindowsRegistry registry = WindowsRegistry.getRegistry();
        ArrayList<String> py_version_list = new ArrayList<String>();
        int i = 0;
        while ((version = registry.getCurrentUserKeyName(PY_REG_PATH, i)) != null) {
            py_version_list.add(version);
            compKey = PY_REG_PATH + "\\" + version + "\\" + PY_INSTALL_PATH;
            Logger.log(compKey);
            installLocation = registry.getCurrentUserValue(compKey, PY_EXE_PATH);
            Logger.log(installLocation);
            if (installLocation != null) {
                pythonRegistryMap.put(version, installLocation);
            }
            ++i;
        }
        i = 0;
        while ((version = registry.getLocalMachineKeyName(PY_REG_PATH, i)) != null) {
            py_version_list.add(version);
            compKey = PY_REG_PATH + "\\" + version + "\\" + PY_INSTALL_PATH;
            Logger.log(compKey);
            installLocation = registry.getLocalMachineValue(compKey, PY_EXE_PATH);
            Logger.log(installLocation);
            if (installLocation != null) {
                pythonRegistryMap.put(version, installLocation);
            }
            ++i;
        }
        return pythonRegistryMap;
    }
}

