/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.core.util;

import com.espressif.idf.core.IDFEnvironmentVariables;
import com.espressif.idf.core.build.ReHintPair;
import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.util.IDFUtil;
import com.espressif.idf.core.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import org.yaml.snakeyaml.Yaml;

public class HintsUtil {
    private HintsUtil() {
    }

    public static List<ReHintPair> getReHintsList(File hintsYmFile) {
        ArrayList<ReHintPair> reHintsPairArray = new ArrayList<ReHintPair>();
        FileInputStream inputStream = null;
        try {
            inputStream = hintsYmFile.isFile() ? new FileInputStream(hintsYmFile) : null;
            reHintsPairArray = inputStream != null ? HintsUtil.loadHintsYamlFis(inputStream) : reHintsPairArray;
        }
        catch (FileNotFoundException e) {
            Logger.log(e);
        }
        Optional.ofNullable(inputStream).ifPresent(is -> {
            try {
                is.close();
            }
            catch (IOException e) {
                Logger.log(e);
            }
        });
        return reHintsPairArray;
    }

    public static String getHintsYmlPath() {
        return IDFUtil.getIDFPath() + File.separator + "tools" + File.separator + "idf_py_actions" + File.separator + "hints.yml";
    }

    public static String getOpenocdHintsYmlPath() {
        String openOCDScriptPath = new IDFEnvironmentVariables().getEnvValue("OPENOCD_SCRIPTS");
        if (!StringUtil.isEmpty(openOCDScriptPath)) {
            Path base = Paths.get(openOCDScriptPath, new String[0]).getParent();
            if (base != null) {
                return base.resolve("espressif").resolve("tools").resolve("esp_problems_hints.yml").toString();
            }
            return "";
        }
        return "";
    }

    private static List<ReHintPair> loadHintsYamlFis(InputStream inputStream) {
        Yaml yaml = new Yaml();
        ArrayList<ReHintPair> reHintsPairArray = new ArrayList<ReHintPair>();
        List hintEntries = (List)yaml.load(inputStream);
        for (Map entry : hintEntries) {
            String re = (String)entry.get("re");
            String hint = (String)entry.get("hint");
            String ref = (String)entry.get("ref");
            List variablesList = (List)entry.get("variables");
            if (variablesList != null && !variablesList.isEmpty()) {
                for (Map variableMap : variablesList) {
                    List reVars = (List)variableMap.get("re_variables");
                    List hintVars = (List)variableMap.get("hint_variables");
                    String formattedRe = HintsUtil.formatEntry(reVars, re);
                    String formattedHint = HintsUtil.formatEntry(hintVars, hint);
                    reHintsPairArray.add(new ReHintPair(formattedRe, formattedHint, ref));
                }
                continue;
            }
            reHintsPairArray.add(new ReHintPair(re, hint, ref));
        }
        return reHintsPairArray;
    }

    private static String formatEntry(List<String> vars, String entry) {
        int i = 0;
        entry = entry.replace("'", "''");
        while (entry.contains("{}")) {
            entry = entry.replaceFirst(Pattern.quote("{}"), "{" + i++ + "}");
        }
        return MessageFormat.format(entry, vars.toArray());
    }
}

