/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.core.util;

import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.URIUtil;

public class EclipseIniUtil {
    private String ECLIPSE_INI_FILE;
    private static final String ECLIPSE_INI_VMARGS = "-vmargs";
    private List<String> eclipseIniFileContents;
    private List<String> eclipseIniArgs;
    private Map<String, String> eclipseIniSwitchMap;
    private URI eclipseIniUri;
    private Map<String, String> eclipseVmArgMap;

    public EclipseIniUtil() throws Exception {
        this.loadIniFilePath();
        Logger.log(Platform.getLocation().toOSString());
        this.eclipseIniUri = URIUtil.fromString((String)this.ECLIPSE_INI_FILE);
        this.loadEclipseIniFileContents();
        this.loadEclipseIniSwitchMap();
        this.loadEclipseVmArgMap();
    }

    private void loadIniFilePath() throws Exception {
        URL url = new URL(String.valueOf(Platform.getInstallLocation().getURL()) + System.getProperty("eclipse.launcher.name").toLowerCase() + ".ini");
        this.ECLIPSE_INI_FILE = url.toString();
    }

    public void setEclipseSwitchValue(String eclipseSwitch, String switchValue) throws IOException {
        this.eclipseIniSwitchMap.put(eclipseSwitch, switchValue);
        this.updateEclipseIniFile();
    }

    public String getEclipseIniSwitchValue(String eclipseSwitch) {
        return this.eclipseIniSwitchMap.get(eclipseSwitch);
    }

    public boolean containsEclipseSwitchInEclipseIni(String eclipseSwitch) {
        return this.eclipseIniSwitchMap.containsKey(eclipseSwitch);
    }

    private void loadEclipseIniFileContents() throws Exception {
        File file = new File(this.eclipseIniUri);
        this.eclipseIniFileContents = FileUtils.readLines((File)file, (Charset)Charset.defaultCharset());
        int indexOfVmArgs = this.eclipseIniFileContents.indexOf(ECLIPSE_INI_VMARGS);
        if (indexOfVmArgs != -1) {
            this.eclipseIniArgs = new ArrayList<String>();
            int i = indexOfVmArgs + 1;
            while (i < this.eclipseIniFileContents.size()) {
                this.eclipseIniArgs.add(this.eclipseIniFileContents.get(i));
                ++i;
            }
        }
    }

    private void updateEclipseIniFile() throws IOException {
        File file = new File(this.eclipseIniUri);
        ArrayList<Object> contentsToWrite = new ArrayList<Object>();
        for (Map.Entry<String, String> entry : this.eclipseIniSwitchMap.entrySet()) {
            contentsToWrite.add(entry.getKey());
            if (StringUtil.isEmpty(entry.getValue())) continue;
            contentsToWrite.add(entry.getValue());
        }
        if (this.eclipseIniFileContents.indexOf(ECLIPSE_INI_VMARGS) != -1) {
            contentsToWrite.add(ECLIPSE_INI_VMARGS);
            for (Map.Entry<String, String> entry : this.eclipseVmArgMap.entrySet()) {
                if (!StringUtil.isEmpty(entry.getValue())) {
                    String contentToWrite = entry.getKey() + "=" + entry.getValue();
                    contentsToWrite.add(contentToWrite);
                    continue;
                }
                contentsToWrite.add(entry.getKey());
            }
        }
        FileUtils.writeLines((File)file, contentsToWrite);
    }

    private void loadEclipseIniSwitchMap() {
        this.eclipseIniSwitchMap = new HashMap<String, String>();
        int indexOfVmArgs = this.eclipseIniFileContents.indexOf(ECLIPSE_INI_VMARGS);
        if (indexOfVmArgs == -1) {
            indexOfVmArgs = this.eclipseIniFileContents.size();
        }
        int i = 0;
        while (i < indexOfVmArgs) {
            String key = this.eclipseIniFileContents.get(i);
            String value = this.eclipseIniFileContents.get(i + 1);
            if (value.charAt(0) == '-') {
                this.eclipseIniSwitchMap.put(key, "");
            } else {
                this.eclipseIniSwitchMap.put(key, value);
                ++i;
            }
            ++i;
        }
    }

    private void loadEclipseVmArgMap() {
        this.eclipseVmArgMap = new HashMap<String, String>();
        int indexOfVmArgs = this.eclipseIniFileContents.indexOf(ECLIPSE_INI_VMARGS);
        if (indexOfVmArgs == -1) {
            return;
        }
        int i = indexOfVmArgs + 1;
        while (i < this.eclipseIniFileContents.size()) {
            String[] arg = this.eclipseIniFileContents.get(i).split("=");
            if (arg.length == 2) {
                String key = arg[0];
                String value = arg[1];
                this.eclipseVmArgMap.put(key, value);
            } else {
                this.eclipseVmArgMap.put(this.eclipseIniFileContents.get(i), "");
            }
            ++i;
        }
    }
}

