/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.core.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.yaml.snakeyaml.Yaml;

public class ClangdConfigFileHandler {
    public void update(IProject project) throws CoreException, IOException {
        File file = this.getClangdConfigFile(project);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileInputStream inputStream = new FileInputStream(file);){
                Yaml yaml = new Yaml();
                Object obj = yaml.load((InputStream)inputStream);
                Map<String, Object> data = this.createOrGetExistingYamlStructure(obj);
                LinkedHashMap<String, Object> compileFlags = (LinkedHashMap<String, Object>)data.get("CompileFlags");
                if (compileFlags == null) {
                    compileFlags = new LinkedHashMap<String, Object>();
                    data.put("CompileFlags", compileFlags);
                }
                this.updateCompileFlagsSection(compileFlags, project.getPersistentProperty(new QualifiedName("com.espressif.idf.core", "idf.buildDirectory.property")));
                try {
                    Throwable throwable2 = null;
                    Object var11_16 = null;
                    try (FileWriter writer = new FileWriter(file, StandardCharsets.UTF_8);){
                        yaml.dump(data, (Writer)writer);
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (IOException e) {
                    throw new IOException("Error writing .clangd file: " + e.getMessage(), e);
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new IOException("Error reading .clangd file: " + e.getMessage(), e);
        }
    }

    private Map<String, Object> createOrGetExistingYamlStructure(Object obj) {
        if (obj instanceof Map) {
            return (Map)obj;
        }
        return new LinkedHashMap<String, Object>();
    }

    private void updateCompileFlagsSection(Map<String, Object> compileFlags, String buildFolderName) {
        compileFlags.put("CompilationDatabase", buildFolderName == null || buildFolderName.isEmpty() ? "build" : buildFolderName);
        compileFlags.put("Remove", Arrays.asList("-m*", "-f*"));
    }

    private File getClangdConfigFile(IProject project) throws IOException, CoreException {
        Path clangdPath = project.getLocation().toPath().resolve(".clangd");
        if (!Files.exists(clangdPath, new LinkOption[0])) {
            try {
                Files.createFile(clangdPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new IOException("Failed to create clangd config file: " + e.getMessage(), e);
            }
            project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        return clangdPath.toFile();
    }
}

