/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.core.tools.vo;

import com.espressif.idf.core.tools.JsonKey;
import com.espressif.idf.core.tools.vo.VersionsVO;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.Platform;

public class ToolsVO {
    @JsonKey(key_name="description")
    private String description;
    @JsonKey(key_name="export_paths")
    private List<String> exportPaths;
    @JsonKey(key_name="export_vars")
    private Map<String, String> exportVars;
    @JsonKey(key_name="info_url")
    private String infoUrl;
    @JsonKey(key_name="install")
    private String installType;
    @JsonKey(key_name="license")
    private String licesnse;
    @JsonKey(key_name="name")
    private String name;
    @JsonKey(key_name="supported_targets")
    private List<String> supportedTargets;
    @JsonKey(key_name="version_cmd")
    private List<String> versionCmd;
    @JsonKey(key_name="version_regex")
    private String versionRegex;
    @JsonKey(key_name="versions")
    private List<VersionsVO> versionVOs;
    @JsonKey(key_name="version")
    private String version;
    private boolean installed;
    private static final String MAC_OS = "mac";
    private static final String LINUX_OS = "linux";
    private static final String WIN_OS = "win";

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<String> getExportPaths() {
        return this.exportPaths;
    }

    public void setExportPaths(List<String> exportPaths) {
        this.exportPaths = exportPaths;
    }

    public String getInfoUrl() {
        return this.infoUrl;
    }

    public void setInfoUrl(String infoUrl) {
        this.infoUrl = infoUrl;
    }

    public Map<String, String> getExportVars() {
        return this.exportVars;
    }

    public void setExportVars(Map<String, String> exportVars) {
        this.exportVars = exportVars;
    }

    public String getInstallType() {
        return this.installType;
    }

    public void setInstallType(String installType) {
        this.installType = installType;
    }

    public String getLicesnse() {
        return this.licesnse;
    }

    public void setLicesnse(String licesnse) {
        this.licesnse = licesnse;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getSupportedTargets() {
        return this.supportedTargets;
    }

    public void setSupportedTargets(List<String> supportedTargets) {
        this.supportedTargets = supportedTargets;
    }

    public List<String> getVersionCmd() {
        return this.versionCmd;
    }

    public void setVersionCmd(List<String> versionCmd) {
        this.versionCmd = versionCmd;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public List<VersionsVO> getVersionVO() {
        return this.versionVOs;
    }

    public void setVersionVO(List<VersionsVO> versionVO) {
        this.versionVOs = versionVO;
    }

    public double getSize() {
        double totalSize = 0.0;
        String key = null;
        if (Platform.getOS().equals("win32")) {
            key = WIN_OS;
        } else if (Platform.getOS().equals(LINUX_OS)) {
            key = LINUX_OS;
        } else if (Platform.getOS().equals("macosx")) {
            key = MAC_OS;
        }
        for (VersionsVO versionVO : this.versionVOs) {
            totalSize += versionVO.getVersionOsMap().get(key).getSize();
        }
        return totalSize;
    }

    public String getReadableSize() {
        double totalSize = this.getSize();
        totalSize /= 1024.0;
        DecimalFormat df = new DecimalFormat("0");
        return String.valueOf(df.format(totalSize /= 1024.0)).concat(" MB");
    }

    public boolean isInstalled() {
        return this.installed;
    }

    public void setInstalled(boolean installed) {
        this.installed = installed;
    }

    public String getVersionRegex() {
        return this.versionRegex;
    }

    public void setVersionRegex(String versionRegex) {
        this.versionRegex = versionRegex;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ToolsVO other = (ToolsVO)obj;
        return Objects.equals(this.description, other.description) && Objects.equals(this.exportPaths, other.exportPaths) && Objects.equals(this.exportVars, other.exportVars) && Objects.equals(this.infoUrl, other.infoUrl) && Objects.equals(this.installType, other.installType) && Objects.equals(this.licesnse, other.licesnse) && Objects.equals(this.name, other.name) && Objects.equals(this.supportedTargets, other.supportedTargets) && Objects.equals(this.versionCmd, other.versionCmd) && Objects.equals(this.versionRegex, other.versionRegex) && Objects.equals(this.versionVOs, other.versionVOs) && Objects.equals(this.version, other.version) && this.installed == other.installed;
    }

    public int hashCode() {
        return Objects.hash(this.description, this.exportPaths, this.exportVars, this.infoUrl, this.installType, this.licesnse, this.name, this.supportedTargets, this.versionCmd, this.versionRegex, this.versionVOs, this.version, this.installed);
    }
}

