/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.core.tools;

import com.espressif.idf.core.logging.Logger;
import java.util.Arrays;
import org.eclipse.core.runtime.Platform;

public enum ToolsPlatformMapping {
    WIN32("win32", "win32", "x86"),
    WIN64("win64", "win32", "x86_64"),
    MACOS("macos", "macosx", "x86_64"),
    MACOSARM64("macos-arm64", "macosx", "aarch64"),
    LINUXAMD64("linux-amd64", "linux", "x86_64"),
    LINUXARM64("linux-arm64", "linux", "arm64"),
    LINUXARMEL("linux-armel", "linux", "armel"),
    LINUXARMHF("linux-armhf", "linux", "armhf"),
    LINUXI686("linux-i686", "linux", "i686");

    private final String toolsOS;
    private final String os;
    private final String arch;

    private ToolsPlatformMapping(String toolsOS, String os, String arch) {
        this.toolsOS = toolsOS;
        this.os = os;
        this.arch = arch;
    }

    public String getToolsOS() {
        return this.toolsOS;
    }

    public String getOS() {
        return this.os;
    }

    public String getArch() {
        return this.arch;
    }

    public static boolean isSupported(String toolsOS) {
        String os = Platform.getOS();
        String arch = Platform.getOSArch();
        Logger.log("toolsOS:" + toolsOS + " os:" + os + " arch:" + arch, true);
        return Arrays.stream(ToolsPlatformMapping.values()).filter(entry -> entry.getToolsOS().equals(toolsOS) && entry.getArch().equals(arch) && entry.getOS().equals(os)).count() > 0L;
    }
}

