/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.core.tools;

import com.espressif.idf.core.IDFEnvironmentVariables;
import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.toolchain.ESPToolChainManager;
import com.espressif.idf.core.toolchain.ESPToolchain;
import com.espressif.idf.core.tools.vo.IDFToolSet;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.cmake.core.ICMakeToolChainFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class ToolSetConfigurationManager {
    private List<IDFToolSet> idfToolSets;
    private Gson gson = new GsonBuilder().setPrettyPrinting().enableComplexMapKeySerialization().excludeFieldsWithoutExposeAnnotation().create();
    private boolean reload;

    /*
     * WARNING - void declaration
     */
    public void delete(IDFToolSet idfToolSet) {
        this.reload = true;
        this.getIdfToolSets(false);
        IDFEnvironmentVariables idfEnvironmentVariables = new IDFEnvironmentVariables();
        idfEnvironmentVariables.removeAllEnvVariables();
        try {
            ESPToolChainManager espToolChainManager = new ESPToolChainManager();
            espToolChainManager.removeCmakeToolChains();
            espToolChainManager.removeStdToolChains();
        }
        catch (Exception e) {
            Logger.log(e);
        }
        ArrayList<IDFToolSet> idfToolSetsToExport = new ArrayList<IDFToolSet>();
        for (IDFToolSet iDFToolSet : this.idfToolSets) {
            if (iDFToolSet.getIdfLocation().equals(idfToolSet.getIdfLocation())) continue;
            idfToolSetsToExport.add(iDFToolSet);
        }
        try {
            Throwable throwable = null;
            Iterator<IDFToolSet> iterator = null;
            try (FileWriter fileWriter = new FileWriter(this.toolSetConfigFilePath());){
                this.gson.toJson(idfToolSetsToExport, (Appendable)fileWriter);
            }
            catch (Throwable throwable2) {
                void var4_11;
                if (throwable == null) {
                    Throwable throwable3 = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw var4_11;
            }
        }
        catch (IOException iOException) {
            Logger.log(iOException);
        }
        this.getIdfToolSets(false);
        this.reload = false;
    }

    public boolean isToolSetAlreadyPresent(String idfPath) {
        List<IDFToolSet> idfToolSets = this.getIdfToolSets(false);
        if (idfToolSets == null) {
            return false;
        }
        return idfToolSets.stream().filter(toolSet -> toolSet.getIdfLocation().equals(idfPath)).findAny().isPresent();
    }

    public List<IDFToolSet> getIdfToolSets(boolean loadToolchains) {
        if (this.reload || this.idfToolSets == null || this.idfToolSets.isEmpty()) {
            this.idfToolSets = this.importToolSets();
        }
        if (loadToolchains && this.idfToolSets != null) {
            try {
                this.loadToolChainsInImportedToolSets();
            }
            catch (CoreException e) {
                Logger.log((Exception)((Object)e));
            }
        }
        return this.idfToolSets;
    }

    private List<IDFToolSet> importToolSets() {
        Type listType = new TypeToken<ArrayList<IDFToolSet>>(){}.getType();
        List<IDFToolSet> idfToolSets = new ArrayList<IDFToolSet>();
        File toolSetFile = new File(this.toolSetConfigFilePath());
        if (!toolSetFile.exists()) {
            try {
                toolSetFile.createNewFile();
            }
            catch (IOException e) {
                Logger.log(e);
            }
        }
        try {
            Throwable e = null;
            Object var5_8 = null;
            try (FileReader fileReader = new FileReader(this.toolSetConfigFilePath());){
                idfToolSets = (List)this.gson.fromJson((Reader)fileReader, listType);
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (IOException e) {
            Logger.log(e);
        }
        return idfToolSets;
    }

    private void loadToolChainsInImportedToolSets() throws CoreException {
        ESPToolChainManager espToolChainManager = new ESPToolChainManager();
        for (IDFToolSet idfToolSet : this.idfToolSets) {
            String pathToLookForToolChains = idfToolSet.getEnvVars().get("PATH");
            String idfPath = idfToolSet.getEnvVars().get("IDF_PATH");
            Logger.log("Using: " + idfPath + " to find toolchains");
            Logger.log("Env used: " + String.valueOf(idfToolSet.getEnvVars()));
            List<ESPToolchain> espToolChains = espToolChainManager.getStdToolChains(Arrays.asList(pathToLookForToolChains.split(File.pathSeparator)), idfPath);
            idfToolSet.setEspStdToolChains(espToolChains);
            List<ICMakeToolChainFile> cMakeToolChainFiles = espToolChainManager.getCmakeToolChains(idfPath);
            idfToolSet.setEspCmakeToolChainFiles(cMakeToolChainFiles);
        }
    }

    public void export(IDFToolSet idfToolSet) {
        File toolSetConfigFile = new File(this.toolSetConfigFilePath());
        List<IDFToolSet> idfToolSets = null;
        Type listType = new TypeToken<ArrayList<IDFToolSet>>(){}.getType();
        if (toolSetConfigFile.exists()) {
            try {
                Throwable throwable = null;
                Iterator iterator = null;
                try (FileReader fileReader = new FileReader(toolSetConfigFile);){
                    idfToolSets = (List)this.gson.fromJson((Reader)fileReader, listType);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                Logger.log(e);
                return;
            }
        }
        if (idfToolSets == null) {
            idfToolSets = new ArrayList<IDFToolSet>();
        }
        if (idfToolSet.isActive()) {
            for (IDFToolSet toolSet : idfToolSets) {
                toolSet.setActive(false);
            }
        }
        boolean found = false;
        int i2 = 0;
        while (i2 < idfToolSets.size()) {
            IDFToolSet existingToolSet = (IDFToolSet)idfToolSets.get(i2);
            if (existingToolSet.getId() == idfToolSet.getId()) {
                idfToolSets.set(i2, idfToolSet);
                found = true;
                break;
            }
            ++i2;
        }
        if (!found) {
            idfToolSets.add(idfToolSet);
        }
        try {
            Throwable i2 = null;
            Object var7_15 = null;
            try (FileWriter fileWriter = new FileWriter(toolSetConfigFile);){
                this.gson.toJson(idfToolSets, (Appendable)fileWriter);
            }
            catch (Throwable throwable) {
                if (i2 == null) {
                    i2 = throwable;
                } else if (i2 != throwable) {
                    i2.addSuppressed(throwable);
                }
                throw i2;
            }
        }
        catch (IOException e) {
            Logger.log(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void updateToolSetConfiguration(IDFToolSet idfToolSet) {
        this.reload = true;
        this.getIdfToolSets(false);
        ArrayList<IDFToolSet> idfToolSetsToExport = new ArrayList<IDFToolSet>();
        for (IDFToolSet iDFToolSet : this.idfToolSets) {
            if (idfToolSet.getId() == iDFToolSet.getId()) {
                idfToolSetsToExport.add(idfToolSet);
                continue;
            }
            idfToolSetsToExport.add(iDFToolSet);
        }
        try {
            Throwable throwable = null;
            Iterator<IDFToolSet> iterator = null;
            try (FileWriter fileWriter = new FileWriter(this.toolSetConfigFilePath());){
                this.gson.toJson(this.idfToolSets, (Appendable)fileWriter);
            }
            catch (Throwable throwable2) {
                void var3_9;
                if (throwable == null) {
                    Throwable throwable3 = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw var3_9;
            }
        }
        catch (IOException iOException) {
            Logger.log(iOException);
        }
    }

    private String toolSetConfigFilePath() {
        IPath path = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(path.toOSString());
        stringBuilder.append(File.separatorChar);
        stringBuilder.append("tool_set_config.json");
        return stringBuilder.toString();
    }

    public void setReload(boolean reload) {
        this.reload = reload;
    }
}

