/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.vectorgraphics2d.intermediate.filters;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.eclipse.swtchart.vectorgraphics2d.intermediate.CommandSequence;
import org.eclipse.swtchart.vectorgraphics2d.intermediate.commands.AffineTransformCommand;
import org.eclipse.swtchart.vectorgraphics2d.intermediate.commands.Command;
import org.eclipse.swtchart.vectorgraphics2d.intermediate.commands.SetHintCommand;
import org.eclipse.swtchart.vectorgraphics2d.intermediate.commands.StateCommand;
import org.eclipse.swtchart.vectorgraphics2d.intermediate.filters.StreamingFilter;

public class OptimizeFilter
extends StreamingFilter {
    private final Queue<Command<?>> buffer = new LinkedList();

    public OptimizeFilter(CommandSequence stream) {
        super(stream);
    }

    @Override
    public boolean hasNext() {
        return super.hasNext();
    }

    @Override
    public Command<?> next() {
        if (this.buffer.isEmpty()) {
            return super.next();
        }
        return this.buffer.poll();
    }

    @Override
    protected List<Command<?>> filter(Command<?> command) {
        if (!OptimizeFilter.isStateChange(command)) {
            return Collections.singletonList(command);
        }
        Iterator i = this.buffer.iterator();
        Class<?> cls = command.getClass();
        while (i.hasNext()) {
            if (!cls.equals(((Command)i.next()).getClass())) continue;
            i.remove();
        }
        this.buffer.add(command);
        return null;
    }

    private static boolean isStateChange(Command<?> command) {
        return command instanceof StateCommand && !(command instanceof AffineTransformCommand) && !(command instanceof SetHintCommand);
    }
}

