/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.xviewer;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.nebula.widgets.xviewer.IXViewerLabelProvider;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.nebula.widgets.xviewer.core.model.ColumnDateFilter;
import org.eclipse.nebula.widgets.xviewer.core.model.DateRangeType;
import org.eclipse.nebula.widgets.xviewer.core.model.SortDataType;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.nebula.widgets.xviewer.core.util.Strings;

public class XViewerTextFilter
extends ViewerFilter {
    protected final XViewer xViewer;
    protected Pattern textPattern;
    protected Matcher matcher;
    protected final Map<String, Pattern> colIdToPattern = new HashMap<String, Pattern>();
    protected final Map<String, ColumnDateFilter> colIdToDateFilter = new HashMap<String, ColumnDateFilter>();
    protected static final Pattern EMPTY_STR_PATTERN = Pattern.compile("");
    protected static final Pattern NOT_EMPTY_STR_PATTERN = Pattern.compile("^.+$");
    private final Set<Object> parentMatches = new HashSet<Object>();

    public XViewerTextFilter(XViewer xViewer) {
        this.xViewer = xViewer;
    }

    public void update() {
        this.parentMatches.clear();
        if (!Strings.isValid((String)this.xViewer.getCustomizeMgr().getFilterText())) {
            this.textPattern = null;
        } else {
            int flags = 2;
            if (!this.xViewer.getCustomizeMgr().isFilterTextRegularExpression()) {
                flags = 0x10 | flags;
            }
            this.textPattern = Pattern.compile(this.xViewer.getCustomizeMgr().getFilterText(), flags);
        }
        this.colIdToPattern.clear();
        this.colIdToDateFilter.clear();
        for (String colId : this.xViewer.getCustomizeMgr().getColumnFilterData().getColIds()) {
            ColumnDateFilter dateFilter;
            String colFilterText = this.xViewer.getCustomizeMgr().getColumnFilterText(colId);
            if (colFilterText != null) {
                boolean isNot;
                boolean isWrapped = colFilterText.matches("^\\(.*\\)$");
                if (isWrapped) {
                    colFilterText = colFilterText.substring(1, colFilterText.length() - 1);
                }
                if (isNot = colFilterText.startsWith("!")) {
                    colFilterText = colFilterText.replaceFirst("^!", "");
                }
                colFilterText = Pattern.quote(colFilterText);
                if (isNot) {
                    if (colFilterText.equals("")) {
                        this.colIdToPattern.put(colId, NOT_EMPTY_STR_PATTERN);
                    } else {
                        this.colIdToPattern.put(colId, Pattern.compile("^(.(?<!" + colFilterText + "))*$", 2));
                    }
                } else if (colFilterText.equals("")) {
                    this.colIdToPattern.put(colId, EMPTY_STR_PATTERN);
                } else {
                    this.colIdToPattern.put(colId, Pattern.compile(colFilterText, 2));
                }
            }
            if ((dateFilter = this.xViewer.getCustomizeMgr().getColumnDateFilter(colId)) == null) continue;
            this.colIdToDateFilter.put(colId, dateFilter);
        }
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.textPattern == null && this.colIdToPattern.isEmpty() && this.colIdToDateFilter.isEmpty()) {
            return true;
        }
        if (this.parentMatches.contains(element)) {
            if (parentElement != null) {
                this.parentMatches.add(parentElement);
            }
            return true;
        }
        boolean match = true;
        Set colIds = this.xViewer.getCustomizeMgr().getColumnFilterData().getColIds();
        for (String filteredColId : colIds) {
            String cellStr;
            XViewerColumn xCol = this.xViewer.getCustomizeMgr().getCurrentTableColumn(filteredColId);
            if (!xCol.isShow()) continue;
            if (this.colIdToPattern.keySet().contains(xCol.getId()) && (cellStr = this.xViewer.getColumnText(element, this.xViewer.getCustomizeMgr().getColumnNumFromXViewerColumn(xCol))) != null) {
                this.matcher = this.colIdToPattern.get(xCol.getId()).matcher(cellStr);
                if (!this.matcher.find()) {
                    return false;
                }
            }
            if (!this.colIdToDateFilter.containsKey(xCol.getId())) continue;
            Object obj1 = null;
            IBaseLabelProvider labelProvider = this.xViewer.getLabelProvider();
            if (labelProvider instanceof IXViewerLabelProvider) {
                try {
                    obj1 = ((IXViewerLabelProvider)labelProvider).getBackingData(element, xCol, this.xViewer.getCustomizeMgr().getColumnNumFromXViewerColumn(xCol));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (obj1 != null && xCol.getSortDataType() == SortDataType.Date && obj1 instanceof Date) {
                Date cellDate = (Date)obj1;
                ColumnDateFilter columnDateFilter = this.colIdToDateFilter.get(xCol.getId());
                Date filterDate1 = columnDateFilter.getDate1();
                DateRangeType rangeType = columnDateFilter.getType();
                if (rangeType == DateRangeType.Equals_Date) {
                    if (cellDate.getYear() == filterDate1.getYear() && cellDate.getMonth() == filterDate1.getMonth() && cellDate.getDay() == filterDate1.getDay()) continue;
                    return false;
                }
                if (rangeType == DateRangeType.After_Date && cellDate.before(filterDate1)) {
                    return false;
                }
                if (rangeType == DateRangeType.Before_Date && cellDate.after(filterDate1)) {
                    return false;
                }
                if (rangeType != DateRangeType.Between_Dates) continue;
                if (cellDate.before(filterDate1)) {
                    return false;
                }
                Date filterDate2 = columnDateFilter.getDate2();
                if (!cellDate.after(filterDate2)) continue;
                return false;
            }
            return false;
        }
        if (!match) {
            return false;
        }
        if (this.textPattern == null) {
            if (match && parentElement != null) {
                this.parentMatches.add(parentElement);
            }
            return match;
        }
        if (this.textPattern != null) {
            for (XViewerColumn xCol : this.xViewer.getCustomizeMgr().getCurrentTableColumns()) {
                String cellStr;
                if (!xCol.isShow() || (cellStr = this.xViewer.getColumnText(element, this.xViewer.getCustomizeMgr().getColumnNumFromXViewerColumn(xCol))) == null) continue;
                this.matcher = this.textPattern.matcher(cellStr);
                if (!this.matcher.find()) continue;
                if (parentElement != null) {
                    this.parentMatches.add(parentElement);
                }
                return true;
            }
        }
        return false;
    }
}

