/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.core.util;

import com.espressif.idf.core.logging.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.text.MessageFormat;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class GenericJsonReader {
    private String filePath;

    public GenericJsonReader(String filePath) {
        this.filePath = filePath;
    }

    public String getValue(String key) {
        try {
            JSONObject jsonObj = this.read();
            if (jsonObj != null) {
                return (String)jsonObj.get((Object)key);
            }
        }
        catch (Exception e) {
            Logger.log(e);
        }
        return null;
    }

    public JSONObject read() throws Exception {
        if (!new File(this.filePath).exists()) {
            Logger.log(MessageFormat.format("{0} could not find", this.filePath.toString()));
            return null;
        }
        JSONParser parser = new JSONParser();
        BufferedReader breader = null;
        try {
            breader = new BufferedReader(new FileReader(new File(this.filePath)));
            JSONObject jSONObject = (JSONObject)parser.parse((Reader)breader);
            return jSONObject;
        }
        catch (IOException | ParseException e) {
            throw new Exception(e);
        }
        finally {
            try {
                if (breader != null) {
                    breader.close();
                }
            }
            catch (IOException ex) {
                breader = null;
            }
        }
    }
}

