/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.core.toolchain;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class IDFTargets {
    private static final Set<String> XTENSA_CHIPS = Set.of("esp32", "esp32s2", "esp32s3");
    private static final String XTENSA = "xtensa";
    private static final String RISCV32 = "riscv32";
    private static final String XTENSA_TOOLCHAIN_ID = "xtensa-%s-elf";
    private static final String RISCV32_TOOLCHAIN_ID = "riscv32-esp-elf";
    private static final String XTENSA_UNIFIED_DIR = "xtensa-esp-elf";
    private static final String TOOLCHAIN_NAME = "toolchain-%s.cmake";
    private List<IDFTarget> supportedTargets = new ArrayList<IDFTarget>();
    private List<IDFTarget> previewTargets = new ArrayList<IDFTarget>();

    public void addSupportedTarget(String target) {
        this.supportedTargets.add(new IDFTarget(target, false));
    }

    public void addPreviewTarget(String target) {
        this.previewTargets.add(new IDFTarget(target, true));
    }

    public List<IDFTarget> getAllTargets() {
        ArrayList<IDFTarget> allTargets = new ArrayList<IDFTarget>();
        allTargets.addAll(this.supportedTargets);
        allTargets.addAll(this.previewTargets);
        return allTargets;
    }

    public List<IDFTarget> getSupportedTargets() {
        return this.supportedTargets;
    }

    public List<IDFTarget> getPreviewTargets() {
        return this.previewTargets;
    }

    public boolean hasTarget(String targetName) {
        return this.getAllTargets().stream().anyMatch(target -> target.getName().equals(targetName));
    }

    public IDFTarget getTarget(String targetName) {
        return this.getAllTargets().stream().filter(target -> target.getName().equals(targetName)).findFirst().orElse(null);
    }

    public List<String> getAllTargetNames() {
        return this.getAllTargets().stream().map(IDFTarget::getName).collect(Collectors.toList());
    }

    public List<String> getSupportedTargetNames() {
        return this.getSupportedTargets().stream().map(IDFTarget::getName).collect(Collectors.toList());
    }

    public List<String> getPreviewTargetNames() {
        return this.getPreviewTargets().stream().map(IDFTarget::getName).collect(Collectors.toList());
    }

    public static class IDFTarget {
        private final String name;
        private final boolean isPreview;

        public IDFTarget(String name, boolean isPreview) {
            this.name = name;
            this.isPreview = isPreview;
        }

        public String getName() {
            return this.name;
        }

        public boolean isPreview() {
            return this.isPreview;
        }

        public String getArchitecture() {
            return XTENSA_CHIPS.contains(this.name) ? IDFTargets.XTENSA : IDFTargets.RISCV32;
        }

        public String getToolchainId() {
            return XTENSA_CHIPS.contains(this.name) ? String.format(IDFTargets.XTENSA_TOOLCHAIN_ID, this.name) : IDFTargets.RISCV32_TOOLCHAIN_ID;
        }

        public String getCompilerPattern() {
            String executableName = this.getExecutableName();
            String targetSpecificDir = this.getTargetSpecificDirectoryName();
            String unifiedDir = this.getUnifiedDirectoryName();
            return "(?:" + targetSpecificDir + "|" + unifiedDir + ")[\\\\/]+bin[\\\\/]+" + executableName + "-gcc(?:\\.exe)?$";
        }

        public String getDebuggerPattern() {
            String executableName = this.getExecutableName();
            return executableName + "-gdb(?:\\.exe)?$";
        }

        private String getExecutableName() {
            return XTENSA_CHIPS.contains(this.name) ? String.format(IDFTargets.XTENSA_TOOLCHAIN_ID, this.name) : IDFTargets.RISCV32_TOOLCHAIN_ID;
        }

        private String getTargetSpecificDirectoryName() {
            return XTENSA_CHIPS.contains(this.name) ? String.format(IDFTargets.XTENSA_TOOLCHAIN_ID, this.name) : IDFTargets.RISCV32_TOOLCHAIN_ID;
        }

        private String getUnifiedDirectoryName() {
            return XTENSA_CHIPS.contains(this.name) ? IDFTargets.XTENSA_UNIFIED_DIR : IDFTargets.RISCV32_TOOLCHAIN_ID;
        }

        public String getToolchainFileName() {
            return String.format(IDFTargets.TOOLCHAIN_NAME, this.name);
        }
    }
}

