/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.core;

import com.espressif.idf.core.InputStreamThread;
import com.espressif.idf.core.util.IDFUtil;
import com.espressif.idf.core.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ProcessBuilderFactory {
    private static final String UTF_8 = "UTF-8";

    public Process run(List<String> commands, IPath workingDirectory, Map<String, String> environment) throws IOException {
        ProcessBuilder processBuilder = new ProcessBuilder(commands);
        if (workingDirectory != null) {
            processBuilder.directory(workingDirectory.toFile());
        }
        if (environment != null && !environment.isEmpty()) {
            processBuilder.environment().putAll(environment);
            if (processBuilder.environment().containsKey("PATH") && processBuilder.environment().containsKey("Path")) {
                processBuilder.environment().remove("Path");
            }
        }
        processBuilder.redirectErrorStream(true);
        return processBuilder.start();
    }

    public IStatus runInBackground(List<String> commands, IPath workingDirectory, Map<String, String> environment) throws IOException {
        Process process = this.run(commands, workingDirectory, environment);
        return this.processData(process.getInputStream(), process.getErrorStream(), process.getOutputStream(), process);
    }

    private IStatus processData(InputStream inputStream, InputStream errorStream, OutputStream outputStream, Process process) {
        String lineSeparator = IDFUtil.getLineSeparatorValue();
        InputStreamThread readerGobbler = null;
        Thread errorGobbler = null;
        try {
            int exitValue = 0;
            readerGobbler = new InputStreamThread(inputStream, lineSeparator, UTF_8);
            errorGobbler = new InputStreamThread(errorStream, lineSeparator, null);
            readerGobbler.start();
            errorGobbler.start();
            exitValue = process.waitFor();
            readerGobbler.interrupt();
            errorGobbler.interrupt();
            readerGobbler.join();
            errorGobbler.join();
            String stdout = readerGobbler.getResult();
            String stderr = ((InputStreamThread)errorGobbler).getResult();
            return new Status(exitValue == 0 ? 0 : 4, "com.espressif.idf.core", exitValue, this.createMessage(exitValue, stdout, stderr), null);
        }
        catch (InterruptedException e) {
            String stdout = "";
            String stderr = "";
            try {
                if (readerGobbler != null) {
                    readerGobbler.interrupt();
                }
                if (errorGobbler != null) {
                    errorGobbler.interrupt();
                }
                if (readerGobbler != null) {
                    readerGobbler.join();
                    stdout = readerGobbler.getResult();
                }
                if (errorGobbler != null) {
                    errorGobbler.join();
                    stderr = ((InputStreamThread)errorGobbler).getResult();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return new Status(4, "com.espressif.idf.core", this.createMessage(1, stdout, stderr), (Throwable)e);
        }
    }

    private String createMessage(int exitCode, String stdOut, String stderr) {
        if (exitCode != 0 && StringUtil.isEmpty((String)stdOut)) {
            return stderr;
        }
        if (stdOut != null && ((String)stdOut).endsWith("\n")) {
            return ((String)stdOut).substring(0, ((String)stdOut).length() - 1);
        }
        if (!StringUtil.isEmpty(stderr)) {
            String[] lines = stderr.split("[\n\r]+");
            int i = lines.length - 1;
            while (i >= 0) {
                String line = lines[i];
                if (line.startsWith("[ERROR] :")) {
                    stdOut = line.substring(9).trim() + "\n" + (String)stdOut;
                    break;
                }
                --i;
            }
        }
        return stdOut;
    }
}

