/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.core;

import com.espressif.idf.core.configparser.EspConfigParser;
import com.espressif.idf.core.configparser.vo.Board;
import java.util.List;
import java.util.OptionalInt;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class DefaultBoardProvider {
    private static final int DEFAULT_BOARD_EMPTY_INDEX = 0;
    private static final String ESP32C3_DEFAULT_BOARD = "ESP32-C3 chip (via builtin USB-JTAG)";
    private static final String ESP32S3_DEFAULT_BOARD = "ESP32-S3 chip (via builtin USB-JTAG)";
    private EspConfigParser espConfigParser = new EspConfigParser();

    public int getIndexOfDefaultBoard(String targetName, String[] boardsForTarget) {
        String defaultBoard = EspTarget.enumOf((String)targetName).board;
        OptionalInt index = IntStream.range(0, boardsForTarget.length).filter(i -> defaultBoard.equals(boardsForTarget[i])).findFirst();
        return index.orElse(0);
    }

    public String getDefaultBoard(String targetName) {
        List<Board> boardsList = this.espConfigParser.getBoardsForTarget(targetName);
        String[] boards = (String[])boardsList.stream().map(Board::name).toArray(String[]::new);
        if (boards.length == 0) {
            return EspTarget.enumOf((String)targetName).board;
        }
        return boards[this.getIndexOfDefaultBoard(targetName, boards)];
    }

    private static enum EspTarget {
        ESP32C3("ESP32-C3 chip (via builtin USB-JTAG)"),
        ESP32S3("ESP32-S3 chip (via builtin USB-JTAG)"),
        DEFAULT_TARGET("");

        private final String board;

        private EspTarget(String defaultBoard) {
            this.board = defaultBoard;
        }

        public static EspTarget enumOf(String value) {
            return Stream.of(EspTarget.values()).filter(target -> target.name().equalsIgnoreCase(value)).findAny().orElse(DEFAULT_TARGET);
        }
    }
}

