/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service.command;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IBreakpoints;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.ISignals;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.debug.service.command.ICommandListener;
import org.eclipse.cdt.dsf.debug.service.command.ICommandResult;
import org.eclipse.cdt.dsf.debug.service.command.ICommandToken;
import org.eclipse.cdt.dsf.debug.service.command.IEventListener;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.mi.service.IMIContainerDMContext;
import org.eclipse.cdt.dsf.mi.service.IMIProcesses;
import org.eclipse.cdt.dsf.mi.service.command.IEventProcessor;
import org.eclipse.cdt.dsf.mi.service.command.commands.CLICommand;
import org.eclipse.cdt.dsf.mi.service.command.commands.MIInterpreterExecConsole;
import org.eclipse.cdt.dsf.mi.service.command.events.MIBreakpointChangedEvent;
import org.eclipse.cdt.dsf.mi.service.command.events.MIDetachedEvent;
import org.eclipse.cdt.dsf.mi.service.command.events.MIRunningEvent;
import org.eclipse.cdt.dsf.mi.service.command.events.MISignalChangedEvent;
import org.eclipse.cdt.dsf.mi.service.command.events.MIThreadCreatedEvent;
import org.eclipse.cdt.dsf.mi.service.command.output.MIConsoleStreamOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOOBRecord;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOutput;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;

@ConfinedToDsfExecutor(value="fConnection#getExecutor")
public class CLIEventProcessor
implements IEventProcessor {
    private final ICommandControlService fCommandControl;
    private final ICommandControlService.ICommandControlDMContext fControlDmc;
    private int fLastThreadId;
    private final DsfServicesTracker fServicesTracker;

    public CLIEventProcessor(ICommandControlService connection, ICommandControlService.ICommandControlDMContext controlDmc) {
        this.fCommandControl = connection;
        this.fControlDmc = controlDmc;
        this.fServicesTracker = new DsfServicesTracker(GdbPlugin.getBundleContext(), this.fCommandControl.getSession().getId());
        connection.addCommandListener((ICommandListener)this);
        connection.addEventListener((IEventListener)this);
        this.fCommandControl.getSession().addServiceEventListener((Object)this, null);
    }

    @Override
    public void dispose() {
        this.fCommandControl.getSession().removeServiceEventListener((Object)this);
        this.fCommandControl.removeCommandListener((ICommandListener)this);
        this.fCommandControl.removeEventListener((IEventListener)this);
        this.fServicesTracker.dispose();
    }

    public void commandSent(ICommandToken token) {
        if (token.getCommand() instanceof CLICommand) {
            this.processStateChanges((CLICommand)token.getCommand());
        } else if (token.getCommand() instanceof MIInterpreterExecConsole) {
            this.processStateChanges((MIInterpreterExecConsole)token.getCommand());
        }
    }

    public void commandDone(ICommandToken token, ICommandResult result) {
        if (token.getCommand() instanceof CLICommand) {
            this.processSettingChanges((CLICommand)token.getCommand());
        } else if (token.getCommand() instanceof MIInterpreterExecConsole) {
            this.processSettingChanges((MIInterpreterExecConsole)token.getCommand());
        }
    }

    public void commandQueued(ICommandToken token) {
    }

    public void commandRemoved(ICommandToken token) {
    }

    public void eventReceived(Object output) {
        MIOOBRecord[] mIOOBRecordArray = ((MIOutput)output).getMIOOBRecords();
        int n = mIOOBRecordArray.length;
        int n2 = 0;
        while (n2 < n) {
            MIOOBRecord oobr = mIOOBRecordArray[n2];
            if (oobr instanceof MIConsoleStreamOutput) {
                MIConsoleStreamOutput exec = (MIConsoleStreamOutput)oobr;
                Pattern pattern = Pattern.compile("^\\[New [Tt]hread\\s+");
                Matcher matcher = pattern.matcher(exec.getCString());
                if (matcher.find()) {
                    String threadId = Integer.toString(++this.fLastThreadId);
                    IMIProcesses procService = (IMIProcesses)this.fServicesTracker.getService(IMIProcesses.class);
                    if (procService != null) {
                        IMIContainerDMContext processContainerDmc = procService.createContainerContextFromGroupId(this.fControlDmc, "");
                        MIThreadCreatedEvent e = new MIThreadCreatedEvent((IRunControl.IContainerDMContext)processContainerDmc, threadId);
                        this.fCommandControl.getSession().dispatchEvent((Object)e, this.fCommandControl.getProperties());
                    }
                }
            }
            ++n2;
        }
    }

    private void processStateChanges(CLICommand<? extends ICommandResult> cmd) {
        String operation = cmd.getOperation().trim();
        this.processStateChanges(0, operation);
    }

    private void processStateChanges(MIInterpreterExecConsole<? extends ICommandResult> exec) {
        String[] operations = exec.getParameters();
        if (operations != null && operations.length > 0) {
            this.processStateChanges(0, operations[0]);
        }
    }

    private void processStateChanges(int token, String operation) {
        IMIProcesses procService;
        int type = CLIEventProcessor.getSteppingOperationKind(operation);
        if (type != -1 && (procService = (IMIProcesses)this.fServicesTracker.getService(IMIProcesses.class)) != null) {
            IMIContainerDMContext processContainerDmc = procService.createContainerContextFromGroupId(this.fControlDmc, "");
            MIRunningEvent event = new MIRunningEvent((IRunControl.IExecutionDMContext)processContainerDmc, token, type);
            this.fCommandControl.getSession().dispatchEvent((Object)event, this.fCommandControl.getProperties());
        }
    }

    private void processSettingChanges(CLICommand<?> cmd) {
        String operation = cmd.getOperation().trim();
        this.processSettingChanges(cmd.getContext(), 0, operation);
    }

    private void processSettingChanges(MIInterpreterExecConsole<?> exec) {
        String[] operations = exec.getParameters();
        if (operations != null && operations.length > 0) {
            this.processSettingChanges(exec.getContext(), 0, operations[0]);
        }
    }

    private void processSettingChanges(IDMContext dmc, int token, String operation) {
        ICommandControlService.ICommandControlDMContext controlDmc;
        int indx = operation.indexOf(32);
        if (this.isSettingBreakpoint(operation = indx != -1 ? operation.substring(0, indx).trim() : operation.trim()) || this.isSettingWatchpoint(operation) || this.isChangeBreakpoint(operation) || this.isDeletingBreakpoint(operation)) {
            IBreakpoints.IBreakpointsTargetDMContext bpTargetDmc = (IBreakpoints.IBreakpointsTargetDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IBreakpoints.IBreakpointsTargetDMContext.class);
            if (bpTargetDmc != null) {
                MIBreakpointChangedEvent event = new MIBreakpointChangedEvent(bpTargetDmc, 0);
                this.fCommandControl.getSession().dispatchEvent((Object)event, this.fCommandControl.getProperties());
            }
        } else if (this.isSettingSignal(operation)) {
            ISignals.ISignalsDMContext signalDmc = (ISignals.ISignalsDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, ISignals.ISignalsDMContext.class);
            if (signalDmc != null) {
                MISignalChangedEvent event = new MISignalChangedEvent(signalDmc, "");
                this.fCommandControl.getSession().dispatchEvent((Object)event, this.fCommandControl.getProperties());
            }
        } else if (this.isDetach(operation) && (controlDmc = (ICommandControlService.ICommandControlDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, ICommandControlService.ICommandControlDMContext.class)) != null) {
            MIDetachedEvent event = new MIDetachedEvent(controlDmc, token);
            this.fCommandControl.getSession().dispatchEvent((Object)event, this.fCommandControl.getProperties());
        }
    }

    private static int getSteppingOperationKind(String operation) {
        int indx = operation.indexOf(32);
        operation = indx != -1 ? operation.substring(0, indx).trim() : operation.trim();
        int type = -1;
        if (operation.equals("n") || operation.equals("next")) {
            type = 1;
        } else if (operation.equals("ni") || operation.equals("nexti")) {
            type = 2;
        } else if (operation.equals("s") || operation.equals("step")) {
            type = 3;
        } else if (operation.equals("si") || operation.equals("stepi")) {
            type = 4;
        } else if (operation.equals("u") || operation.startsWith("unt") && "until".indexOf(operation) != -1) {
            type = 6;
        } else if (operation.startsWith("fin") && "finish".indexOf(operation) != -1) {
            type = 5;
        } else if (operation.startsWith("ret") && "return".indexOf(operation) != -1) {
            type = 7;
        } else if (operation.equals("c") || operation.equals("fg") || operation.startsWith("cont") && "continue".indexOf(operation) != -1) {
            type = 0;
        } else if (operation.startsWith("sig") && "signal".indexOf(operation) != -1) {
            type = 0;
        } else if (operation.startsWith("j") && "jump".indexOf(operation) != -1) {
            type = 0;
        } else if (operation.equals("r") || operation.equals("run")) {
            type = 0;
        }
        return type;
    }

    public static boolean isSteppingOperation(String operation) {
        int type = CLIEventProcessor.getSteppingOperationKind(operation);
        return type != -1;
    }

    public static boolean isAttachingOperation(String operation) {
        int indx = operation.indexOf(32);
        return (operation = indx != -1 ? operation.substring(0, indx).trim() : operation.trim()).startsWith("at") && "attach".indexOf(operation) != -1;
    }

    private boolean isSettingBreakpoint(String operation) {
        boolean isbreak = false;
        if (operation.startsWith("b") && "break".indexOf(operation) != -1 || operation.startsWith("tb") && "tbreak".indexOf(operation) != -1 || operation.startsWith("hb") && "hbreak".indexOf(operation) != -1 || operation.startsWith("thb") && "thbreak".indexOf(operation) != -1 || operation.startsWith("rb") && "rbreak".indexOf(operation) != -1) {
            isbreak = true;
        }
        return isbreak;
    }

    private boolean isSettingWatchpoint(String operation) {
        boolean isWatch = false;
        if (operation.startsWith("wa") && "watch".indexOf(operation) != -1 || operation.startsWith("rw") && "rwatch".indexOf(operation) != -1 || operation.startsWith("aw") && "awatch".indexOf(operation) != -1) {
            isWatch = true;
        }
        return isWatch;
    }

    private boolean isDeletingBreakpoint(String operation) {
        boolean isDelete = false;
        if (operation.startsWith("cl") && "clear".indexOf(operation) != -1 || operation.equals("d") || operation.startsWith("del") && "delete".indexOf(operation) != -1) {
            isDelete = true;
        }
        return isDelete;
    }

    private boolean isChangeBreakpoint(String operation) {
        boolean isChange = false;
        if (operation.equals("dis") || operation.equals("disa") || operation.startsWith("disa") && "disable".indexOf(operation) != -1 || operation.equals("en") || operation.startsWith("en") && "enable".indexOf(operation) != -1 || operation.startsWith("ig") && "ignore".indexOf(operation) != -1 || operation.startsWith("cond") && "condition".indexOf(operation) != -1) {
            isChange = true;
        }
        return isChange;
    }

    private boolean isSettingSignal(String operation) {
        boolean isChange = false;
        if (operation.startsWith("ha") && "handle".indexOf(operation) != -1) {
            isChange = true;
        }
        return isChange;
    }

    private boolean isDetach(String operation) {
        return operation.startsWith("det") && "detach".indexOf(operation) != -1;
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IStartedDMEvent e) {
        if (e.getDMContext() instanceof IRunControl.IContainerDMContext) {
            this.fLastThreadId = 0;
        }
    }
}

