/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.debug.gdbjtag.openocd.dsf.process.monitors;

import com.espressif.idf.debug.gdbjtag.openocd.dsf.process.StreamListener;
import com.espressif.idf.debug.gdbjtag.openocd.dsf.process.monitors.CustomOutputStreamMonitor;
import java.io.IOException;
import java.nio.charset.Charset;
import org.eclipse.debug.core.model.IBinaryStreamMonitor;
import org.eclipse.debug.core.model.IBinaryStreamsProxy;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.internal.core.InputStreamMonitor;

public class StreamsProxy
implements IBinaryStreamsProxy {
    private CustomOutputStreamMonitor fOutputMonitor;
    private CustomOutputStreamMonitor fErrorMonitor;
    private InputStreamMonitor fInputMonitor;
    private boolean fClosed;
    private StreamListener streamListener;

    public StreamsProxy(IProcess iProcess, Process process, Charset charset, String processLabel, String outputFile, boolean append) {
        if (process == null) {
            return;
        }
        this.fOutputMonitor = new CustomOutputStreamMonitor(process.getInputStream(), charset);
        this.fErrorMonitor = new CustomOutputStreamMonitor(process.getErrorStream(), charset);
        this.streamListener = new StreamListener(iProcess, (IStreamMonitor)this.fErrorMonitor, (IStreamMonitor)this.fOutputMonitor, charset, outputFile, append);
        this.fOutputMonitor.addListener(this.streamListener);
        this.fErrorMonitor.addListener(this.streamListener);
        this.fInputMonitor = new InputStreamMonitor(process.getOutputStream(), charset);
        this.fOutputMonitor.startMonitoring(processLabel);
        this.fErrorMonitor.startMonitoring(processLabel);
        this.fInputMonitor.startMonitoring();
    }

    public void close() {
        if (!this.isClosed(true)) {
            this.fOutputMonitor.close();
            this.fErrorMonitor.close();
            this.fInputMonitor.close();
        }
    }

    private synchronized boolean isClosed(boolean setClosed) {
        boolean closed = this.fClosed;
        if (setClosed) {
            this.fClosed = true;
        }
        return closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill() {
        StreamsProxy streamsProxy = this;
        synchronized (streamsProxy) {
            this.fClosed = true;
        }
        this.fOutputMonitor.kill();
        this.fErrorMonitor.kill();
        this.fInputMonitor.close();
        this.streamListener.dispose();
    }

    public IStreamMonitor getErrorStreamMonitor() {
        return this.fErrorMonitor;
    }

    public IStreamMonitor getOutputStreamMonitor() {
        return this.fOutputMonitor;
    }

    public void write(String input) throws IOException {
        if (this.isClosed(false)) {
            throw new IOException();
        }
        this.fInputMonitor.write(input);
    }

    public void closeInputStream() throws IOException {
        if (this.isClosed(false)) {
            throw new IOException();
        }
        this.fInputMonitor.closeInputStream();
    }

    public IBinaryStreamMonitor getBinaryErrorStreamMonitor() {
        return this.fErrorMonitor;
    }

    public IBinaryStreamMonitor getBinaryOutputStreamMonitor() {
        return this.fOutputMonitor;
    }

    public void write(byte[] data, int offset, int length) throws IOException {
        if (this.isClosed(false)) {
            throw new IOException();
        }
        this.fInputMonitor.write(data, offset, length);
    }
}

