/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.debug.gdbjtag.openocd.dsf;

import com.espressif.idf.debug.gdbjtag.openocd.Activator;
import com.espressif.idf.debug.gdbjtag.openocd.Configuration;
import com.espressif.idf.debug.gdbjtag.openocd.dsf.GdbServerBackend;
import com.espressif.idf.debug.gdbjtag.openocd.dsf.Launch;
import com.espressif.idf.debug.gdbjtag.openocd.dsf.ServicesFactory;
import com.espressif.idf.debug.gdbjtag.openocd.ui.Messages;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitorWithProgress;
import org.eclipse.cdt.dsf.concurrent.Sequence;
import org.eclipse.cdt.dsf.debug.service.IDsfDebugServicesFactory;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.cdt.dsf.gdb.launching.LaunchMessages;
import org.eclipse.cdt.dsf.gdb.launching.ServicesLaunchSequence;
import org.eclipse.cdt.dsf.gdb.service.SessionType;
import org.eclipse.cdt.dsf.gdb.service.command.IGDBControl;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.launch.LaunchUtils;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.embedcdt.core.StringUtils;
import org.eclipse.embedcdt.debug.gdbjtag.core.DebugUtils;
import org.eclipse.embedcdt.debug.gdbjtag.core.dsf.AbstractGnuMcuLaunchConfigurationDelegate;
import org.eclipse.embedcdt.debug.gdbjtag.core.dsf.GnuMcuServerServicesLaunchSequence;

public class LaunchConfigurationDelegate
extends AbstractGnuMcuLaunchConfigurationDelegate {
    private static final String NON_STOP_FIRST_VERSION = "6.8.50";
    private final int STATUS_DLL_NOT_FOUND = -1073741515;
    ILaunchConfiguration fConfig = null;
    private boolean fIsNonStopSession = false;
    private boolean fDoStartGdbServer = false;
    private boolean fDoStartGdbClient = true;
    private boolean fIgnoreGdbClient = false;

    protected IDsfDebugServicesFactory newServiceFactory(ILaunchConfiguration config, String version) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("openocd.LaunchConfigurationDelegate.newServiceFactory(" + config.getName() + "," + version + ") " + String.valueOf((Object)this));
        }
        this.fConfig = config;
        return new ServicesFactory(version, "debug");
    }

    protected IDsfDebugServicesFactory newServiceFactory(ILaunchConfiguration config, String version, String mode) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("openocd.LaunchConfigurationDelegate.newServiceFactory(" + config.getName() + "," + version + "," + mode + ") " + String.valueOf((Object)this));
        }
        this.fConfig = config;
        return new ServicesFactory(version, mode);
    }

    public void ignoreGdbClient() {
        this.fIgnoreGdbClient = true;
    }

    public void doNotIngoreGdbClient() {
        this.fIgnoreGdbClient = false;
    }

    protected GdbLaunch createGdbLaunch(ILaunchConfiguration configuration, String mode, ISourceLocator locator) throws CoreException {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("openocd.LaunchConfigurationDelegate.createGdbLaunch(" + configuration.getName() + "," + mode + ") " + String.valueOf((Object)this));
        }
        this.fDoStartGdbServer = Configuration.getDoStartGdbServer(configuration);
        if (!this.fIgnoreGdbClient) {
            this.fDoStartGdbClient = Configuration.getDoStartGdbClient(configuration);
        }
        DebugUtils.checkLaunchConfigurationStarted((ILaunchConfiguration)configuration);
        return new Launch(configuration, mode, locator);
    }

    protected String getGDBVersion(ILaunchConfiguration config) throws CoreException {
        String gdbClientCommand = Configuration.getGdbClientCommand(config, null);
        String version = this.getGDBVersion(config, gdbClientCommand);
        if (Activator.getInstance().isDebugging()) {
            System.out.println("openocd.LaunchConfigurationDelegate.getGDBVersion " + version);
        }
        return version;
    }

    private String getGDBVersion(ILaunchConfiguration configuration, String gdbClientCommand) throws CoreException {
        Process process;
        String[] cmdArray = new String[]{gdbClientCommand, "--version"};
        try {
            process = ProcessFactory.getFactory().exec(cmdArray, DebugUtils.getLaunchEnvironment((ILaunchConfiguration)configuration));
        }
        catch (IOException e) {
            throw new DebugException((IStatus)new Status(4, "com.espressif.idf.debug.gdbjtag.openocd", 5012, "Error while launching command: " + StringUtils.join((String[])cmdArray, (String)" "), e.getCause()));
        }
        Job timeoutJob = new Job("GDB version timeout job"){
            {
                super($anonymous0);
                this.setSystem(true);
            }

            protected IStatus run(IProgressMonitor arg) {
                process.destroy();
                return Status.OK_STATUS;
            }
        };
        timeoutJob.schedule(10000L);
        InputStream stream = null;
        StringBuilder cmdOutput = new StringBuilder(200);
        try {
            try {
                String line;
                stream = process.getInputStream();
                InputStreamReader r = new InputStreamReader(stream);
                BufferedReader reader = new BufferedReader(r);
                while ((line = reader.readLine()) != null) {
                    cmdOutput.append(line);
                    cmdOutput.append('\n');
                }
            }
            catch (IOException e) {
                throw new DebugException((IStatus)new Status(4, "com.espressif.idf.debug.gdbjtag.openocd", 5012, "Error reading GDB STDOUT after sending: " + StringUtils.join((String[])cmdArray, (String)" ") + ", response: " + String.valueOf(cmdOutput), e.getCause()));
            }
        }
        finally {
            timeoutJob.cancel();
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
            process.destroy();
        }
        String gdbVersion = org.eclipse.cdt.dsf.gdb.launching.LaunchUtils.getGDBVersionFromText((String)cmdOutput.toString());
        if (gdbVersion == null || gdbVersion.isEmpty()) {
            String errorMessage = process.exitValue() == -1073741515 ? Messages.DllNotFound_ExceptionMessage : cmdOutput.toString();
            throw new DebugException((IStatus)new Status(4, "com.espressif.idf.debug.gdbjtag.openocd", 5012, "Could not determine GDB version after sending: " + StringUtils.join((String[])cmdArray, (String)" ") + ", response: \n" + errorMessage + "\nERROR CODE:" + process.exitValue(), null));
        }
        return gdbVersion;
    }

    public void launchWithoutGdbClient(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        this.fDoStartGdbClient = false;
        this.launch(config, mode, launch, monitor);
    }

    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("openocd.LaunchConfigurationDelegate.launch(" + config.getName() + "," + mode + ") " + String.valueOf((Object)this));
        }
        LaunchUtils.enableActivity((String)"org.eclipse.cdt.debug.dsfgdbActivity", (boolean)true);
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (mode.equals("debug") || mode.equals("run")) {
            this.launchDebugger(config, launch, monitor);
        }
    }

    private void launchDebugger(ILaunchConfiguration config, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("openocd.LaunchConfigurationDelegate.launchDebugger(" + config.getName() + ") " + String.valueOf((Object)this));
        }
        int totalWork = 10;
        if (this.fDoStartGdbServer) {
            ++totalWork;
        }
        monitor.beginTask(LaunchMessages.getString((String)"GdbLaunchDelegate.0"), totalWork);
        if (monitor.isCanceled()) {
            this.cleanupLaunch(launch);
            return;
        }
        try {
            this.launchDebugSession(config, launch, monitor);
        }
        finally {
            monitor.done();
        }
    }

    protected void launchDebugSession(ILaunchConfiguration config, ILaunch l, IProgressMonitor monitor) throws CoreException {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("openocd.LaunchConfigurationDelegate.launchDebugSession(" + config.getName() + ") " + String.valueOf((Object)this));
        }
        if (monitor.isCanceled()) {
            this.cleanupLaunch(l);
            return;
        }
        SessionType sessionType = org.eclipse.cdt.dsf.gdb.launching.LaunchUtils.getSessionType((ILaunchConfiguration)config);
        boolean attach = org.eclipse.cdt.dsf.gdb.launching.LaunchUtils.getIsAttach((ILaunchConfiguration)config);
        final GdbLaunch launch = (GdbLaunch)l;
        if (sessionType == SessionType.REMOTE) {
            monitor.subTask(LaunchMessages.getString((String)"GdbLaunchDelegate.1"));
        } else if (sessionType == SessionType.CORE) {
            monitor.subTask(LaunchMessages.getString((String)"GdbLaunchDelegate.2"));
        } else {
            assert (sessionType == SessionType.LOCAL) : "Unexpected session type: " + sessionType.toString();
            monitor.subTask(LaunchMessages.getString((String)"GdbLaunchDelegate.3"));
        }
        if (!attach) {
            this.checkBinaryDetails(config);
        }
        monitor.worked(1);
        this.fIsNonStopSession = org.eclipse.cdt.dsf.gdb.launching.LaunchUtils.getIsNonStopMode((ILaunchConfiguration)config);
        String gdbVersion = this.getGDBVersion(config);
        if (org.eclipse.cdt.dsf.gdb.launching.LaunchUtils.getIsNonStopMode((ILaunchConfiguration)config) && !this.isNonStopSupportedInGdbVersion(gdbVersion)) {
            this.cleanupLaunch((ILaunch)launch);
            throw new DebugException((IStatus)new Status(4, "com.espressif.idf.debug.gdbjtag.openocd", 5012, "Non-stop mode is not supported for GDB " + gdbVersion + ", GDB 6.8.50 or higher is required.", null));
        }
        if (org.eclipse.cdt.dsf.gdb.launching.LaunchUtils.getIsPostMortemTracing((ILaunchConfiguration)config) && !this.isPostMortemTracingSupportedInGdbVersion(gdbVersion)) {
            this.cleanupLaunch((ILaunch)launch);
            throw new DebugException((IStatus)new Status(4, "com.espressif.idf.debug.gdbjtag.openocd", 5012, "Post-mortem tracing is not supported for GDB " + gdbVersion + ", GDB 6.8.50 or higher is required.", null));
        }
        launch.setServiceFactory(this.newServiceFactory(config, gdbVersion, launch.getLaunchMode()));
        launch.initialize();
        boolean succeed = false;
        SubProgressMonitor subMonServer = new SubProgressMonitor(monitor, 4, 4);
        Sequence serverServicesLaunchSequence = this.getServerServicesSequence(launch.getSession(), (ILaunch)launch, (IProgressMonitor)subMonServer);
        try {
            try {
                launch.getSession().getExecutor().execute((Runnable)serverServicesLaunchSequence);
                serverServicesLaunchSequence.get();
                succeed = true;
            }
            catch (InterruptedException e1) {
                throw new DebugException((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 5013, "Interrupted Exception in dispatch thread", (Throwable)e1));
            }
            catch (ExecutionException e1) {
                if (e1.getMessage().contains("Starting OpenOCD timed out.")) {
                    Status status = new Status(0, "com.espressif.idf.debug.gdbjtag.openocd", 5012, "Error in services launch sequence", e1.getCause());
                    DebugPlugin.getDefault().getStatusHandler((IStatus)status).handleStatus((IStatus)status, null);
                    throw new DebugException(Status.OK_STATUS);
                }
                throw new DebugException((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 5012, "Error in services launch sequence", e1.getCause()));
            }
            catch (CancellationException e1) {
                if (Activator.getInstance().isDebugging()) {
                    System.out.println("openocd.LaunchConfigurationDelegate.launchDebugger() aborted, so exit cleanly");
                }
                if (!succeed) {
                    this.cleanupLaunch((ILaunch)launch);
                }
                return;
            }
        }
        finally {
            if (!succeed) {
                this.cleanupLaunch((ILaunch)launch);
            }
        }
        if (this.fDoStartGdbServer) {
            ((Launch)launch).initializeServerConsole(monitor);
            try {
                Callable<IStatus> callable = new Callable<IStatus>(){

                    @Override
                    public IStatus call() throws CoreException {
                        DsfServicesTracker tracker = new DsfServicesTracker(GdbPlugin.getBundleContext(), launch.getSession().getId());
                        GdbServerBackend backend = (GdbServerBackend)((Object)tracker.getService(GdbServerBackend.class));
                        if (backend != null) {
                            return backend.getServerExitStatus();
                        }
                        throw new CoreException((IStatus)new Status(4, "com.espressif.idf.debug.gdbjtag.openocd", "Could not start GDB server."));
                    }
                };
                IStatus serverStatus = null;
                while (serverStatus == null) {
                    if (monitor.isCanceled()) {
                        if (Activator.getInstance().isDebugging()) {
                            System.out.println("openocd.LaunchConfigurationDelegate.launchDebugSession() sleep cancelled" + String.valueOf((Object)this));
                        }
                        this.cleanupLaunch((ILaunch)launch);
                        return;
                    }
                    Thread.sleep(10L);
                    serverStatus = (IStatus)launch.getSession().getExecutor().submit((Callable)callable).get();
                    if (!Activator.getInstance().isDebugging()) continue;
                    System.out.print('!');
                }
                if (serverStatus != Status.OK_STATUS) {
                    if ("TERMINATED".equals(serverStatus.getMessage())) {
                        this.cleanupLaunch((ILaunch)launch);
                        return;
                    }
                    if (Activator.getInstance().isDebugging()) {
                        System.out.println("openocd.LaunchConfigurationDelegate.launchDebugger() " + String.valueOf(serverStatus));
                    }
                    throw new CoreException(serverStatus);
                }
            }
            catch (InterruptedException e) {
                Activator.log(e);
            }
            catch (ExecutionException e) {
                Activator.log(e);
            }
            if (Activator.getInstance().isDebugging()) {
                System.out.println("openocd.LaunchConfigurationDelegate.launchDebugSession() * Server start confirmed. *");
            }
        }
        if (!this.fDoStartGdbClient) {
            if (Activator.getInstance().isDebugging()) {
                System.out.println("openocd.LaunchConfigurationDelegate.launchDebugSession() No GDB client, abruptly return.");
            }
            return;
        }
        SubProgressMonitor subMon1 = new SubProgressMonitor(monitor, 4, 4);
        Sequence servicesLaunchSequence = this.getServicesSequence(launch.getSession(), (ILaunch)launch, (IProgressMonitor)subMon1);
        launch.getSession().getExecutor().execute((Runnable)servicesLaunchSequence);
        try {
            try {
                servicesLaunchSequence.get();
                succeed = true;
            }
            catch (InterruptedException e1) {
                throw new DebugException((IStatus)new Status(4, "com.espressif.idf.debug.gdbjtag.openocd", 5013, "Interrupted Exception in dispatch thread", (Throwable)e1));
            }
            catch (ExecutionException e1) {
                throw new DebugException((IStatus)new Status(4, "com.espressif.idf.debug.gdbjtag.openocd", 5012, "Error in services launch sequence", e1.getCause()));
            }
            catch (CancellationException e1) {
                if (!succeed) {
                    this.cleanupLaunch((ILaunch)launch);
                }
                return;
            }
        }
        finally {
            if (!succeed) {
                this.cleanupLaunch((ILaunch)launch);
            }
        }
        if (monitor.isCanceled()) {
            this.cleanupLaunch((ILaunch)launch);
            return;
        }
        launch.initializeControl();
        ((Launch)launch).initializeConsoles(monitor);
        SubProgressMonitor subMon2 = new SubProgressMonitor(monitor, 4, 4);
        Query<Object> completeLaunchQuery = new Query<Object>((IProgressMonitor)subMon2){
            private final /* synthetic */ IProgressMonitor val$subMon2;
            {
                this.val$subMon2 = iProgressMonitor;
            }

            protected void execute(final DataRequestMonitor<Object> rm) {
                DsfServicesTracker tracker = new DsfServicesTracker(GdbPlugin.getBundleContext(), launch.getSession().getId());
                IGDBControl control = (IGDBControl)tracker.getService(IGDBControl.class);
                tracker.dispose();
                control.completeInitialization((RequestMonitor)new RequestMonitorWithProgress(ImmediateExecutor.getInstance(), this.val$subMon2){

                    protected void handleCompleted() {
                        if (this.isCanceled()) {
                            rm.cancel();
                        } else {
                            rm.setStatus(this.getStatus());
                        }
                        rm.done();
                    }
                });
            }
        };
        launch.getSession().getExecutor().execute((Runnable)completeLaunchQuery);
        succeed = false;
        try {
            try {
                completeLaunchQuery.get();
                succeed = true;
            }
            catch (InterruptedException e1) {
                throw new DebugException((IStatus)new Status(4, "com.espressif.idf.debug.gdbjtag.openocd", 5013, "Interrupted Exception in dispatch thread", (Throwable)e1));
            }
            catch (ExecutionException e1) {
                throw new DebugException((IStatus)new Status(4, "com.espressif.idf.debug.gdbjtag.openocd", 5012, "Error in final launch sequence", e1.getCause()));
            }
            catch (CancellationException e1) {
                if (!succeed) {
                    this.cleanupLaunch((ILaunch)launch);
                }
                return;
            }
        }
        finally {
            if (!succeed) {
                this.cleanupLaunch((ILaunch)launch);
            }
        }
    }

    protected IPath checkBinaryDetails(ILaunchConfiguration config) throws CoreException {
        boolean doStartServer = true;
        try {
            doStartServer = Configuration.getDoStartGdbServer(config);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        if (doStartServer) {
            String configOptions = "";
            try {
                configOptions = Configuration.getGdbServerOtherConfig(config);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            if (configOptions.isEmpty()) {
                throw new CoreException((IStatus)new Status(4, "com.espressif.idf.debug.gdbjtag.openocd", "Missing mandatory configuration. Fill-in the 'Config options:' field in the Debugger tab."));
            }
        }
        IPath path = super.checkBinaryDetails(config);
        return path;
    }

    protected Sequence getServicesSequence(DsfSession session, ILaunch launch, IProgressMonitor progressMonitor) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("openocd.LaunchConfigurationDelegate.getServicesSequence()");
        }
        return new ServicesLaunchSequence(session, (GdbLaunch)launch, progressMonitor);
    }

    protected Sequence getServerServicesSequence(DsfSession session, ILaunch launch, IProgressMonitor progressMonitor) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("openocd.LaunchConfigurationDelegate.getServerServicesSequence()");
        }
        return new GnuMcuServerServicesLaunchSequence(session, (GdbLaunch)launch, progressMonitor);
    }
}

