/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.launch.serial.ui.internal;

import com.espressif.idf.core.DefaultBoardProvider;
import com.espressif.idf.core.configparser.EspConfigParser;
import com.espressif.idf.core.configparser.vo.Board;
import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.toolchain.ESPToolChainManager;
import com.espressif.idf.core.util.EspToolCommands;
import com.espressif.idf.core.util.IDFUtil;
import com.espressif.idf.core.util.StringUtil;
import com.espressif.idf.launch.serial.ui.internal.Activator;
import com.espressif.idf.launch.serial.ui.internal.Messages;
import com.fazecast.jSerialComm.SerialPort;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.build.IToolChain;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.launchbar.core.target.ILaunchTarget;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class NewSerialFlashTargetWizardPage
extends WizardPage {
    private static final String PORT_NAME_DESCRIPTOR_SPLITOR = " ";
    private static final String OS = "esp32";
    private static final String ARCH = "xtensa";
    private ILaunchTarget launchTarget;
    private Text nameText;
    private Combo serialPortCombo;
    private Combo idfTargetCombo;
    private Text infoArea;
    private Map<String, List<String>> targetPortMap;
    private TargetPortInfo targetPortInfo;
    private Display display;
    private String serialPort;
    private Combo fBoardCombo;
    private Combo fFlashVoltage;
    private String previousBoard = null;

    public NewSerialFlashTargetWizardPage(ILaunchTarget launchTarget) {
        super(NewSerialFlashTargetWizardPage.class.getName());
        this.launchTarget = launchTarget;
        this.targetPortMap = new HashMap<String, List<String>>();
        this.setTitle(Messages.NewSerialFlashTargetWizardPage_Title);
        this.setDescription(Messages.NewSerialFlashTargetWizardPage_Description);
        this.targetPortInfo = new TargetPortInfo("PORT_INFO");
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        this.setControl((Control)comp);
        this.display = comp.getDisplay();
        Label label = new Label(comp, 0);
        label.setText(Messages.NewSerialFlashTargetWizardPage_Name);
        this.nameText = new Text(comp, 2048);
        this.nameText.setLayoutData((Object)new GridData(4, 4, true, false));
        if (this.launchTarget != null) {
            this.nameText.setText(this.launchTarget.getId());
        }
        label = new Label(comp, 0);
        label.setText(Messages.NewSerialFlashTargetWizardPage_IDFTarget);
        this.idfTargetCombo = new Combo(comp, 0);
        GridData idfTargetComboGridData = new GridData(4, 0x1000000, true, false);
        idfTargetComboGridData.minimumWidth = 250;
        this.idfTargetCombo.setLayoutData((Object)idfTargetComboGridData);
        List<String> idfTargetList = this.getIDFTargetList();
        this.idfTargetCombo.setItems(idfTargetList.toArray(new String[idfTargetList.size()]));
        this.idfTargetCombo.setToolTipText(Messages.NewSerialFlashTargetWizardPage_IDFTargetToolTipMsg);
        this.idfTargetCombo.addSelectionListener((SelectionListener)new TargetComboSelectionAdapter());
        this.idfTargetCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String selectedTargetString = NewSerialFlashTargetWizardPage.this.idfTargetCombo.getText();
                Shell shell = NewSerialFlashTargetWizardPage.this.display.getActiveShell();
                ArrayList boardDisplayNames = new ArrayList();
                String[] jsonHolder = new String[1];
                try {
                    ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell);
                    dialog.run(true, false, monitor -> {
                        monitor.beginTask("Finding the Connected Boards...", -1);
                        if (IDFUtil.espDetectConfigScriptExists()) {
                            String json;
                            stringArray[0] = json = IDFUtil.runEspDetectConfigScript();
                            Logger.log((String)("esp_detect_config.py JSON output: " + json));
                            if (json != null) {
                                try {
                                    JSONObject root = (JSONObject)new JSONParser().parse(json);
                                    JSONArray boards = (JSONArray)root.get((Object)"boards");
                                    boardDisplayNames.addAll(NewSerialFlashTargetWizardPage.this.getBoardDisplayNamesForTarget(selectedTargetString, boards));
                                }
                                catch (Exception ex) {
                                    Logger.log((Exception)ex);
                                }
                            }
                        } else {
                            EspConfigParser parser = new EspConfigParser();
                            List boards = parser.getBoardsForTarget(selectedTargetString);
                            String[] boardNames = (String[])boards.stream().map(Board::name).toArray(String[]::new);
                            boardDisplayNames.addAll(Arrays.asList(boardNames));
                        }
                        monitor.done();
                    });
                }
                catch (Exception ex) {
                    Logger.log((Exception)ex);
                }
                NewSerialFlashTargetWizardPage.this.display.asyncExec(() -> {
                    NewSerialFlashTargetWizardPage.this.fBoardCombo.setItems(boardDisplayNames.toArray(new String[0]));
                    if (!boardDisplayNames.isEmpty()) {
                        int defaultIdx = 0;
                        if (jsonHolder[0] == null) {
                            defaultIdx = new DefaultBoardProvider().getIndexOfDefaultBoard(selectedTargetString, boardDisplayNames.toArray(new String[0]));
                        }
                        if (NewSerialFlashTargetWizardPage.this.previousBoard != null) {
                            int idx = -1;
                            int i = 0;
                            while (i < boardDisplayNames.size()) {
                                if (((String)boardDisplayNames.get(i)).equals(NewSerialFlashTargetWizardPage.this.previousBoard)) {
                                    idx = i;
                                    break;
                                }
                                ++i;
                            }
                            if (idx != -1) {
                                NewSerialFlashTargetWizardPage.this.fBoardCombo.select(idx);
                            } else {
                                NewSerialFlashTargetWizardPage.this.fBoardCombo.deselectAll();
                            }
                        } else {
                            NewSerialFlashTargetWizardPage.this.fBoardCombo.select(defaultIdx);
                        }
                    }
                });
                super.widgetSelected(e);
            }
        });
        if (this.idfTargetCombo.getItemCount() > 0 && this.idfTargetCombo.getSelectionIndex() < 0) {
            this.idfTargetCombo.select(0);
        }
        this.createJtagGroup(comp);
        label = new Label(comp, 0);
        label.setText(Messages.NewSerialFlashTargetWizardPage_SerialPort);
        this.serialPortCombo = new Combo(comp, 8);
        GridData serialPortComboGridData = new GridData(4, 0x1000000, true, false);
        serialPortComboGridData.minimumWidth = 250;
        this.serialPortCombo.setLayoutData((Object)serialPortComboGridData);
        this.serialPortCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewSerialFlashTargetWizardPage.this.display.asyncExec(() -> {
                    if (NewSerialFlashTargetWizardPage.this.targetPortInfo.getState() == 4) {
                        NewSerialFlashTargetWizardPage.this.targetPortInfo.cancel();
                    }
                    NewSerialFlashTargetWizardPage.this.serialPort = NewSerialFlashTargetWizardPage.this.serialPortCombo.getText().split(NewSerialFlashTargetWizardPage.PORT_NAME_DESCRIPTOR_SPLITOR)[0];
                    NewSerialFlashTargetWizardPage.this.targetPortInfo.schedule();
                });
            }
        });
        try {
            String[] ports;
            String[] stringArray = ports = org.eclipse.cdt.serial.SerialPort.list();
            int n = ports.length;
            int n2 = 0;
            while (n2 < n) {
                String port = stringArray[n2];
                StringBuilder comboString = new StringBuilder();
                comboString.append(port);
                SerialPort serialComPort = SerialPort.getCommPort((String)port);
                if (serialComPort != null) {
                    comboString.append(PORT_NAME_DESCRIPTOR_SPLITOR);
                    comboString.append(serialComPort.getDescriptivePortName());
                }
                this.serialPortCombo.add(comboString.toString());
                ++n2;
            }
        }
        catch (Exception e) {
            Activator.log((IStatus)new Status(4, "com.espressif.idf.launch.serial.ui", Messages.NewSerialFlashTargetWizardPage_Fetching, (Throwable)e));
        }
        this.infoArea = new Text(comp, 2826);
        GridData infoAreaGridData = new GridData(4, 4, true, true, 2, 1);
        infoAreaGridData.heightHint = 100;
        this.infoArea.setLayoutData((Object)infoAreaGridData);
        this.setDefaults();
    }

    private void setDefaults() {
        if (this.launchTarget == null) {
            return;
        }
        this.setDefaultTargetAndBoard();
        this.setDefaultVoltage();
        this.setDefaultSerialPort();
    }

    private void setDefaultVoltage() {
        String flashVoltage = this.launchTarget.getAttribute("com.espressif.idf.launch.serial.core.flash_voltage", null);
        if (flashVoltage != null) {
            this.fFlashVoltage.setText(flashVoltage);
        }
    }

    private void setDefaultTargetAndBoard() {
        String idfTarget = this.launchTarget.getAttribute("com.espressif.idf.launch.serial.core.idfTarget", null);
        if (idfTarget != null) {
            int index = this.getIDFTargetList().indexOf(idfTarget);
            if (index != -1) {
                this.idfTargetCombo.select(index);
            } else {
                this.idfTargetCombo.setText(idfTarget);
            }
            this.idfTargetCombo.notifyListeners(13, null);
        }
        this.previousBoard = this.launchTarget.getAttribute("com.espressif.idf.launch.serial.core.board", null);
    }

    private void setDefaultSerialPort() {
        if (this.serialPortCombo.getItemCount() < 0 || this.launchTarget == null) {
            return;
        }
        String targetPort = this.launchTarget.getAttribute("com.espressif.idf.launch.serial.core.serialPort", null);
        if (targetPort != null && !targetPort.isEmpty()) {
            int i = 0;
            String[] stringArray = this.serialPortCombo.getItems();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String port = stringArray[n2];
                if (port.contains(targetPort)) {
                    this.serialPortCombo.select(i);
                    break;
                }
                ++i;
                ++n2;
            }
        }
    }

    private void createJtagGroup(Composite comp) {
        EspConfigParser parser = new EspConfigParser();
        Group jtaGroup = new Group(comp, 0);
        jtaGroup.setLayout((Layout)new GridLayout(2, false));
        jtaGroup.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        jtaGroup.setText(Messages.jtagGroupLbl);
        Label fVoltageLbl = new Label((Composite)jtaGroup, 0);
        fVoltageLbl.setText(Messages.flashVoltageLabel);
        this.fFlashVoltage = new Combo((Composite)jtaGroup, 2060);
        this.fFlashVoltage.setItems(parser.getEspFlashVoltages().toArray(new String[0]));
        this.fFlashVoltage.setText("default");
        Label fTargetLbl = new Label((Composite)jtaGroup, 0);
        fTargetLbl.setText(Messages.configBoardLabel);
        this.fBoardCombo = new Combo((Composite)jtaGroup, 2060);
        GridData boardComboGridData = new GridData(4, 0x1000000, true, false);
        boardComboGridData.minimumWidth = 250;
        this.fBoardCombo.setLayoutData((Object)boardComboGridData);
        String selectedTargetString = this.getIDFTarget();
        List boards = parser.getBoardsForTarget(selectedTargetString);
        this.fBoardCombo.setItems((String[])boards.stream().map(Board::name).toArray(String[]::new));
        this.fBoardCombo.select(new DefaultBoardProvider().getIndexOfDefaultBoard(selectedTargetString, this.fBoardCombo.getItems()));
    }

    public void dispose() {
        if (this.targetPortInfo.getState() == 4) {
            this.targetPortInfo.cancel();
        }
        super.dispose();
    }

    public String getTargetName() {
        return this.nameText.getText();
    }

    public String getOS() {
        return this.getModel();
    }

    public String getVoltage() {
        return this.fFlashVoltage.getText();
    }

    public String getBoard() {
        return this.fBoardCombo.getText();
    }

    private String getModel() {
        String idfTarget = this.getIDFTarget();
        List<String> idfTargetList = this.getIDFTargetList();
        int index = idfTargetList.indexOf(idfTarget);
        if (index != -1) {
            return idfTarget;
        }
        return OS;
    }

    public String getArch() {
        for (IToolChain map : this.getToolchains()) {
            if (!map.getProperty("os").equals(this.getIDFTarget())) continue;
            return map.getProperty("arch");
        }
        return ARCH;
    }

    public String getIDFTarget() {
        return this.idfTargetCombo.getText();
    }

    public String getSerialPortName() {
        return this.serialPortCombo.getText().split(PORT_NAME_DESCRIPTOR_SPLITOR)[0];
    }

    private List<String> getIDFTargetList() {
        return new ESPToolChainManager().getAvailableEspTargetList();
    }

    private Collection<IToolChain> getToolchains() {
        return new ESPToolChainManager().getAllEspToolchains();
    }

    public String getSelectedBoardUsbLocation() {
        String selected = this.fBoardCombo.getText();
        int idx = selected.lastIndexOf("[");
        int endIdx = selected.lastIndexOf("]");
        if (idx != -1 && endIdx != -1 && endIdx > idx) {
            return selected.substring(idx + 1, endIdx);
        }
        return null;
    }

    private List<String> getBoardDisplayNamesForTarget(String selectedTarget, JSONArray boards) {
        ArrayList<String> boardDisplayNames = new ArrayList<String>();
        for (Object obj : boards) {
            JSONObject board = (JSONObject)obj;
            if (!selectedTarget.equals(board.get((Object)"target"))) continue;
            String name = (String)board.get((Object)"name");
            String location = (String)board.get((Object)"location");
            boardDisplayNames.add(String.format("%s [%s]", name, location));
        }
        return boardDisplayNames;
    }

    private class TargetComboSelectionAdapter
    extends SelectionAdapter {
        private TargetComboSelectionAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            String selectedTarget = NewSerialFlashTargetWizardPage.this.idfTargetCombo.getText();
            List<String> comPortList = NewSerialFlashTargetWizardPage.this.targetPortMap.get(selectedTarget);
            if (comPortList != null && !comPortList.isEmpty()) {
                NewSerialFlashTargetWizardPage.this.serialPortCombo.select(NewSerialFlashTargetWizardPage.this.serialPortCombo.indexOf(comPortList.get(0)));
                NewSerialFlashTargetWizardPage.this.infoArea.setText(String.format(Messages.TargetPortInformationMessage, selectedTarget, comPortList.toString()));
                SerialPort serialPort = SerialPort.getCommPort((String)comPortList.get(0));
                if (serialPort != null) {
                    NewSerialFlashTargetWizardPage.this.infoArea.setText(serialPort.getDescriptivePortName() + System.lineSeparator() + NewSerialFlashTargetWizardPage.this.infoArea.getText());
                }
            }
        }
    }

    private class TargetPortInfo
    extends Job {
        public TargetPortInfo(String name) {
            super(name);
        }

        protected IStatus run(IProgressMonitor monitor) {
            EspToolCommands espToolCommands = new EspToolCommands();
            String message = String.format(Messages.TargetPortUpdatingMessage, NewSerialFlashTargetWizardPage.this.serialPort);
            NewSerialFlashTargetWizardPage.this.display.asyncExec(() -> {
                if (NewSerialFlashTargetWizardPage.this.infoArea != null && !NewSerialFlashTargetWizardPage.this.infoArea.isDisposed()) {
                    NewSerialFlashTargetWizardPage.this.infoArea.append(System.lineSeparator() + message);
                }
            });
            try {
                String readLine;
                Process chipInfoProcess = espToolCommands.chipInformation(NewSerialFlashTargetWizardPage.this.serialPort);
                InputStream targetIn = chipInfoProcess.getInputStream();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(targetIn));
                StringBuilder chipInfo = new StringBuilder();
                while ((readLine = bufferedReader.readLine()) != null) {
                    NewSerialFlashTargetWizardPage.this.display.asyncExec(() -> NewSerialFlashTargetWizardPage.this.infoArea.append("."));
                    chipInfo.append(readLine);
                    chipInfo.append(System.lineSeparator());
                }
                String chipType = this.extractChipFromChipInfoOutput(chipInfo.toString());
                NewSerialFlashTargetWizardPage.this.display.asyncExec(() -> {
                    if (StringUtil.isEmpty((String)chipType)) {
                        if (NewSerialFlashTargetWizardPage.this.infoArea != null && !NewSerialFlashTargetWizardPage.this.infoArea.isDisposed()) {
                            NewSerialFlashTargetWizardPage.this.infoArea.setText(NewSerialFlashTargetWizardPage.this.infoArea.getText() + System.lineSeparator() + String.format(Messages.TargetPortNotFoundMessage, NewSerialFlashTargetWizardPage.this.serialPort));
                        }
                    } else {
                        NewSerialFlashTargetWizardPage.this.infoArea.append(System.lineSeparator());
                        NewSerialFlashTargetWizardPage.this.infoArea.append(String.format(Messages.TargetPortFoundMessage, NewSerialFlashTargetWizardPage.this.serialPort, chipType));
                    }
                });
            }
            catch (Exception e) {
                Logger.log((Exception)e);
            }
            NewSerialFlashTargetWizardPage.this.display.asyncExec(() -> NewSerialFlashTargetWizardPage.this.infoArea.append(System.lineSeparator()));
            return Status.OK_STATUS;
        }

        private String extractChipFromChipInfoOutput(String chipInfoOutput) {
            Pattern pattern = Pattern.compile("Chip is (ESP32[^\\s]*)");
            Matcher matcher = pattern.matcher(chipInfoOutput);
            if (matcher.find()) {
                String chipType = matcher.group(1);
                chipType = chipType.replace(NewSerialFlashTargetWizardPage.PORT_NAME_DESCRIPTOR_SPLITOR, "").toLowerCase();
                return chipType;
            }
            return "";
        }
    }
}

