/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.wokwi;

import com.espressif.idf.core.IDFEnvironmentVariables;
import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.util.IDFUtil;
import com.espressif.idf.core.util.SDKConfigJsonReader;
import com.espressif.idf.core.util.StringUtil;
import com.espressif.idf.wokwi.Messages;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class WokwiSimulatorHandler {
    public void execute(ILaunchConfiguration configuration, ILaunch launch, IProject project) throws ExecutionException, CoreException {
        SDKConfigJsonReader sdkconfig = new SDKConfigJsonReader(project);
        String target = sdkconfig.getValue("IDF_TARGET");
        String elfFilePath = IDFUtil.getELFFilePath((IProject)project).toOSString();
        String wokwiExecutablePath = this.getWokwiServerPath();
        if (StringUtil.isEmpty((String)wokwiExecutablePath)) {
            final String msg = Messages.WokwiSimulatorHandler_ServerPathNotFound;
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.WokwiSimulatorHandler_ServerNotFound, (String)msg);
                }
            });
            return;
        }
        String diagram_id = configuration.getAttribute("ATTR_WOKWI_PROJECT_ID", "");
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(wokwiExecutablePath);
        arguments.add("--chip");
        arguments.add(target);
        if (!StringUtil.isEmpty((String)diagram_id)) {
            arguments.add("--id");
            arguments.add(diagram_id);
        }
        arguments.add(elfFilePath);
        try {
            this.startWokwiServer(arguments, project, launch);
        }
        catch (IOException | CoreException e) {
            Logger.log((Exception)e);
        }
    }

    private void startWokwiServer(List<String> arguments, IProject project, ILaunch launch) throws IOException, CoreException {
        ProcessBuilder processBuilder = new ProcessBuilder(arguments);
        Process process = processBuilder.start();
        DebugPlugin.newProcess((ILaunch)launch, (Process)process, (String)String.join((CharSequence)" ", arguments));
    }

    private String getWokwiServerPath() {
        IEnvironmentVariable env = new IDFEnvironmentVariables().getEnv("WOKWI_SERVER_PATH");
        if (env != null) {
            return env.getValue();
        }
        return null;
    }
}

