/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.sdk.config.ui;

import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.sdk.config.core.KConfigMenuItem;
import com.espressif.idf.sdk.config.core.server.ConfigServerManager;
import com.espressif.idf.sdk.config.core.server.JsonConfigServer;
import com.espressif.idf.sdk.config.ui.SDKConfigUIPlugin;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.viewers.TreeNodeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.json.simple.JSONObject;

public class ConfigContentProvider
extends TreeNodeContentProvider {
    private static Object[] EMPTY_ARRAY = new Object[0];
    protected TreeViewer viewer;
    private IProject project;
    private IFile file;

    public ConfigContentProvider(IProject project, IFile file) {
        this.project = project;
        this.file = file;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = (TreeViewer)viewer;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof KConfigMenuItem) {
            KConfigMenuItem element = (KConfigMenuItem)parentElement;
            List children = element.getChildren();
            try {
                return this.getMenuItems(children).toArray();
            }
            catch (IOException e) {
                Logger.log((Exception)e);
            }
        }
        return EMPTY_ARRAY;
    }

    private List<KConfigMenuItem> getMenuItems(List<KConfigMenuItem> children) throws IOException {
        JsonConfigServer configServer = ConfigServerManager.INSTANCE.getServer(this.project, this.file);
        ArrayList<KConfigMenuItem> menuList = new ArrayList<KConfigMenuItem>();
        for (KConfigMenuItem kConfigMenuItem : children) {
            if (kConfigMenuItem.getType() == null || !kConfigMenuItem.getType().equals("menu")) continue;
            JSONObject visibleJsonMap = configServer.getOutput().getVisibleJsonMap();
            Logger.logTrace((Plugin)SDKConfigUIPlugin.getDefault(), (String)("item >" + kConfigMenuItem.getTitle() + " type >" + kConfigMenuItem.getType()));
            boolean visible = kConfigMenuItem.isVisible(visibleJsonMap);
            if (!kConfigMenuItem.isMenuConfig()) {
                visible = true;
            }
            Logger.logTrace((Plugin)SDKConfigUIPlugin.getDefault(), (String)("visibility >" + kConfigMenuItem.isVisible(visibleJsonMap)));
            if (!visible) continue;
            menuList.add(kConfigMenuItem);
        }
        return menuList;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof KConfigMenuItem) {
            KConfigMenuItem configMenuItem = (KConfigMenuItem)element;
            List children = configMenuItem.getChildren();
            try {
                return this.getMenuItems(children).size() > 0;
            }
            catch (IOException e) {
                Logger.log((Exception)e);
            }
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object getParent(Object element) {
        if (element instanceof KConfigMenuItem) {
            return ((KConfigMenuItem)element).getParent();
        }
        return element;
    }
}

