/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.core.util;

import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.util.Messages;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.channels.FileChannel;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.List;
import java.util.Scanner;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

public class FileUtil {
    public static final String UTF_8 = "UTF-8";
    private static final String EMPTY_STR = "";
    private static final int BUFFER_SIZE = 8192;

    public static IStatus copyDirectory(File source, File destination, IProgressMonitor monitor, int[] count, int updateSize, boolean cancelable) throws IOException {
        if (monitor != null) {
            if (cancelable && monitor.isCanceled()) {
                return new Status(8, "com.espressif.idf.core", 8, EMPTY_STR, null);
            }
            count[0] = count[0] + 1;
            if (updateSize < 2 || count[0] % updateSize == 0) {
                monitor.setTaskName(MessageFormat.format(Messages.FileUtil_CopyingMsg, destination.toString()));
                monitor.worked(1);
            }
        }
        if (source.isDirectory()) {
            String error = null;
            if (!source.canRead()) {
                error = Messages.FileUtil_SourceDirNotavailable;
            } else if (!destination.exists()) {
                if (!destination.mkdir()) {
                    error = Messages.FileUtil_DesDirNotavailable;
                }
            } else if (!destination.isDirectory()) {
                error = Messages.FileUtil_DestinationNotaDir;
            } else if (!destination.canWrite()) {
                error = Messages.FileUtil_WritableProblemMsg;
            }
            if (error == null) {
                String[] stringArray = source.list();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String filename = stringArray[n2];
                    IStatus status = FileUtil.copyDirectory(new File(source, filename), new File(destination, filename), monitor, count, updateSize, cancelable);
                    if (status != null && !status.isOK()) {
                        return status;
                    }
                    ++n2;
                }
            } else {
                String message = MessageFormat.format(Messages.FileUtil_UnableToCopy, source, destination, error);
                Logger.logError(message);
            }
        } else {
            try {
                IFileSystem system = EFS.getLocalFileSystem();
                IFileStore src = system.fromLocalFile(source);
                src.copy(system.fromLocalFile(destination), 2, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                return new Status(4, "com.espressif.idf.core", 4, e.getMessage(), (Throwable)e);
            }
        }
        return Status.OK_STATUS;
    }

    public static IStatus copyDirectory(File source, File destination) throws IOException {
        return FileUtil.copyDirectory(source, destination, null, new int[1], 0, false);
    }

    public static void copyFile(File source, File destination) throws IOException {
        long fileSize = source.length();
        FileInputStream in = new FileInputStream(source);
        FileOutputStream out = new FileOutputStream(destination);
        if (fileSize > 0x1400000L) {
            try {
                FileUtil.pipe(in, out);
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        FileUtil.copy(in, out);
    }

    private static void copy(FileInputStream iStream, FileOutputStream oStream) throws IOException {
        try {
            FileChannel inChannel = iStream.getChannel();
            FileChannel outChannel = oStream.getChannel();
            long fileSize = inChannel.size();
            long offs = 0L;
            long doneCnt = 0L;
            long copyCnt = Math.min(65536L, fileSize);
            do {
                doneCnt = inChannel.transferTo(offs, copyCnt, outChannel);
                offs += doneCnt;
            } while ((fileSize -= doneCnt) > 0L);
        }
        finally {
            try {
                if (iStream != null) {
                    iStream.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (oStream != null) {
                    oStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void write(OutputStream stream, String rawSource, String charset) {
        if (stream == null) {
            return;
        }
        if (rawSource == null) {
            rawSource = EMPTY_STR;
        }
        if (charset == null) {
            charset = UTF_8;
        }
        OutputStreamWriter writer = null;
        try {
            try {
                writer = new OutputStreamWriter(stream, charset);
                writer.write(rawSource);
            }
            catch (IOException e) {
                Logger.log(e);
                try {
                    if (writer != null) {
                        ((Writer)writer).close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                if (writer != null) {
                    ((Writer)writer).close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static void pipe(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[8192];
        int bytes = input.read(buffer);
        while (bytes >= 0) {
            output.write(buffer, 0, bytes);
            bytes = input.read(buffer);
        }
    }

    public static String readFile(IProject project, String relativeFilePath) {
        IFile filePath = project.getFile((IPath)new Path(relativeFilePath));
        if (!filePath.exists()) {
            Logger.log(MessageFormat.format("{0} couldn't find", filePath.toString()));
            return null;
        }
        return FileUtil.readFile(filePath.getRawLocation().toOSString());
    }

    public static String readFile(String absoluteFilePath) {
        StringBuilder fileContents = new StringBuilder();
        try {
            Scanner scanner = new Scanner(new File(absoluteFilePath));
            while (scanner.hasNext()) {
                fileContents.append(scanner.nextLine());
                fileContents.append(System.getProperty("line.separator"));
            }
            scanner.close();
        }
        catch (Exception e) {
            Logger.log(e);
            return null;
        }
        return fileContents.toString();
    }

    public static void writeFile(IProject project, String relativeFilePath, String contents, boolean append) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(contents.getBytes());
        IFile filePath = project.getFile((IPath)new Path(relativeFilePath));
        try {
            if (!filePath.exists()) {
                filePath.create((InputStream)inputStream, true, null);
            } else if (append) {
                filePath.appendContents((InputStream)inputStream, true, true, null);
            } else {
                filePath.setContents((InputStream)inputStream, 1, null);
            }
        }
        catch (Exception e) {
            Logger.log(e);
        }
    }

    public static void deleteDirectory(File file) throws IOException {
        File[] entries;
        if (file.isDirectory() && (entries = file.listFiles()) != null) {
            File[] fileArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                File entry = fileArray[n2];
                FileUtil.deleteDirectory(entry);
                ++n2;
            }
        }
        if (!file.delete()) {
            throw new IOException("Failed to delete " + String.valueOf(file));
        }
    }

    public static File createFileWithContentsInDirectory(String fileName, String content, String direcotry) throws IOException {
        java.nio.file.Path directoryPath = Paths.get(direcotry, new String[0]);
        java.nio.file.Path filePath = directoryPath.resolve(fileName);
        Throwable throwable = null;
        Object var6_7 = null;
        try (FileWriter writer = new FileWriter(filePath.toFile());){
            writer.write(content);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return filePath.toFile();
    }

    public static void zipDirectory(File directoryToZip, String zipFileName) throws IOException {
        List<java.nio.file.Path> paths;
        if (directoryToZip == null || !directoryToZip.isDirectory()) {
            throw new IllegalArgumentException("directoryToZip must be an existing directory");
        }
        java.nio.file.Path base = directoryToZip.toPath();
        java.nio.file.Path zipPath = Paths.get(zipFileName, new String[0]);
        String rootName = base.getFileName().toString();
        Throwable throwable = null;
        Object var7_8 = null;
        try (Stream<java.nio.file.Path> walk = Files.walk(base, new FileVisitOption[0]);){
            paths = walk.sorted((p1, p2) -> {
                boolean d2;
                boolean d1 = Files.isDirectory(p1, new LinkOption[0]);
                if (d1 != (d2 = Files.isDirectory(p2, new LinkOption[0]))) {
                    return d1 ? -1 : 1;
                }
                String r1 = base.relativize((java.nio.file.Path)p1).toString().replace(File.separatorChar, '/');
                String r2 = base.relativize((java.nio.file.Path)p2).toString().replace(File.separatorChar, '/');
                return r1.compareTo(r2);
            }).toList();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (zipPath.getParent() != null) {
            Files.createDirectories(zipPath.getParent(), new FileAttribute[0]);
        }
        throwable = null;
        var7_8 = null;
        try (ZipOutputStream zos = new ZipOutputStream(Files.newOutputStream(zipPath, new OpenOption[0]));){
            ZipEntry rootEntry = new ZipEntry(rootName + "/");
            rootEntry.setTime(Files.getLastModifiedTime(base, new LinkOption[0]).toMillis());
            zos.putNextEntry(rootEntry);
            zos.closeEntry();
            for (java.nio.file.Path p : paths) {
                if (p.equals(base)) continue;
                String rel = base.relativize(p).toString().replace(File.separatorChar, '/');
                String entryName = rootName + "/" + rel;
                if (Files.isDirectory(p, new LinkOption[0])) {
                    if (!entryName.endsWith("/")) {
                        entryName = entryName + "/";
                    }
                    ZipEntry dirEntry = new ZipEntry(entryName);
                    dirEntry.setTime(Files.getLastModifiedTime(p, new LinkOption[0]).toMillis());
                    zos.putNextEntry(dirEntry);
                    zos.closeEntry();
                    continue;
                }
                ZipEntry fileEntry = new ZipEntry(entryName);
                fileEntry.setTime(Files.getLastModifiedTime(p, new LinkOption[0]).toMillis());
                zos.putNextEntry(fileEntry);
                Files.copy(p, zos);
                zos.closeEntry();
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }
}

