/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.core.internal;

import com.espressif.idf.core.internal.CMakeErrorParser;
import java.io.OutputStream;
import java.util.Objects;
import org.eclipse.cdt.core.ConsoleOutputStream;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

public class CMakeConsoleWrapper
implements IConsole {
    private final IConsole delegate;
    private final ConsoleOutputStream out;
    private final ConsoleOutputStream err;

    public CMakeConsoleWrapper(IContainer srcFolder, IConsole delegate) throws CoreException {
        Objects.requireNonNull(srcFolder);
        this.delegate = Objects.requireNonNull(delegate);
        this.out = new CMakeErrorParser(srcFolder, (OutputStream)delegate.getOutputStream());
        this.err = new CMakeErrorParser(srcFolder, (OutputStream)delegate.getErrorStream());
    }

    public void start(IProject project) {
        this.delegate.start(project);
    }

    public ConsoleOutputStream getInfoStream() throws CoreException {
        return this.delegate.getInfoStream();
    }

    public ConsoleOutputStream getOutputStream() throws CoreException {
        return this.out;
    }

    public ConsoleOutputStream getErrorStream() throws CoreException {
        return this.err;
    }
}

