/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.core.build;

import com.espressif.idf.core.IDFEnvironmentVariables;
import com.espressif.idf.core.build.MarkerCleanupJob;
import com.espressif.idf.core.build.Messages;
import com.espressif.idf.core.logging.Logger;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class ErrorMarkerListener
implements IResourceChangeListener {
    public void resourceChanged(IResourceChangeEvent event) {
        IMarkerDelta[] markerDeltas;
        String idfPath = new IDFEnvironmentVariables().getEnvValue("IDF_PATH");
        boolean checkForMarkers = Platform.getPreferencesService().getBoolean("com.espressif.idf.core", "hideErrorsOnIdfDerivedFiles", true, null);
        if (!checkForMarkers) {
            return;
        }
        HashSet<IProject> projects = new HashSet<IProject>();
        IMarkerDelta[] iMarkerDeltaArray = markerDeltas = event.findMarkerDeltas("org.eclipse.core.resources.marker", true);
        int n = markerDeltas.length;
        int n2 = 0;
        while (n2 < n) {
            IMarkerDelta delta = iMarkerDeltaArray[n2];
            try {
                IPath originalPath;
                if (!(delta.getMarker().getResource() instanceof IFile)) {
                    return;
                }
                IFile file = (IFile)delta.getMarker().getResource();
                projects.add(file.getProject());
                if (file.exists() && delta.getKind() == 1 && delta.getMarker().isSubtypeOf("org.eclipse.core.resources.problemmarker") && Integer.parseInt(delta.getMarker().getAttribute("severity").toString()) == 2 && file.isLinked(512) && (originalPath = file.getRawLocation()) != null && originalPath.toOSString().startsWith(idfPath)) {
                    MarkerCleanupJob markerCleanupJob = new MarkerCleanupJob(file, delta.getMarker());
                    markerCleanupJob.schedule();
                }
            }
            catch (CoreException e) {
                Logger.log((Exception)((Object)e));
            }
            ++n2;
        }
        ProjectRefreshJob projectRefreshJob = new ProjectRefreshJob(projects);
        projectRefreshJob.schedule();
    }

    public void initialMarkerCleanup() throws CoreException {
        String idfPath = new IDFEnvironmentVariables().getEnvValue("IDF_PATH");
        IMarker[] markers = ResourcesPlugin.getWorkspace().getRoot().findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
        HashSet<IProject> projects = new HashSet<IProject>();
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            if (marker.getResource() instanceof IFile) {
                IPath originalPath;
                IFile file = (IFile)marker.getResource();
                projects.add(file.getProject());
                if (file.isLinked(512) && (originalPath = file.getRawLocation()) != null && originalPath.toOSString().startsWith(idfPath)) {
                    MarkerCleanupJob markerCleanupJob = new MarkerCleanupJob(file, marker);
                    markerCleanupJob.schedule();
                }
            }
            ++n2;
        }
        ProjectRefreshJob projectRefreshJob = new ProjectRefreshJob(projects);
        projectRefreshJob.schedule();
    }

    private class ProjectRefreshJob
    extends Job {
        private Set<IProject> projects;

        private ProjectRefreshJob(Set<IProject> projects) {
            super(Messages.RefreshingProjects_JobName);
            this.projects = projects;
        }

        protected IStatus run(IProgressMonitor monitor) {
            for (IProject project : this.projects) {
                try {
                    project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    Logger.log((Exception)((Object)e));
                }
            }
            return Status.OK_STATUS;
        }
    }
}

