/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.core;

import com.espressif.idf.core.logging.Logger;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ZipUtility {
    public static final int _bufferSize = 1024000;

    public boolean decompress(File zipPath, File parentDirectory) {
        return this.decompress(zipPath, parentDirectory, 1024000);
    }

    public boolean decompress(File path, File parentDirectory, int bufferSize) {
        try {
            ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(path));
            return this.decompress(zipInputStream, parentDirectory, bufferSize);
        }
        catch (FileNotFoundException e) {
            Logger.log(e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean decompress(ZipInputStream zipInputStream, File parentDirectory, int bufferSize) {
        try {
            try {
                ZipEntry zipEntry = null;
                while (true) {
                    if ((zipEntry = zipInputStream.getNextEntry()) == null) {
                        return true;
                    }
                    if (zipEntry.isDirectory()) {
                        File directory = new File(parentDirectory, zipEntry.getName());
                        if (!directory.mkdirs()) {
                            zipInputStream.closeEntry();
                            return false;
                        }
                    } else {
                        File file = new File(parentDirectory, zipEntry.getName());
                        File directory = new File(file.getParent());
                        if (!directory.exists() && !directory.mkdirs()) {
                            zipInputStream.closeEntry();
                            return false;
                        }
                        FileOutputStream fileOutputStream = new FileOutputStream(file);
                        byte[] buf = new byte[bufferSize];
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(zipInputStream);
                        while (true) {
                            int count;
                            if (-1 == (count = bufferedInputStream.read(buf, 0, bufferSize))) {
                                fileOutputStream.close();
                                break;
                            }
                            fileOutputStream.write(buf, 0, count);
                        }
                    }
                    zipInputStream.closeEntry();
                }
            }
            finally {
                zipInputStream.close();
            }
        }
        catch (IOException e) {
            Logger.log(e);
            return false;
        }
    }
}

