/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.packs.core.data.xcdl;

import java.util.List;
import org.eclipse.embedcdt.core.Xml;
import org.eclipse.embedcdt.internal.packs.core.Activator;
import org.eclipse.embedcdt.packs.core.IConsoleStream;
import org.eclipse.embedcdt.packs.core.tree.Node;
import org.eclipse.embedcdt.packs.core.tree.PackNode;
import org.eclipse.embedcdt.packs.core.xml.DocumentParseException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ContentParser1 {
    private IConsoleStream fOut = Activator.getInstance().getConsoleOutput();
    private Document fDocument;

    public ContentParser1(Document document) {
        this.fDocument = document;
    }

    public Node parse() throws DocumentParseException {
        Node node = new Node("root");
        Element firstElement = this.fDocument.getDocumentElement();
        String firstElementName = firstElement.getNodeName();
        if (!"root".equals(firstElementName)) {
            throw new DocumentParseException("Missing <root>, <" + firstElementName + "> encountered");
        }
        String schemaVersion = firstElement.getAttribute("version").trim();
        if (!"1.1".equals(schemaVersion)) {
            throw new DocumentParseException("Unrecognised schema version " + schemaVersion);
        }
        List childElements = Xml.getChildrenElementsList((Element)firstElement);
        for (Element childElement : childElements) {
            String elementName = childElement.getNodeName();
            if ("repository".equals(elementName)) {
                this.processRepository(childElement, node);
                continue;
            }
            this.notProcessed(childElement);
        }
        return node;
    }

    private String getNameAttribute(Element el) {
        return el.getAttribute("name").trim();
    }

    private void notProcessed(Element el) {
        Element parentElement = Xml.getParentElement((Element)el);
        this.fOut.print("Element <" + el.getNodeName() + "> ");
        if (parentElement != null) {
            this.fOut.print(" below <" + parentElement.getNodeName() + "> ");
        }
        this.fOut.println("not processed.");
    }

    private void processDescription(Element el, Node node) {
        String description = Xml.getElementContent((Element)el);
        node.setDescription(description);
    }

    private void processRepository(Element el, Node parent) {
        Node node = Node.addNewChild(parent, "repository");
        String name = this.getNameAttribute(el);
        node.setName(name);
        List childElements = Xml.getChildrenElementsList((Element)el);
        for (Element childElement : childElements) {
            String elementName = childElement.getNodeName();
            if ("packages".equals(elementName)) {
                this.processPackages(childElement, node);
                continue;
            }
            this.processDefaults(childElement, node);
        }
    }

    private void processProperties(Element el, Node node) {
        List childElements = Xml.getChildrenElementsList((Element)el);
        for (Element childElement : childElements) {
            String elementName = childElement.getNodeName();
            if ("property".equals(elementName)) {
                this.processProperty(childElement, node);
                continue;
            }
            this.notProcessed(childElement);
        }
    }

    private void processProperty(Element el, Node node) {
        String name = this.getNameAttribute(el);
        String value = Xml.getElementContent((Element)el);
        node.putProperty(name, value);
    }

    private void processPackages(Element el, Node node) {
        List childElements = Xml.getChildrenElementsList((Element)el);
        for (Element childElement : childElements) {
            String elementName = childElement.getNodeName();
            if ("package".equals(elementName)) {
                this.processPackage(childElement, node);
                continue;
            }
            this.notProcessed(childElement);
        }
    }

    private void processPackage(Element el, Node parent) {
        PackNode node = PackNode.addNewChild(parent, "package");
        String name = this.getNameAttribute(el);
        node.setName(name);
        List childElements = Xml.getChildrenElementsList((Element)el);
        for (Element childElement : childElements) {
            String elementName = childElement.getNodeName();
            if ("versions".equals(elementName)) {
                this.processVersions(childElement, node);
                continue;
            }
            this.processDefaults(childElement, node);
        }
    }

    private void processVersions(Element el, Node node) {
        List childElements = Xml.getChildrenElementsList((Element)el);
        for (Element childElement : childElements) {
            String elementName = childElement.getNodeName();
            if ("version".equals(elementName)) {
                this.processVersion(childElement, node);
                continue;
            }
            this.notProcessed(childElement);
        }
    }

    private void processVersion(Element el, Node parent) {
        PackNode node = PackNode.addNewChild(parent, "version");
        String name = this.getNameAttribute(el);
        node.setName(name);
        List childElements = Xml.getChildrenElementsList((Element)el);
        for (Element childElement : childElements) {
            String elementName = childElement.getNodeName();
            if ("outline".equals(elementName)) {
                this.processOutline(childElement, node);
                continue;
            }
            if ("external".equals(elementName)) {
                this.processExternal(childElement, node);
                continue;
            }
            this.processDefaults(childElement, node);
        }
    }

    private void processOutline(Element el, Node parent) {
        Node node = Node.addNewChild(parent, "outline");
        String name = this.getNameAttribute(el);
        node.setName(name);
        List childElements = Xml.getChildrenElementsList((Element)el);
        for (Element childElement : childElements) {
            String elementName = childElement.getNodeName();
            if ("keyword".equals(elementName)) {
                this.processKeyword(childElement, node);
                continue;
            }
            if ("devicefamily".equals(elementName)) {
                this.processLeaf(childElement, node, "family");
                continue;
            }
            if ("board".equals(elementName)) {
                this.processLeaf(childElement, node, "board");
                continue;
            }
            if ("component".equals(elementName)) {
                this.processLeaf(childElement, node, "component");
                continue;
            }
            if ("bundle".equals(elementName)) {
                this.processLeaf(childElement, node, "bundle");
                continue;
            }
            if ("example".equals(elementName)) {
                this.processLeaf(childElement, node, "example");
                continue;
            }
            this.notProcessed(childElement);
        }
    }

    private void processExternal(Element el, Node parent) {
        Node node = Node.addNewChild(parent, "external");
        String name = this.getNameAttribute(el);
        node.setName(name);
        List childElements = Xml.getChildrenElementsList((Element)el);
        for (Element childElement : childElements) {
            String elementName = childElement.getNodeName();
            if ("devicefamily".equals(elementName)) {
                this.processLeaf(childElement, node, "family");
                continue;
            }
            if ("board".equals(elementName)) {
                this.processLeaf(childElement, node, "board");
                continue;
            }
            this.notProcessed(childElement);
        }
    }

    private void processKeyword(Element el, Node parent) {
        Node node = Node.addNewChild(parent, "keyword");
        String name = this.getNameAttribute(el);
        node.setName(name);
        List childElements = Xml.getChildrenElementsList((Element)el);
        for (Element childElement : childElements) {
            this.notProcessed(childElement);
        }
    }

    private void processLeaf(Element el, Node parent, String type) {
        Node node = Node.addNewChild(parent, type);
        String name = this.getNameAttribute(el);
        node.setName(name);
        List childElements = Xml.getChildrenElementsList((Element)el);
        for (Element childElement : childElements) {
            this.processDefaults(childElement, node);
        }
    }

    private void processDefaults(Element el, Node parent) {
        String elementName = el.getNodeName();
        if ("description".equals(elementName)) {
            this.processDescription(el, parent);
        } else if ("properties".equals(elementName)) {
            this.processProperties(el, parent);
        } else if ("property".equals(elementName)) {
            this.processProperty(el, parent);
        } else {
            this.notProcessed(el);
        }
    }
}

