/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.launch.serial.util;

import com.espressif.idf.core.IDFCorePlugin;
import com.espressif.idf.core.IDFDynamicVariables;
import com.espressif.idf.core.IDFEnvironmentVariables;
import com.espressif.idf.core.configparser.EspConfigParser;
import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.util.IDFUtil;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.embedcdt.core.StringUtils;
import org.eclipse.launchbar.core.ILaunchBarManager;

public class ESPFlashUtil {
    private static final int OPENOCD_JTAG_FLASH_SUPPORT_V = 20201125;
    public static final String VERSION_PATTERN = "(v.\\S+)";
    public static final String SERIAL_PORT = "${serial_port}";
    private static final String DEFAULT_ARGUMENT_PREFIX = "${openocd_path}/${openocd_executable} ";

    private ESPFlashUtil() {
    }

    public static String getEspFlashCommand(String serialPort) {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(IDFUtil.getIDFPythonScriptFile().getAbsolutePath());
        commands.add("-p");
        commands.add(serialPort);
        commands.add("flash");
        return String.join((CharSequence)" ", commands);
    }

    public static String getParseableEspFlashCommand(String serialPort) {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(VariablesPlugin.getDefault().getStringVariableManager().generateVariableExpression(IDFDynamicVariables.IDF_PY.name(), null));
        commands.add("-B");
        commands.add(VariablesPlugin.getDefault().getStringVariableManager().generateVariableExpression(IDFDynamicVariables.BUILD_DIR.name(), null));
        commands.add("-p");
        commands.add(serialPort);
        commands.add("flash");
        return String.join((CharSequence)" ", commands);
    }

    public static boolean checkIfJtagIsAvailable() {
        EspConfigParser parser = new EspConfigParser();
        String openOCDPath = new IDFEnvironmentVariables().getEnvValue("OPENOCD_SCRIPTS");
        if (openOCDPath.isEmpty() && !parser.hasBoardConfigJson()) {
            return false;
        }
        String openOcdVersionOutput = IDFUtil.getOpenocdVersion();
        Pattern pattern = Pattern.compile(VERSION_PATTERN);
        Matcher matcher = pattern.matcher(openOcdVersionOutput);
        return !matcher.find() || Integer.parseInt(matcher.group(1).split("-")[2]) >= 20201125;
    }

    public static String getEspJtagFlashCommand(ILaunchConfiguration configuration) {
        String espFlashCommand = "-c program_esp_bins <path-to-build-dir> flasher_args.json verify reset";
        try {
            String buildPath = configuration.getMappedResources()[0].getProject().getPersistentProperty(new QualifiedName("com.espressif.idf.core", "idf.buildDirectory.property"));
            buildPath = new Path(buildPath).toString();
            buildPath = buildPath.isBlank() ? configuration.getMappedResources()[0].getProject().getFolder("build").getLocationURI().getPath() : buildPath;
            char a = buildPath.charAt(2);
            if (a == ':') {
                buildPath = buildPath.substring(1);
            }
            espFlashCommand = espFlashCommand.replace("<path-to-build-dir>", buildPath.replace(" ", "\\ "));
        }
        catch (CoreException e) {
            Logger.log((Exception)((Object)e));
        }
        return espFlashCommand;
    }

    public static void flashOverJtag(ILaunchConfiguration configuration, ILaunch launch) throws CoreException {
        ArrayList<CallSite> commands = new ArrayList<CallSite>();
        String arguments = configuration.getAttribute("com.espressif.idf.debug.gdbjtag.openocd.jtagFlashArguments", "");
        arguments = ESPFlashUtil.addPrefixIfNeeded(arguments);
        arguments = ESPFlashUtil.getVariablesValueFromExpression(arguments);
        commands.addAll(StringUtils.splitCommandLineOptions((String)arguments));
        String flashCommand = ESPFlashUtil.getEspJtagFlashCommand(configuration) + " exit";
        commands.add((CallSite)((Object)flashCommand));
        try {
            Process p = Runtime.getRuntime().exec(commands.toArray(new String[0]));
            DebugPlugin.newProcess((ILaunch)launch, (Process)p, (String)String.join((CharSequence)" ", commands));
        }
        catch (IOException e) {
            Logger.log((Exception)e);
        }
    }

    public static boolean isJtag() {
        try {
            ILaunchConfiguration configuration = ((ILaunchBarManager)IDFCorePlugin.getService(ILaunchBarManager.class)).getActiveLaunchConfiguration();
            return configuration.getAttribute("FLASH_OVER_JTAG", false);
        }
        catch (CoreException e) {
            Logger.log((Exception)((Object)e));
            return false;
        }
    }

    private static String getVariablesValueFromExpression(String expression) throws CoreException {
        IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
        return manager.performStringSubstitution(expression);
    }

    private static String addPrefixIfNeeded(String arguments) {
        if (((String)arguments).indexOf("-s") == 0) {
            arguments = DEFAULT_ARGUMENT_PREFIX + (String)arguments;
        }
        return arguments;
    }
}

