/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.update;

import com.espressif.idf.core.IDFCorePlugin;
import com.espressif.idf.core.IDFEnvironmentVariables;
import com.espressif.idf.core.ProcessBuilderFactory;
import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.toolchain.ESPToolChainManager;
import com.espressif.idf.core.util.IDFUtil;
import com.espressif.idf.ui.update.AbstractToolsHandler;
import com.espressif.idf.ui.update.ExportIDFTools;
import com.espressif.idf.ui.update.Messages;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.console.MessageConsoleStream;
import org.osgi.service.prefs.BackingStoreException;

public class InstallToolsHandler
extends AbstractToolsHandler {
    public static final String INSTALL_TOOLS_FLAG = "INSTALL_TOOLS_FLAG";

    @Override
    protected void execute() {
        Job installToolsJob = new Job(Messages.InstallToolsHandler_InstallingToolsMsg){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(Messages.InstallToolsHandler_ItWilltakeTimeMsg, 5);
                monitor.worked(1);
                IStatus status = InstallToolsHandler.this.handleToolsInstall();
                if (status.getSeverity() == 4) {
                    return status;
                }
                monitor.worked(1);
                monitor.setTaskName(Messages.InstallToolsHandler_InstallingPythonMsg);
                status = InstallToolsHandler.this.handleToolsInstallPython(InstallToolsHandler.this.console);
                if (status.getSeverity() == 4) {
                    return status;
                }
                monitor.worked(1);
                monitor.setTaskName(Messages.InstallToolsHandler_ExportingPathsMsg);
                status = new ExportIDFTools().runToolsExportAndProcessOutput(InstallToolsHandler.this.pythonExecutablenPath, InstallToolsHandler.this.gitExecutablePath, InstallToolsHandler.this.console, InstallToolsHandler.this.errorConsoleStream);
                if (status.getSeverity() == 4) {
                    return status;
                }
                monitor.worked(1);
                InstallToolsHandler.this.console.println(Messages.InstallToolsHandler_ConfiguredBuildEnvVarMsg);
                monitor.setTaskName(Messages.InstallToolsHandler_AutoConfigureToolchain);
                new ESPToolChainManager().configureToolChain();
                monitor.worked(1);
                InstallToolsHandler.this.configEnv();
                monitor.setTaskName(Messages.InstallToolsHandler_InstallingWebscoketMsg);
                InstallToolsHandler.this.handleWebSocketClientInstall();
                monitor.worked(1);
                InstallToolsHandler.this.copyOpenOcdRules();
                InstallToolsHandler.this.console.println(Messages.InstallToolsHandler_ConfiguredCMakeMsg);
                InstallToolsHandler.this.console.println(Messages.InstallToolsHandler_ToolsCompleted);
                return Status.OK_STATUS;
            }
        };
        IEclipsePreferences scopedPreferenceStore = InstanceScope.INSTANCE.getNode("com.espressif.idf.ui");
        scopedPreferenceStore.putBoolean(INSTALL_TOOLS_FLAG, true);
        try {
            scopedPreferenceStore.flush();
        }
        catch (BackingStoreException e) {
            Logger.log((Exception)((Object)e));
        }
        installToolsJob.addJobChangeListener((IJobChangeListener)new ToolInstallListener());
        installToolsJob.schedule();
    }

    protected void configEnv() {
        IDFEnvironmentVariables idfEnvMgr = new IDFEnvironmentVariables();
        idfEnvMgr.addEnvVariable("IDF_COMPONENT_MANAGER", "1");
        idfEnvMgr.addEnvVariable("IDF_MAINTAINER", "1");
    }

    private void copyOpenOcdRules() {
        if (Platform.getOS().equals("linux") && !IDFUtil.getOpenOCDLocation().equalsIgnoreCase("")) {
            this.console.println(Messages.InstallToolsHandler_CopyingOpenOCDRules);
            StringBuilder pathToRules = new StringBuilder();
            pathToRules.append(IDFUtil.getOpenOCDLocation());
            pathToRules.append("/../share/openocd/contrib/60-openocd.rules");
            File rulesFile = new File(pathToRules.toString());
            if (rulesFile.exists()) {
                final java.nio.file.Path source = Paths.get(pathToRules.toString(), new String[0]);
                final java.nio.file.Path target = Paths.get("/etc/udev/rules.d/60-openocd.rules", new String[0]);
                this.console.println(String.format(Messages.InstallToolsHandler_OpenOCDRulesCopyPaths, source.toString(), target.toString()));
                Display.getDefault().syncExec(new Runnable(){

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    @Override
                    public void run() {
                        try {
                            if (target.toFile().exists()) {
                                MessageBox messageBox = new MessageBox(Display.getDefault().getActiveShell(), 200);
                                messageBox.setText(Messages.InstallToolsHandler_OpenOCDRulesCopyWarning);
                                messageBox.setMessage(Messages.InstallToolsHandler_OpenOCDRulesCopyWarningMessage);
                                int response = messageBox.open();
                                if (response != 64) {
                                    InstallToolsHandler.this.console.println(Messages.InstallToolsHandler_OpenOCDRulesNotCopied);
                                    return;
                                }
                                Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
                            } else {
                                Files.copy(source, target, new CopyOption[0]);
                            }
                            InstallToolsHandler.this.console.println(Messages.InstallToolsHandler_OpenOCDRulesCopied);
                            return;
                        }
                        catch (IOException e) {
                            Logger.log((Exception)e);
                            InstallToolsHandler.this.errorConsoleStream.println(Messages.InstallToolsHandler_OpenOCDRulesCopyError);
                        }
                    }
                });
            }
        }
    }

    protected IStatus handleToolsInstall() {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("install");
        arguments.add("all");
        this.console.println(Messages.InstallToolsHandler_InstallingToolsMsg);
        this.console.println(Messages.InstallToolsHandler_ItWilltakeTimeMsg);
        return this.runCommand(arguments, this.console);
    }

    protected IStatus handleToolsInstallPython(MessageConsoleStream console) {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("install-python-env");
        return this.runCommand(arguments, console);
    }

    public IStatus handleWebSocketClientInstall() {
        String websocketClient = "websocket-client";
        ArrayList<String> arguments = new ArrayList<String>();
        String pythonEnvPath = IDFUtil.getIDFPythonEnvPath();
        if (pythonEnvPath == null || !new File(pythonEnvPath).exists()) {
            this.console.println(String.format("%s executable not found. Unable to run `%s -m pip install websocket-client`", "python", "python"));
            return IDFCorePlugin.errorStatus((String)String.format("%s executable not found. Unable to run `%s -m pip install websocket-client`", "python", "python"), null);
        }
        arguments.add(pythonEnvPath);
        arguments.add("-m");
        arguments.add("pip");
        arguments.add("list");
        ProcessBuilderFactory processRunner = new ProcessBuilderFactory();
        try {
            String cmdMsg = "Executing " + this.getCommandString(arguments);
            if (this.console != null) {
                this.console.println(cmdMsg);
            }
            Logger.log((String)cmdMsg);
            HashMap environment = new HashMap(IDFUtil.getSystemEnv());
            Logger.log((String)((Object)environment).toString());
            IStatus status = processRunner.runInBackground(arguments, (IPath)Path.ROOT, environment);
            if (status == null) {
                Logger.log((Plugin)IDFCorePlugin.getPlugin(), (IStatus)IDFCorePlugin.errorStatus((String)"Unable to get the process status.", null));
                if (this.errorConsoleStream != null) {
                    this.errorConsoleStream.println("Unable to get the process status.");
                }
                return IDFCorePlugin.errorStatus((String)"Unable to get the process status.", null);
            }
            String cmdOutput = status.getMessage();
            if (cmdOutput.contains(websocketClient)) {
                return IDFCorePlugin.okStatus((String)"websocket-client already installed", null);
            }
            arguments.remove(arguments.size() - 1);
            arguments.add("install");
            arguments.add(websocketClient);
            status = processRunner.runInBackground(arguments, (IPath)Path.ROOT, environment);
            if (status == null) {
                Logger.log((Plugin)IDFCorePlugin.getPlugin(), (IStatus)IDFCorePlugin.errorStatus((String)"Unable to get the process status.", null));
                if (this.errorConsoleStream != null) {
                    this.errorConsoleStream.println("Unable to get the process status.");
                }
                return IDFCorePlugin.errorStatus((String)"Unable to get the process status.", null);
            }
            if (this.console != null) {
                this.console.println(status.getMessage());
            }
            return status;
        }
        catch (Exception e1) {
            Logger.log((Plugin)IDFCorePlugin.getPlugin(), (Exception)e1);
            if (this.errorConsoleStream != null) {
                this.errorConsoleStream.println(e1.getLocalizedMessage());
            }
            return IDFCorePlugin.errorStatus((String)e1.getLocalizedMessage(), (Exception)e1);
        }
    }

    private class ToolInstallListener
    implements IJobChangeListener {
        Map<String, String> existingVarMap;

        private ToolInstallListener() {
        }

        public void aboutToRun(IJobChangeEvent event) {
            new IDFEnvironmentVariables().removeEnvVariable("ESP_IDF_VERSION");
            this.existingVarMap = this.loadExistingVars();
        }

        private Map<String, String> loadExistingVars() {
            IDFEnvironmentVariables idfEnvironmentVariables = new IDFEnvironmentVariables();
            HashMap<String, String> existingVarMap = new HashMap<String, String>();
            existingVarMap.put("IDF_COMPONENT_MANAGER", idfEnvironmentVariables.getEnvValue("IDF_COMPONENT_MANAGER"));
            existingVarMap.put("IDF_PATH", idfEnvironmentVariables.getEnvValue("IDF_PATH"));
            existingVarMap.put("IDF_PYTHON_ENV_PATH", idfEnvironmentVariables.getEnvValue("IDF_PYTHON_ENV_PATH"));
            existingVarMap.put("OPENOCD_SCRIPTS", idfEnvironmentVariables.getEnvValue("OPENOCD_SCRIPTS"));
            existingVarMap.put("PATH", idfEnvironmentVariables.getEnvValue("PATH"));
            return existingVarMap;
        }

        public void awake(IJobChangeEvent event) {
        }

        public void done(IJobChangeEvent event) {
            if (event.getResult().getSeverity() == 4) {
                this.restoreOldVars();
            } else {
                IDFUtil.updateEspressifPrefPageOpenocdPath();
            }
        }

        private void restoreOldVars() {
            IDFEnvironmentVariables idfEnvironmentVariables = new IDFEnvironmentVariables();
            for (Map.Entry<String, String> varsEntry : this.existingVarMap.entrySet()) {
                idfEnvironmentVariables.addEnvVariable(varsEntry.getKey(), varsEntry.getValue());
            }
        }

        public void running(IJobChangeEvent event) {
        }

        public void scheduled(IJobChangeEvent event) {
        }

        public void sleeping(IJobChangeEvent event) {
        }
    }
}

