/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.update;

import com.espressif.idf.core.IDFCorePlugin;
import com.espressif.idf.core.IDFEnvironmentVariables;
import com.espressif.idf.core.ProcessBuilderFactory;
import com.espressif.idf.core.SystemExecutableFinder;
import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.util.IDFUtil;
import com.espressif.idf.core.util.StringUtil;
import com.espressif.idf.ui.IDFConsole;
import com.espressif.idf.ui.InputStreamConsoleThread;
import com.espressif.idf.ui.update.DirectorySelectionDialog;
import com.espressif.idf.ui.update.Messages;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.MessageConsoleStream;

public abstract class AbstractToolsHandler
extends AbstractHandler {
    private IDFConsole idfConsole;
    protected MessageConsoleStream console;
    protected MessageConsoleStream errorConsoleStream;
    protected String idfPath;
    protected String pythonExecutablenPath;
    protected String gitExecutablePath;
    private Map<String, String> pythonVersions;
    private String commandId;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.activateIDFConsoleView();
        String commmand_id = this.commandId;
        if (event != null) {
            commmand_id = event.getCommand().getId();
        }
        Logger.log((String)("Command id:" + commmand_id));
        this.idfPath = IDFUtil.getIDFPath();
        Logger.log((String)("IDF_PATH :" + this.idfPath));
        IPath gitPath = new SystemExecutableFinder().find("git");
        Logger.log((String)("GIT path:" + String.valueOf(gitPath)));
        if (gitPath != null) {
            this.gitExecutablePath = gitPath.toOSString();
        }
        this.pythonExecutablenPath = this.getPythonExecutablePath();
        DirectorySelectionDialog dir = new DirectorySelectionDialog(Display.getDefault().getActiveShell(), commmand_id, this.pythonExecutablenPath, this.pythonVersions, this.idfPath, this.gitExecutablePath);
        if (dir.open() != 0) {
            return null;
        }
        this.idfPath = dir.getIDFDirectory();
        this.gitExecutablePath = dir.getGitExecutable();
        this.pythonExecutablenPath = dir.getPythonExecutable();
        if (StringUtil.isEmpty((String)this.pythonExecutablenPath) || StringUtil.isEmpty((String)this.gitExecutablePath) || StringUtil.isEmpty((String)this.idfPath)) {
            this.errorConsoleStream.print("One or more paths are empty! Make sure you provide IDF_PATH, git and python executables");
            return null;
        }
        IDFEnvironmentVariables idfEnvMgr = new IDFEnvironmentVariables();
        idfEnvMgr.addEnvVariable("IDF_PATH", this.idfPath);
        this.execute();
        return null;
    }

    protected void activateIDFConsoleView() {
        this.idfConsole = new IDFConsole();
        this.console = this.idfConsole.getConsoleStream(Messages.IDFToolsHandler_ToolsManagerConsole, null, false, true);
        this.errorConsoleStream = this.idfConsole.getConsoleStream(Messages.IDFToolsHandler_ToolsManagerConsole, null, true, true);
    }

    protected String getPythonExecutablePath() {
        this.pythonExecutablenPath = IDFUtil.getIDFPythonEnvPath();
        return this.pythonExecutablenPath;
    }

    protected abstract void execute();

    protected IStatus runCommand(List<String> arguments, MessageConsoleStream console) {
        ProcessBuilderFactory processRunner = new ProcessBuilderFactory();
        try {
            Process process;
            IStatus status;
            arguments.add(0, this.pythonExecutablenPath);
            arguments.add(1, IDFUtil.getIDFToolsScriptFile().getAbsolutePath());
            String cmdMsg = Messages.AbstractToolsHandler_ExecutingMsg + " " + this.getCommandString(arguments);
            console.println(cmdMsg);
            Logger.log((String)cmdMsg);
            HashMap<String, String> environment = new HashMap<String, String>(IDFUtil.getSystemEnv());
            Logger.log((String)((Object)environment).toString());
            environment.put("PYTHONUNBUFFERED", "1");
            environment.put("IDF_GITHUB_ASSETS", Platform.getPreferencesService().getString("com.espressif.idf.core", "IDF_GITHUB_ASSETS", "dl.espressif.com/github_assets", null));
            environment.put("PIP_EXTRA_INDEX_URL", Platform.getPreferencesService().getString("com.espressif.idf.core", "PIP_EXTRA_INDEX_URL", "https://dl.espressif.com/pypi", null));
            if (this.gitExecutablePath != null) {
                this.addGitToEnvironment(environment, this.gitExecutablePath);
            }
            if ((status = this.processData(process = processRunner.run(arguments, (IPath)Path.ROOT, environment))).getSeverity() == 4) {
                this.errorConsoleStream.print(status.getException() != null ? status.getException().getMessage() : status.getMessage());
            }
            console.println(status.getMessage());
            console.println();
            return IDFCorePlugin.okStatus((String)status.getMessage(), null);
        }
        catch (Exception e1) {
            Logger.log((Plugin)IDFCorePlugin.getPlugin(), (Exception)e1);
            return IDFCorePlugin.errorStatus((String)e1.getMessage(), (Exception)e1);
        }
    }

    private IStatus processData(Process process) {
        InputStream inputStream = process.getInputStream();
        InputStream errorStream = process.getErrorStream();
        InputStreamConsoleThread readerThread = null;
        Thread errorThread = null;
        try {
            readerThread = new InputStreamConsoleThread(inputStream, this.console);
            errorThread = new InputStreamConsoleThread(errorStream, this.console);
            readerThread.start();
            errorThread.start();
            int exitValue = process.waitFor();
            readerThread.interrupt();
            errorThread.interrupt();
            readerThread.join();
            errorThread.join();
            if (exitValue == 0) {
                return Status.OK_STATUS;
            }
            return new Status(4, "com.espressif.idf.core", "Error");
        }
        catch (InterruptedException e) {
            try {
                if (readerThread != null) {
                    readerThread.interrupt();
                }
                if (errorThread != null) {
                    errorThread.interrupt();
                }
                if (readerThread != null) {
                    readerThread.join();
                }
                if (errorThread != null) {
                    errorThread.join();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return new Status(4, "com.espressif.idf.core", e.getMessage(), (Throwable)e);
        }
    }

    protected String runCommand(List<String> arguments, Path workDir, Map<String, String> env) {
        String exportCmdOp = "";
        ProcessBuilderFactory processRunner = new ProcessBuilderFactory();
        try {
            IStatus status = processRunner.runInBackground(arguments, (IPath)workDir, env);
            if (status == null) {
                IStatus errorStatus = IDFCorePlugin.errorStatus((String)"Status can't be null", null);
                Logger.log((Plugin)IDFCorePlugin.getPlugin(), (IStatus)errorStatus);
                return errorStatus.getMessage();
            }
            exportCmdOp = status.getMessage();
            Logger.log((String)exportCmdOp);
        }
        catch (Exception e1) {
            Logger.log((Plugin)IDFCorePlugin.getPlugin(), (Exception)e1);
        }
        return exportCmdOp;
    }

    protected void addGitToEnvironment(Map<String, String> environment, String gitExecutablePath) {
        Path gitPath = new Path(gitExecutablePath);
        if (gitPath.toFile().exists()) {
            String gitDir = gitPath.removeLastSegments(1).toOSString();
            String path1 = environment.get("PATH");
            String path2 = environment.get("Path");
            if (!StringUtil.isEmpty((String)path1) && !path1.contains(gitDir)) {
                path1 = gitDir.concat(";").concat(path1);
                environment.put("PATH", path1);
            } else if (!StringUtil.isEmpty((String)path2) && !path2.contains(gitDir)) {
                path2 = gitDir.concat(";").concat(path2);
                environment.put("Path", path2);
            }
        }
    }

    protected void runCommandInNewJob(String jobName, final List<String> commandArgs, final Path pathToProject, final Map<String, String> envMap) {
        Job job = new Job(jobName){

            protected IStatus run(IProgressMonitor monitor) {
                AbstractToolsHandler.this.console.println(String.format(Messages.AbstractToolsHandler_RunningCommandFormatString, String.join((CharSequence)" ", commandArgs)));
                AbstractToolsHandler.this.console.println(AbstractToolsHandler.this.runCommand(commandArgs, pathToProject, envMap));
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    protected String getCommandString(List<String> arguments) {
        StringBuilder builder = new StringBuilder();
        arguments.forEach(entry -> {
            StringBuilder stringBuilder2 = builder.append(entry + " ");
        });
        return builder.toString().trim();
    }

    public void setCommandId(String commandId) {
        this.commandId = commandId;
    }
}

