/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.templates;

import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.toolchain.IDFTargets;
import com.espressif.idf.core.toolchain.IDFTargetsReader;
import com.espressif.idf.core.util.IDFUtil;
import com.espressif.idf.ui.templates.AbstractTemplatesSelectionPage;
import com.espressif.idf.ui.templates.ITemplateNode;
import com.espressif.idf.ui.templates.Messages;
import com.espressif.idf.ui.templates.TemplatesManager;
import java.io.IOException;
import java.net.URI;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.dialogs.ProjectContentsLocationArea;

public class NewProjectCreationWizardPage
extends AbstractTemplatesSelectionPage {
    private Text projectNameField;
    private ITemplateNode fInitialTemplateId;
    private ProjectContentsLocationArea locationArea;
    private Combo targetCombo;
    private String initialProjectFieldValue;
    private Button runIdfReconfigureCheckBoxButton;

    public NewProjectCreationWizardPage(ITemplateNode templateNodes, String message) {
        super(templateNodes, message);
        this.setTitle(Messages.NewProjectWizardPage_Header);
        this.setDescription(Messages.NewProjectWizardPage_DescriptionString);
    }

    @Override
    public void createAbove(Composite container, int span) {
        this.createProjectNameGroup(container);
        this.createProjectTargetSelection(container);
    }

    private void createProjectTargetSelection(Composite container) {
        Composite mainComposite = new Composite(container, 0);
        mainComposite.setLayout((Layout)new GridLayout(2, false));
        mainComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        Label label = new Label(mainComposite, 0);
        label.setText(Messages.NewProjectTargetSelection_Label);
        IDFTargets idfTargets = IDFTargetsReader.readTargetsFromEspIdf((String)IDFUtil.getIDFPath());
        this.targetCombo = new Combo(mainComposite, 8);
        this.targetCombo.setItems((String[])idfTargets.getAllTargetNames().toArray(String[]::new));
        this.targetCombo.select(0);
        this.targetCombo.setToolTipText(Messages.NewProjectTargetSelection_Tooltip);
    }

    private void createProjectNameGroup(Composite container) {
        Composite mainComposite = new Composite(container, 0);
        mainComposite.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData(4, 4, true, false);
        gridData.horizontalSpan = 20;
        gridData.verticalSpan = 5;
        mainComposite.setLayoutData((Object)gridData);
        Composite projectNameGroup = new Composite(mainComposite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        projectNameGroup.setLayout((Layout)layout);
        projectNameGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        Label projectNameLabel = new Label(projectNameGroup, 0);
        projectNameLabel.setText(IDEWorkbenchMessages.WizardNewProjectCreationPage_nameLabel);
        this.projectNameField = new Text(projectNameGroup, 2048);
        this.projectNameField.setLayoutData((Object)new GridData(4, 4, true, false));
        this.projectNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (NewProjectCreationWizardPage.this.getErrorMessage() == null || NewProjectCreationWizardPage.this.getErrorMessage().isEmpty()) {
                    NewProjectCreationWizardPage.this.setPageComplete(true);
                } else {
                    NewProjectCreationWizardPage.this.setPageComplete(false);
                }
                boolean valid = NewProjectCreationWizardPage.this.validatePage();
                NewProjectCreationWizardPage.this.setPageComplete(valid);
            }
        });
        this.locationArea = new ProjectContentsLocationArea(this.getErrorReporter(), mainComposite);
        if (this.initialProjectFieldValue != null) {
            this.locationArea.updateProjectName(this.initialProjectFieldValue);
        }
        this.runIdfReconfigureCheckBoxButton = new Button(projectNameGroup, 131104);
        GridData buttonData = new GridData();
        buttonData.horizontalSpan = 4;
        buttonData.verticalIndent = 4;
        this.runIdfReconfigureCheckBoxButton.setLayoutData((Object)buttonData);
        this.runIdfReconfigureCheckBoxButton.setSelection(true);
        this.runIdfReconfigureCheckBoxButton.setText(Messages.RunIdfCommandButtonTxt);
    }

    private ProjectContentsLocationArea.IErrorMessageReporter getErrorReporter() {
        return (errorMessage, infoOnly) -> {
            boolean valid;
            if (infoOnly) {
                this.setMessage(errorMessage, 1);
                this.setErrorMessage(null);
            } else {
                this.setErrorMessage(errorMessage);
            }
            boolean bl = valid = errorMessage == null;
            if (valid) {
                valid = this.validatePage();
            }
            this.setPageComplete(valid);
        };
    }

    public boolean useDefaults() {
        return this.locationArea.isDefault();
    }

    public boolean isRunIdfReconfigureEnabled() {
        return this.runIdfReconfigureCheckBoxButton.getSelection();
    }

    public IPath getLocationPath() {
        return new Path(this.locationArea.getProjectLocation());
    }

    public URI getLocationURI() {
        return this.locationArea.getProjectLocationURI();
    }

    public void setInitialProjectName(String name) {
        if (name == null) {
            this.initialProjectFieldValue = null;
        } else {
            this.initialProjectFieldValue = name.trim();
            if (this.locationArea != null) {
                this.locationArea.updateProjectName(name.trim());
            }
        }
    }

    void setLocationForSelection() {
        this.locationArea.updateProjectName(this.getProjectNameFieldValue());
    }

    private String getProjectNameFieldValue() {
        if (this.projectNameField == null) {
            return "";
        }
        return this.projectNameField.getText().trim();
    }

    @Override
    protected boolean validatePage() {
        IWorkspace workspace = IDEWorkbenchPlugin.getPluginWorkspace();
        String worspaceLocation = workspace.getRoot().getLocation().toOSString();
        if (!this.useDefaults()) {
            worspaceLocation = this.locationArea.getProjectLocation();
        }
        if (!IDFUtil.checkIfIdfSupportsSpaces() && worspaceLocation.contains(" ")) {
            this.setErrorMessage(com.espressif.idf.ui.wizard.Messages.WizardNewProjectCreationPage_WorkspaceLocCantIncludeSpaceErr);
            return false;
        }
        String projectFieldContents = this.getProjectNameFieldValue();
        if (projectFieldContents.equals("")) {
            this.setErrorMessage(null);
            this.setMessage(IDEWorkbenchMessages.WizardNewProjectCreationPage_projectNameEmpty);
            return false;
        }
        if (!IDFUtil.checkIfIdfSupportsSpaces() && projectFieldContents.contains(" ")) {
            this.setErrorMessage(com.espressif.idf.ui.wizard.Messages.WizardNewProjectCreationPage_NameCantIncludeSpaceErr);
            return false;
        }
        IStatus nameStatus = workspace.validateName(projectFieldContents, 4);
        if (!nameStatus.isOK()) {
            this.setErrorMessage(nameStatus.getMessage());
            return false;
        }
        IProject handle = this.getProjectHandle();
        if (handle.exists()) {
            this.setErrorMessage(IDEWorkbenchMessages.WizardNewProjectCreationPage_projectExistsMessage);
            return false;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectNameFieldValue());
        this.locationArea.setExistingProject(project);
        String validLocationMessage = this.locationArea.checkValidLocation();
        if (validLocationMessage != null) {
            this.setErrorMessage(validLocationMessage);
            return false;
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }

    public IProject getProjectHandle() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName());
    }

    public String getProjectName() {
        if (this.projectNameField == null) {
            return this.initialProjectFieldValue;
        }
        return this.getProjectNameFieldValue();
    }

    @Override
    protected void initializeViewer() {
        if (this.getInitialTemplateId() != null) {
            try {
                this.selectInitialTemplate();
            }
            catch (IOException e) {
                Logger.log((Exception)e);
            }
        }
    }

    private void selectInitialTemplate() throws IOException {
        this.templateViewer.reveal((Object)this.getInitialTemplateId());
        this.templateViewer.setSelection((ISelection)new StructuredSelection((Object)this.getInitialTemplateId()), true);
        String description = new TemplatesManager().getDescription(this.getInitialTemplateId());
        this.setDescriptionText(description);
    }

    @Override
    public void selectionChanged(SelectionChangedEvent event) {
        super.selectionChanged(event);
        ITemplateNode selectedElement = this.getSelection();
        if (selectedElement != null) {
            String projectName = new TemplatesManager().getProjectName(this.getSelection());
            this.projectNameField.setText(projectName);
        }
    }

    @Override
    public boolean canFlipToNextPage() {
        return false;
    }

    public ITemplateNode getSelection() {
        ITemplateNode firstElement;
        ITreeSelection ssel = this.templateViewer.getStructuredSelection();
        if (this.getfUseTemplate().getSelection() && ssel != null && !ssel.isEmpty() && (firstElement = (ITemplateNode)ssel.getFirstElement()).getType() == 4) {
            return firstElement;
        }
        return null;
    }

    public ITemplateNode getInitialTemplateId() {
        return this.fInitialTemplateId;
    }

    public void setInitialTemplateId(ITemplateNode templateNode) {
        this.fInitialTemplateId = templateNode;
    }

    public void setVisible(boolean visible) {
        if (visible && this.getfUseTemplate() != null) {
            if (!this.getfUseTemplate().getSelection()) {
                this.templateViewer.getControl().setEnabled(false);
            }
            this.getfUseTemplate().setEnabled(true);
            this.templateViewer.refresh();
        }
        super.setVisible(visible);
    }

    public String getSelectedTarget() {
        return this.targetCombo.getText();
    }
}

