/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.nvs.dialog;

import com.espressif.idf.core.build.NvsTableBean;
import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.util.NvsBeanValidator;
import com.espressif.idf.core.util.NvsPartitionGenerator;
import com.espressif.idf.core.util.NvsTableDataService;
import com.espressif.idf.core.util.StringUtil;
import com.espressif.idf.ui.nvs.dialog.Messages;
import com.espressif.idf.ui.nvs.dialog.NvsColumn;
import com.espressif.idf.ui.nvs.dialog.NvsEditorPreferenceService;
import com.espressif.idf.ui.nvs.dialog.NvsEditorSettings;
import com.espressif.idf.ui.nvs.dialog.NvsEditorSupportFactory;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class NvsCsvEditorPage {
    private Composite mainControl;
    private IFile csvFile;
    private Consumer<Boolean> dirtyStateListener;
    private Text statusText;
    private Table csvTable;
    private TableViewer tableViewer;
    private Text sizeText;
    private Composite encryptionComposite;
    private Text encryptionKeyText;
    private Button generateEncryptionKeyCheckBox;
    private Button encryptAction;
    private Button generateButton;
    private String saveErrorMsg;
    private final EnumMap<GeneratePartitionValidationError, String> validationErrors = new EnumMap(GeneratePartitionValidationError.class);
    private final EnumMap<NvsColumn, CellEditor> cellEditors = new EnumMap(NvsColumn.class);
    private NvsEditorPreferenceService preferenceService;

    public NvsCsvEditorPage(Composite parent, IFile csvFile, Consumer<Boolean> dirtyStateListener) {
        this.csvFile = csvFile;
        this.dirtyStateListener = dirtyStateListener;
        this.mainControl = new Composite(parent, 0);
        this.mainControl.setLayout((Layout)new GridLayout(1, false));
        this.preferenceService = new NvsEditorPreferenceService(csvFile.getProject());
    }

    public void createControl() {
        this.statusText = new Text(this.mainControl, 2632);
        GridData gd = new GridData(4, 128, true, false);
        gd.heightHint = 60;
        this.statusText.setLayoutData((Object)gd);
        this.statusText.setBackground(this.mainControl.getDisplay().getSystemColor(22));
        this.createEncryptionLabel(this.mainControl);
        this.createSizeOfPartitionLabel(this.mainControl);
        Group group = new Group(this.mainControl, 0);
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setLayout((Layout)new GridLayout(2, false));
        this.createTable((Composite)group);
        this.createToolButtonBar((Composite)group);
        this.createTableViewer();
        this.loadSettingsToUi();
        this.setMessage(Messages.NvsEditorDialog_DefaultMessage, 1);
        this.encryptAction.notifyListeners(13, new Event());
        this.validateGenerationState();
    }

    private void validateGenerationState() {
        String encKeyError;
        this.validationErrors.clear();
        String sizeError = this.validateSize();
        if (!sizeError.isBlank()) {
            this.validationErrors.put(GeneratePartitionValidationError.SIZE_ERROR, sizeError);
        }
        if (!(encKeyError = this.validateEncKeyPath()).isBlank()) {
            this.validationErrors.put(GeneratePartitionValidationError.ENCRYPTION_PATH_ERROR, encKeyError);
        }
        this.setGenerationButtonStatus();
        this.updateErrorMessage();
    }

    private void setMessage(String message, int messageType) {
        if (this.statusText != null && !this.statusText.isDisposed()) {
            this.statusText.setText(message != null ? message : "");
            Display display = this.statusText.getDisplay();
            this.statusText.setForeground(switch (messageType) {
                case 3 -> display.getSystemColor(3);
                case 2 -> display.getSystemColor(8);
                default -> display.getSystemColor(21);
            });
        }
    }

    private void setErrorMessage(String message) {
        if (message == null) {
            this.setMessage(Messages.NvsEditorDialog_DefaultMessage, 1);
        } else {
            this.setMessage(message, 3);
        }
    }

    public void setFocus() {
        if (this.csvTable != null && !this.csvTable.isDisposed()) {
            this.csvTable.setFocus();
        } else if (this.mainControl != null && !this.mainControl.isDisposed()) {
            this.mainControl.setFocus();
        }
    }

    public boolean getSaveAction() {
        List beansToSave = (List)this.tableViewer.getInput();
        boolean isPageValid = this.validateBeansBeforeSaving(beansToSave);
        this.updateErrorMessage();
        if (!isPageValid) {
            return false;
        }
        new NvsTableDataService().saveCsv(this.csvFile, beansToSave);
        Object baseMessage = Messages.NvsTableEditorDialog_SaveInfoMsg;
        String status = this.statusText.getText();
        if (status != null && !status.isBlank()) {
            baseMessage = (String)baseMessage + StringUtil.LINE_SEPARATOR + status;
        }
        this.setMessage((String)baseMessage, 1);
        Logger.log((String)Messages.NvsTableEditorDialog_SaveInfoMsg);
        try {
            this.csvFile.getProject().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            Logger.log((Exception)((Object)e));
        }
        this.dirtyStateListener.accept(false);
        this.saveSettingsFromUi();
        return true;
    }

    public void markDirty() {
        List beansToSave = (List)this.tableViewer.getInput();
        this.validateBeansBeforeSaving(beansToSave);
        this.updateErrorMessage();
        this.dirtyStateListener.accept(true);
    }

    public void updateErrorMessage() {
        Object newErrorMessage = "";
        if (this.saveErrorMsg == null) {
            this.saveErrorMsg = "";
        }
        if (this.saveErrorMsg != null && !this.saveErrorMsg.isBlank()) {
            newErrorMessage = String.format(Messages.NvsEditorDialog_ComplexSaveErrorMsg, this.saveErrorMsg);
        }
        if (!this.validationErrors.isEmpty()) {
            if (newErrorMessage != null && !((String)newErrorMessage).isBlank()) {
                newErrorMessage = ((String)newErrorMessage).concat(StringUtil.LINE_SEPARATOR).concat(" ");
            }
            ArrayList<String> valuesArr = new ArrayList<String>();
            for (Map.Entry<GeneratePartitionValidationError, String> errorEntry : this.validationErrors.entrySet()) {
                valuesArr.add(errorEntry.getValue());
            }
            newErrorMessage = (String)newErrorMessage + String.format(Messages.NvsEditorDialog_GenerateButtonComplexErrorMsg, String.join((CharSequence)"; ", valuesArr));
        }
        this.setErrorMessage((String)newErrorMessage);
    }

    private void createToolButtonBar(Composite parent) {
        Composite userButtonComp = new Composite(parent, 0);
        userButtonComp.setLayoutData((Object)new GridData(4, 4, false, true));
        userButtonComp.setLayout((Layout)new GridLayout());
        this.encryptAction = new Button(userButtonComp, 32);
        this.encryptAction.setText(Messages.NvsTableEditorIsEncryptedActionMsg);
        this.encryptAction.setLayoutData((Object)new GridData(4, 1, false, false));
        this.encryptAction.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Stream.of(NvsCsvEditorPage.this.encryptionComposite.getChildren()).forEach(t -> t.setEnabled(NvsCsvEditorPage.this.encryptAction.getSelection()));
                if (NvsCsvEditorPage.this.encryptAction.getSelection()) {
                    NvsCsvEditorPage.this.generateEncryptionKeyCheckBox.notifyListeners(13, new Event());
                }
                NvsCsvEditorPage.this.markDirty();
                NvsCsvEditorPage.this.validateGenerationState();
            }
        });
        Button addButton = new Button(userButtonComp, 8);
        addButton.setText(Messages.NvsTableEditorDialog_AddRowAction);
        addButton.setLayoutData((Object)new GridData(4, 1, false, false));
        addButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(t -> this.getAddRowAction()));
        Button deleteRowButton = new Button(userButtonComp, 8);
        deleteRowButton.setText(Messages.NvsTableEditorDialog_DeleteSelectedAction);
        deleteRowButton.setLayoutData((Object)new GridData(4, 1, false, false));
        deleteRowButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(t -> this.getDeleteRowAction()));
        Button saveButton = new Button(userButtonComp, 8);
        saveButton.setText(Messages.NvsTableEditorDialog_SaveAction);
        saveButton.setLayoutData((Object)new GridData(4, 1, false, false));
        saveButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(t -> {
            boolean bl = this.getSaveAction();
        }));
        this.generateButton = new Button(userButtonComp, 8);
        this.generateButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this.generateButton.setText(Messages.NvsTableEditorGeneratePartitionActionMsg);
        this.generateButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(t -> this.getGeneratePartitionAction()));
    }

    private void createEncryptionLabel(Composite parent) {
        Composite composite = this.encryptionComposite = this.encryptionComposite == null ? new Composite(parent, 0) : this.encryptionComposite;
        if (parent.getLayout() instanceof GridLayout) {
            this.encryptionComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        }
        this.encryptionComposite.setLayout((Layout)new GridLayout(4, false));
        this.generateEncryptionKeyCheckBox = new Button(this.encryptionComposite, 32);
        this.generateEncryptionKeyCheckBox.setText(Messages.NvsEditorDialog_GenEncKeyCheckBoxTxt);
        this.generateEncryptionKeyCheckBox.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 4, 1));
        final ArrayList<Object> canBeDisposedList = new ArrayList<Object>();
        Label encyptionKeyLbl = new Label(this.encryptionComposite, 0);
        encyptionKeyLbl.setText(Messages.NvsEditorDialog_PathToEncrKeyLbl);
        encyptionKeyLbl.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.encryptionKeyText = new Text(this.encryptionComposite, 2048);
        this.encryptionKeyText.setMessage(Messages.NvsEditorDialog_PathToKeysTxt);
        GridData textData = new GridData(4, 0x1000000, true, false);
        textData.minimumWidth = 200;
        this.encryptionKeyText.setLayoutData((Object)textData);
        Image image = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage();
        final Label errorIconLabel = new Label(this.encryptionComposite, 0);
        errorIconLabel.setImage(image);
        errorIconLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        Button encyptionKeyBrowseButton = new Button(this.encryptionComposite, 8);
        encyptionKeyBrowseButton.setText(Messages.NvsEditorDialog_EncKeyBrowseTxt);
        encyptionKeyBrowseButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.encryptionKeyText.addModifyListener(e -> {
            String errMsg = this.validateEncKeyPath();
            if (errMsg.isBlank()) {
                errorIconLabel.setImage(null);
                errorIconLabel.setToolTipText(null);
            } else {
                errorIconLabel.setImage(image);
                errorIconLabel.setToolTipText(errMsg);
            }
            this.markDirty();
            this.validateGenerationState();
        });
        encyptionKeyBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog dlg = new FileDialog(NvsCsvEditorPage.this.mainControl.getShell(), 4096);
                dlg.setFilterPath(NvsCsvEditorPage.this.csvFile.getProject().getLocation().toString());
                dlg.setFilterExtensions(new String[]{"*.bin", "*"});
                dlg.setText(Messages.NvsEditorDialog_EncrPartitionKeyDlgTxt);
                String dir = dlg.open();
                if (dir != null) {
                    NvsCsvEditorPage.this.encryptionKeyText.setText(dir);
                    NvsCsvEditorPage.this.encryptionKeyText.getParent().pack();
                }
            }
        });
        canBeDisposedList.add(encyptionKeyLbl);
        canBeDisposedList.add(this.encryptionKeyText);
        canBeDisposedList.add(errorIconLabel);
        canBeDisposedList.add(encyptionKeyBrowseButton);
        this.generateEncryptionKeyCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (NvsCsvEditorPage.this.generateEncryptionKeyCheckBox.getSelection()) {
                    canBeDisposedList.forEach(t -> t.setEnabled(false));
                    errorIconLabel.setImage(null);
                    errorIconLabel.setToolTipText(null);
                } else {
                    canBeDisposedList.forEach(t -> t.setEnabled(true));
                    NvsCsvEditorPage.this.encryptionKeyText.notifyListeners(24, new Event());
                }
                NvsCsvEditorPage.this.markDirty();
                NvsCsvEditorPage.this.validateGenerationState();
            }
        });
    }

    private void createSizeOfPartitionLabel(Composite parent) {
        Composite sizeComposite = new Composite(parent, 0);
        if (parent.getLayout() instanceof GridLayout) {
            sizeComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        }
        sizeComposite.setLayout((Layout)new GridLayout(2, false));
        Label sizeOfPartitionLbl = new Label(sizeComposite, 0);
        sizeOfPartitionLbl.setText(Messages.NvsTableEditorSizeOfPartitionLblMsg);
        sizeOfPartitionLbl.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.sizeText = new Text(sizeComposite, 2048);
        this.sizeText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.sizeText.setMessage(Messages.NvsEditorDialog_DefaultSizeMsg);
        ControlDecoration deco = new ControlDecoration((Control)this.sizeText, 131072);
        Image image = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage();
        this.sizeText.addModifyListener(e -> {
            String errMsg = this.validateSize();
            if (errMsg.isBlank()) {
                deco.setImage(null);
                deco.setDescriptionText(null);
            } else {
                deco.setImage(image);
                deco.setDescriptionText(errMsg);
            }
            this.markDirty();
            this.validateGenerationState();
        });
    }

    private void createTableViewer() {
        this.tableViewer = new TableViewer(this.csvTable);
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tableViewer);
        this.tableViewer.setColumnProperties(NvsColumn.getColumnProperties());
        this.cellEditors.put(NvsColumn.KEY, (CellEditor)new TextCellEditor((Composite)this.csvTable));
        this.cellEditors.put(NvsColumn.TYPE, (CellEditor)new ComboBoxCellEditor((Composite)this.csvTable, NvsTableDataService.getTypes(), 8));
        this.cellEditors.put(NvsColumn.ENCODING, (CellEditor)new ComboBoxCellEditor((Composite)this.csvTable, NvsTableDataService.getEncodings((String)""), 8));
        this.cellEditors.put(NvsColumn.VALUE, (CellEditor)new TextCellEditor((Composite)this.csvTable));
        NvsEditorSupportFactory supportFactory = new NvsEditorSupportFactory(this.tableViewer, this.cellEditors, this::markDirty);
        NvsColumn[] nvsColumnArray = NvsColumn.values();
        int n = nvsColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            NvsColumn column = nvsColumnArray[n2];
            TableViewerColumn tvColumn = new TableViewerColumn(this.tableViewer, 0);
            tvColumn.getColumn().setText(column.getDisplayName());
            tvColumn.getColumn().setWidth(column.getDefaultWidth());
            tvColumn.setLabelProvider((CellLabelProvider)supportFactory.createLabelProvider(column));
            tvColumn.setEditingSupport(supportFactory.createEditingSupport(column));
            ++n2;
        }
        try {
            List list = new NvsTableDataService().parseCsv(Paths.get(this.csvFile.getLocationURI()));
            this.tableViewer.setInput((Object)list);
        }
        catch (IOException e) {
            Logger.log((Exception)e);
        }
    }

    private void createTable(Composite parent) {
        this.csvTable = new Table(parent, 68352);
        this.csvTable.setHeaderVisible(true);
        this.csvTable.setLinesVisible(true);
        this.csvTable.setLayoutData((Object)new GridData(4, 4, true, true));
        ((GridData)this.csvTable.getLayoutData()).widthHint = 1000;
    }

    private void getGeneratePartitionAction() {
        this.validateGenerationState();
        if (this.validationErrors.isEmpty()) {
            String status;
            Object infoMsg = NvsPartitionGenerator.generateNvsPartititon((boolean)this.encryptAction.getSelection(), this.getEncKeyPath(), (String)this.sizeText.getText(), (IFile)this.csvFile);
            String string = status = this.statusText != null ? this.statusText.getText() : null;
            if (status != null && !status.isBlank()) {
                infoMsg = (String)infoMsg + StringUtil.LINE_SEPARATOR + status.trim();
            }
            this.setMessage((String)infoMsg, 1);
            Logger.log((String)infoMsg);
        } else {
            Logger.log((String)"NVS Partition Generation failed validation.");
        }
        try {
            this.csvFile.getProject().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            Logger.log((Exception)((Object)e));
        }
    }

    public void setGenerationButtonStatus() {
        if (this.generateButton != null) {
            this.generateButton.setEnabled(this.validationErrors.isEmpty());
        }
    }

    private String validateEncKeyPath() {
        String encKeyPath = this.getEncKeyPath().orElseGet(() -> "");
        if (this.encryptAction.getSelection() && !this.generateEncryptionKeyCheckBox.getSelection() && !new File(encKeyPath).canRead()) {
            return Messages.NvsEditorDialog_EncKeyCantBeReadErrMsg;
        }
        return "";
    }

    private String validateSize() {
        Long decodedSize = 0L;
        try {
            decodedSize = Long.decode(this.sizeText.getText());
        }
        catch (NumberFormatException e) {
            return Messages.NvsEditorDialog_SizeValidationDecodedErr + e.getMessage();
        }
        if (decodedSize < 4096L || decodedSize % 4096L != 0L) {
            return Messages.NvsEditorDialog_WrongSizeFormatErrMsg;
        }
        return "";
    }

    private Optional<String> getEncKeyPath() {
        if (this.encryptionKeyText == null || !this.encryptionKeyText.isEnabled()) {
            return Optional.empty();
        }
        return Optional.of(this.encryptionKeyText.getText());
    }

    private boolean validateBeansBeforeSaving(List<NvsTableBean> beansToSave) {
        if (beansToSave.isEmpty()) {
            this.saveErrorMsg = Messages.NvsEditorDialog_EmptyTableErrorMsg;
            return false;
        }
        if (!this.validateFirstBean(beansToSave.get(0))) {
            return false;
        }
        for (NvsTableBean bean : beansToSave) {
            NvsColumn[] nvsColumnArray = NvsColumn.values();
            int n = nvsColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                NvsColumn column = nvsColumnArray[n2];
                String errorMsg = new NvsBeanValidator().validateBean(bean, column.getIndex());
                if (!errorMsg.isBlank()) {
                    this.saveErrorMsg = errorMsg;
                    return false;
                }
                ++n2;
            }
        }
        this.saveErrorMsg = "";
        return true;
    }

    private boolean validateFirstBean(NvsTableBean nvsTableBean) {
        String errorMsg = new NvsBeanValidator().validateFirstBean(nvsTableBean);
        if (!errorMsg.isBlank()) {
            this.saveErrorMsg = errorMsg;
            return false;
        }
        return true;
    }

    private void getDeleteRowAction() {
        List beansToSave = (List)this.tableViewer.getInput();
        NvsTableBean selectedElement = (NvsTableBean)this.tableViewer.getElementAt(this.csvTable.getSelectionIndex());
        if (selectedElement == null) {
            return;
        }
        if (selectedElement.equals(this.tableViewer.getElementAt(0))) {
            this.setMessage(Messages.NvsEditorDialog_FirstRowIsFixedInfoMsg, 1);
            return;
        }
        boolean confirmDelete = MessageDialog.openConfirm((Shell)this.mainControl.getShell(), (String)Messages.NvsTableEditorDialog_DeleteSelectedAction, (String)Messages.NvsEditorDialog_ConfirmDeleteMsg);
        if (!confirmDelete) {
            return;
        }
        beansToSave.remove(selectedElement);
        this.tableViewer.setInput((Object)beansToSave);
        this.tableViewer.refresh();
        this.markDirty();
    }

    private void getAddRowAction() {
        List beansToSave = (List)this.tableViewer.getInput();
        beansToSave.add(new NvsTableBean());
        this.tableViewer.setInput((Object)beansToSave);
        this.tableViewer.refresh();
        this.csvTable.select(this.csvTable.getItemCount() - 1);
        this.tableViewer.refresh();
        this.markDirty();
    }

    private void loadSettingsToUi() {
        NvsEditorSettings settings = this.preferenceService.loadSettings();
        this.sizeText.setText(settings.partitionSize());
        this.encryptAction.setSelection(settings.encryptEnabled());
        this.generateEncryptionKeyCheckBox.setSelection(settings.generateKeyEnabled());
        this.encryptionKeyText.setText(settings.encryptionKeyPath());
    }

    private void saveSettingsFromUi() {
        String partitionSize = this.sizeText.getText();
        boolean encryptEnabled = this.encryptAction.getSelection();
        boolean generateKeyEnabled = this.generateEncryptionKeyCheckBox.getSelection();
        String encryptionKeyPath = this.encryptionKeyText.getText();
        NvsEditorSettings settings = new NvsEditorSettings(partitionSize, encryptEnabled, generateKeyEnabled, encryptionKeyPath);
        this.preferenceService.saveSettings(settings);
    }

    static enum GeneratePartitionValidationError {
        SIZE_ERROR,
        ENCRYPTION_PATH_ERROR;

    }
}

