/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.install;

import com.espressif.idf.core.IDFCorePlugin;
import com.espressif.idf.core.IDFVersion;
import com.espressif.idf.core.IDFVersionsReader;
import com.espressif.idf.core.ProcessBuilderFactory;
import com.espressif.idf.core.SystemExecutableFinder;
import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.util.IDFUtil;
import com.espressif.idf.core.util.StringUtil;
import com.espressif.idf.ui.UIPlugin;
import com.espressif.idf.ui.install.Messages;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class IDFDownloadPage
extends WizardPage {
    private static final int GIT_TOOL = 0;
    private static final int PYTHON_TOOL = 1;
    private Combo versionCombo;
    private Map<String, IDFVersion> versionsMap;
    private Text directoryTxt;
    private Button fileSystemBtn;
    private Text existingIdfDirTxt;
    private Button browseBtn;
    private Text gitText;
    private Text pythonText;
    private String pythonExecutablePath;
    private String gitExecutablePath;
    private SystemExecutableFinder systemExecutableFinder;

    protected IDFDownloadPage(String pageName) {
        super(pageName);
        this.setImageDescriptor(UIPlugin.getImageDescriptor(Messages.IDFDownloadPage_0));
        this.getPythonExecutablePath();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.initializeDialogUnits((Control)parent);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.createExistingComposite(composite);
        this.createGitPythonComposite(composite);
        Group versionGrp = new Group(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        versionGrp.setLayout((Layout)layout);
        versionGrp.setLayoutData((Object)new GridData(768));
        versionGrp.setText(Messages.IDFDownloadPage_DownloadIDF);
        versionGrp.setFont(parent.getFont());
        Label versionLbl = new Label((Composite)versionGrp, 0);
        versionLbl.setText(Messages.IDFDownloadPage_ChooseIDFVersion);
        this.versionCombo = new Combo((Composite)versionGrp, 12);
        GridData gridData = new GridData(0, 0, false, false, 2, 1);
        gridData.widthHint = 250;
        this.versionCombo.setLayoutData((Object)gridData);
        this.versionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IDFDownloadPage.this.validate();
            }
        });
        this.versionsMap = new IDFVersionsReader().getVersionsMap();
        Set<String> keySet = this.versionsMap.keySet();
        this.versionCombo.setItems(keySet.toArray(new String[keySet.size()]));
        if (keySet.size() > 0) {
            this.versionCombo.select(0);
        }
        this.createDownloadComposite((Composite)versionGrp);
        this.createLinkArea((Composite)versionGrp);
        Label noteLbl = new Label(composite, 0);
        noteLbl.setText(Messages.IDFDownloadPage_Note);
        gridData = new GridData(16384, 0, true, false, 1, 1);
        gridData.verticalIndent = 10;
        noteLbl.setLayoutData((Object)gridData);
        this.setControl((Control)composite);
        this.setPageComplete(false);
    }

    private void createGitPythonComposite(Composite parent) {
        Group gitPyGroup = new Group(parent, 16);
        gitPyGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        int numColumns = 3;
        GridLayout gridLayout = new GridLayout(3, false);
        gitPyGroup.setLayout((Layout)gridLayout);
        Label gitLabel = new Label((Composite)gitPyGroup, 0);
        gitLabel.setText(Messages.GitLabel);
        this.gitText = new Text((Composite)gitPyGroup, 2052);
        this.gitText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.gitExecutablePath = IDFUtil.getGitExecutablePathFromSystem();
        this.gitText.setText(this.gitExecutablePath);
        this.gitText.addModifyListener((ModifyListener)new ModifyTextValidationListener(0));
        Button gitBrowseButton = new Button((Composite)gitPyGroup, 8);
        gitBrowseButton.setText(Messages.BrowseButton);
        gitBrowseButton.addSelectionListener((SelectionListener)new BrowseButtonSelectionAdapter(this.gitText, 0));
        if (StringUtil.isEmpty((String)this.pythonExecutablePath)) {
            this.pythonExecutablePath = this.getPythonExecutablePath();
        }
        Label pythonLabel = new Label((Composite)gitPyGroup, 0);
        pythonLabel.setText(Messages.PythonLabel);
        this.pythonText = new Text((Composite)gitPyGroup, 2052);
        this.pythonText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.pythonText.setText(this.pythonExecutablePath);
        this.pythonText.addModifyListener((ModifyListener)new ModifyTextValidationListener(1));
        Button pythonBrowseButton = new Button((Composite)gitPyGroup, 8);
        pythonBrowseButton.setText(Messages.BrowseButton);
        pythonBrowseButton.addSelectionListener((SelectionListener)new BrowseButtonSelectionAdapter(this.pythonText, 1));
    }

    private void createExistingComposite(Composite parent) {
        this.fileSystemBtn = new Button(parent, 32);
        this.fileSystemBtn.setText(Messages.IDFDownloadPage_ChooseAnExistingIDF);
        GridData gridData2 = new GridData(0, 0, false, false, 1, 1);
        gridData2.verticalIndent = 10;
        this.fileSystemBtn.setLayoutData((Object)gridData2);
        Group composite = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        composite.setFont(parent.getFont());
        Label label = new Label((Composite)composite, 0);
        label.setText(Messages.IDFDownloadPage_ChooseDirIDF);
        this.existingIdfDirTxt = new Text((Composite)composite, 2048);
        this.existingIdfDirTxt.setEnabled(false);
        GridData data = new GridData();
        data.widthHint = this.convertHorizontalDLUsToPixels(200);
        this.existingIdfDirTxt.setLayoutData((Object)data);
        this.existingIdfDirTxt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IDFDownloadPage.this.validate();
            }
        });
        final Button existingBrowseBtn = new Button((Composite)composite, 8);
        existingBrowseBtn.setText(Messages.IDFDownloadPage_BrowseBtn);
        existingBrowseBtn.setEnabled(false);
        existingBrowseBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DirectoryDialog dlg = new DirectoryDialog(IDFDownloadPage.this.getShell());
                dlg.setFilterPath(IDFDownloadPage.this.existingIdfDirTxt.getText());
                dlg.setText(Messages.IDFDownloadPage_DirectoryDialogTxt);
                dlg.setMessage(Messages.IDFDownloadPage_DirectoryDialogMsg);
                String dir = dlg.open();
                if (dir != null) {
                    IDFDownloadPage.this.existingIdfDirTxt.setText(dir);
                }
            }
        });
        this.fileSystemBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (IDFDownloadPage.this.fileSystemBtn.getSelection()) {
                    IDFDownloadPage.this.existingIdfDirTxt.setEnabled(true);
                    existingBrowseBtn.setEnabled(true);
                    IDFDownloadPage.this.versionCombo.setEnabled(false);
                    IDFDownloadPage.this.directoryTxt.setEnabled(false);
                    IDFDownloadPage.this.browseBtn.setEnabled(false);
                } else {
                    IDFDownloadPage.this.existingIdfDirTxt.setEnabled(false);
                    existingBrowseBtn.setEnabled(false);
                    IDFDownloadPage.this.versionCombo.setEnabled(true);
                    IDFDownloadPage.this.directoryTxt.setEnabled(true);
                    IDFDownloadPage.this.browseBtn.setEnabled(true);
                }
                IDFDownloadPage.this.validate();
            }
        });
    }

    private void createDownloadComposite(Composite composite) {
        Label descLbl = new Label(composite, 0);
        descLbl.setText(Messages.IDFDownloadPage_ChooseIDFDir);
        this.directoryTxt = new Text(composite, 2048);
        GridData data = new GridData();
        data.widthHint = this.convertHorizontalDLUsToPixels(200);
        this.directoryTxt.setLayoutData((Object)data);
        this.directoryTxt.setFocus();
        this.directoryTxt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IDFDownloadPage.this.validate();
            }
        });
        this.browseBtn = new Button(composite, 8);
        this.browseBtn.setText(Messages.IDFDownloadPage_BrowseBtnTxt);
        this.browseBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DirectoryDialog dlg = new DirectoryDialog(IDFDownloadPage.this.getShell());
                dlg.setFilterPath(IDFDownloadPage.this.directoryTxt.getText());
                dlg.setText(Messages.IDFDownloadPage_DirectoryDialogText);
                dlg.setMessage(Messages.IDFDownloadPage_DirectoryDialogMessage);
                String dir = dlg.open();
                if (dir != null) {
                    IDFDownloadPage.this.directoryTxt.setText(dir);
                }
            }
        });
    }

    private String getPythonExecutablePath() {
        return IDFUtil.getPythonExecutable();
    }

    private void createLinkArea(Composite parent) {
        Link link = new Link(parent, 0);
        String message = Messages.IDFDownloadPage_VersionLinkMsg;
        link.setText(message);
        link.setSize(400, 100);
        GridData gridData = new GridData(0, 0, false, false, 3, 1);
        gridData.verticalIndent = 10;
        link.setLayoutData((Object)gridData);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL(e.text));
                }
                catch (PartInitException ex) {
                    ex.printStackTrace();
                }
                catch (MalformedURLException ex) {
                    ex.printStackTrace();
                }
            }
        });
    }

    private boolean validateGitAndPython() {
        File file;
        if (this.systemExecutableFinder == null) {
            this.systemExecutableFinder = new SystemExecutableFinder();
        }
        if (StringUtil.isEmpty((String)this.pythonExecutablePath) || StringUtil.isEmpty((String)this.gitExecutablePath)) {
            this.setErrorMessage("Python & Git are Required");
            return false;
        }
        IPath pathGit = this.systemExecutableFinder.find(this.gitExecutablePath);
        if (pathGit != null) {
            this.gitExecutablePath = pathGit.toOSString();
        }
        if (!(file = new File(this.gitExecutablePath)).exists() && !IDFUtil.isReparseTag((File)file)) {
            this.setErrorMessage("Git executable not found");
            return false;
        }
        IPath pythonPath = this.systemExecutableFinder.find(this.pythonExecutablePath);
        if (pythonPath != null) {
            this.pythonExecutablePath = pythonPath.toOSString();
        }
        if (!(file = new File(this.pythonExecutablePath)).exists() && !IDFUtil.isReparseTag((File)file)) {
            this.setErrorMessage("Python executable not found");
            return false;
        }
        return true;
    }

    private void validate() {
        if (this.fileSystemBtn.getSelection()) {
            String idfPath = this.existingIdfDirTxt.getText();
            if (StringUtil.isEmpty((String)idfPath)) {
                this.setPageComplete(false);
                this.setErrorMessage("IDF Directory is Required");
                return;
            }
            if (!new File(idfPath).exists()) {
                this.setErrorMessage(Messages.IDFDownloadPage_DirDoesnotExist + idfPath);
                this.setPageComplete(false);
                return;
            }
            String version = this.getIdfVersionUsingGit(idfPath);
            if (idfPath.contains(" ") && !StringUtil.isEmpty((String)version)) {
                boolean validVersion = this.isVersionGreaterOrEqual(version, "5.0.0");
                if (!validVersion) {
                    this.setErrorMessage(Messages.IDFDownloadPage_VersionSpaceError);
                    this.setPageComplete(false);
                    return;
                }
                if (this.getErrorMessage() == null || this.getErrorMessage().equals(Messages.IDFDownloadPage_VersionSpaceError)) {
                    this.setErrorMessage(null);
                    this.setPageComplete(true);
                }
            }
            String idfPyPath = idfPath + File.separator + "tools" + File.separator + "idf.py";
            String idfToolsPyPth = idfPath + File.separator + "tools" + File.separator + "idf_tools.py";
            if (!new File(idfPyPath).exists() || !new File(idfToolsPyPth).exists()) {
                this.setErrorMessage(MessageFormat.format(Messages.IDFDownloadPage_CantfindProperEspIDFDirectory, idfPath));
                this.setPageComplete(false);
                return;
            }
            if (this.validateGitAndPython()) {
                this.setPageComplete(true);
                this.setErrorMessage(null);
                this.setMessage(Messages.IDFDownloadPage_ClickOnFinish + idfPath);
            } else {
                this.setPageComplete(false);
            }
        } else {
            this.setMessage("");
            this.setErrorMessage(null);
            boolean supportSpaces = false;
            if (this.versionCombo.getText().contentEquals("master")) {
                supportSpaces = true;
            } else {
                Pattern p = Pattern.compile("([0-9][.][0-9])");
                Matcher m = p.matcher(this.versionCombo.getText());
                boolean bl = supportSpaces = m.find() && Double.parseDouble(m.group(0)) >= 5.0;
            }
            if (StringUtil.isEmpty((String)this.directoryTxt.getText())) {
                this.setPageComplete(false);
                return;
            }
            if (!supportSpaces && this.directoryTxt.getText().contains(" ")) {
                this.setErrorMessage(Messages.IDFDownloadPage_VersionSpaceError);
                this.setPageComplete(false);
                return;
            }
            if (this.validateGitAndPython()) {
                this.setPageComplete(true);
                this.setErrorMessage(null);
                this.setMessage(Messages.IDFDownloadPage_ClickFinishToDownload);
            } else {
                this.setPageComplete(false);
            }
        }
    }

    private String getIdfVersionUsingGit(String idfPath) {
        String version;
        block7: {
            IStatus status;
            block6: {
                if (!this.validateGitAndPython()) {
                    return "";
                }
                ArrayList<String> commands = new ArrayList<String>();
                commands.add(this.gitExecutablePath);
                commands.add("describe");
                ProcessBuilderFactory processRunner = new ProcessBuilderFactory();
                try {
                    Logger.log((String)("Executing commads: " + ((Object)commands).toString()));
                    HashMap<String, String> environment = new HashMap<String, String>(System.getenv());
                    status = processRunner.runInBackground(commands, Path.fromOSString((String)idfPath), environment);
                    if (status != null) break block6;
                    Logger.log((Plugin)IDFCorePlugin.getPlugin(), (IStatus)IDFCorePlugin.errorStatus((String)"Unable to get the process status.", null));
                    return "";
                }
                catch (Exception e) {
                    Logger.log((Exception)e);
                    return "";
                }
            }
            String cmdOutput = status.getMessage();
            version = "";
            String patternString = "\\d+\\.\\d+\\.\\d+";
            Pattern pattern = Pattern.compile(patternString);
            Matcher matcher = pattern.matcher(cmdOutput);
            if (matcher.find()) {
                version = matcher.group(0);
            }
            if (!StringUtil.isEmpty((String)version)) break block7;
            return "";
        }
        return version;
    }

    private boolean isVersionGreaterOrEqual(String version, String minVersion) {
        String pattern = "\\d+\\.\\d+\\.\\d+";
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(version);
        Matcher mMin = r.matcher(minVersion);
        if (m.find() && mMin.find()) {
            String[] currentVersionParts = m.group(0).split("\\.");
            String[] minVersionParts = mMin.group(0).split("\\.");
            int currentMajor = Integer.parseInt(currentVersionParts[0]);
            int currentMinor = Integer.parseInt(currentVersionParts[1]);
            int currentPatch = Integer.parseInt(currentVersionParts[2]);
            int minMajor = Integer.parseInt(minVersionParts[0]);
            int minMinor = Integer.parseInt(minVersionParts[1]);
            int minPatch = Integer.parseInt(minVersionParts[2]);
            if (currentMajor > minMajor) {
                return true;
            }
            if (currentMajor == minMajor) {
                if (currentMinor > minMinor) {
                    return true;
                }
                if (currentMinor == minMinor) {
                    return currentPatch >= minPatch;
                }
            }
        }
        return false;
    }

    protected IDFVersion Version() {
        String versionTxt = this.versionCombo.getText();
        IDFVersion version = this.versionsMap.get(versionTxt);
        return version;
    }

    public String getDestinationLocation() {
        return this.directoryTxt.getText().trim();
    }

    public String getExistingIDFLocation() {
        return this.existingIdfDirTxt.getText().trim();
    }

    public boolean isConfigureExistingEnabled() {
        return this.fileSystemBtn.getSelection();
    }

    public String getPythonExePath() {
        return this.pythonExecutablePath;
    }

    public String getGitExecutablePath() {
        return this.gitExecutablePath;
    }

    private class BrowseButtonSelectionAdapter
    extends SelectionAdapter {
        private Text linkedText;
        private int dialog;
        private static final String GIT_FILE = "git";
        private static final String PYTHON_FILE = "python*";
        private static final String PYTHON_FILTERS = "Python Executables";
        private static final String WINDOWS_EXTENSION = ".exe";

        private BrowseButtonSelectionAdapter(Text text, int dialog) {
            this.linkedText = text;
            this.dialog = dialog;
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            FileDialog dlg = null;
            dlg = this.dialog == 0 ? this.gitDialog() : this.pythonDialog();
            dlg.setText(Messages.FileSelectionDialogTitle);
            String dir = dlg.open();
            if (!StringUtil.isEmpty((String)dir)) {
                this.linkedText.setText(dir);
            }
        }

        private FileDialog pythonDialog() {
            FileDialog dialog = new FileDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell());
            if (Platform.getOS().equals("win32")) {
                dialog.setFilterNames(new String[]{PYTHON_FILTERS});
                dialog.setFilterExtensions(new String[]{PYTHON_FILE.concat(WINDOWS_EXTENSION)});
            } else {
                dialog.setFilterNames(new String[]{PYTHON_FILTERS});
                dialog.setFilterExtensions(new String[]{PYTHON_FILE});
            }
            return dialog;
        }

        private FileDialog gitDialog() {
            FileDialog dialog = new FileDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell());
            if (Platform.getOS().equals("win32")) {
                dialog.setFilterNames(new String[]{GIT_FILE.concat(WINDOWS_EXTENSION)});
                dialog.setFilterExtensions(new String[]{GIT_FILE.concat(WINDOWS_EXTENSION)});
            } else {
                dialog.setFilterNames(new String[]{GIT_FILE});
                dialog.setFilterExtensions(new String[]{GIT_FILE});
            }
            return dialog;
        }
    }

    private class ModifyTextValidationListener
    implements ModifyListener {
        private int tool;

        private ModifyTextValidationListener(int tool) {
            this.tool = tool;
        }

        public void modifyText(ModifyEvent e) {
            switch (this.tool) {
                case 0: {
                    IDFDownloadPage.this.gitExecutablePath = IDFDownloadPage.this.gitText.getText();
                    break;
                }
                case 1: {
                    IDFDownloadPage.this.pythonExecutablePath = IDFDownloadPage.this.pythonText.getText();
                }
            }
            IDFDownloadPage.this.validate();
        }
    }
}

