/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.help;

import com.espressif.idf.core.IDFCorePlugin;
import com.espressif.idf.core.IDFEnvironmentVariables;
import com.espressif.idf.core.ProcessBuilderFactory;
import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.util.IDFUtil;
import com.espressif.idf.core.util.StringUtil;
import com.espressif.idf.ui.update.ListInstalledToolsHandler;
import com.espressif.idf.ui.update.Messages;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class ProductInformationHandler
extends ListInstalledToolsHandler {
    @Override
    public Object execute(final ExecutionEvent event) throws ExecutionException {
        Job job = new Job(Messages.ProductInformationHandler_ProductInformationLogJobName){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ProductInformationHandler.this.printingProductInformationLog(event);
                }
                catch (InterruptedException | ExecutionException e) {
                    Logger.log((Exception)e);
                    return new Status(4, "unknown", 4, e.getMessage(), e);
                }
                catch (OperationCanceledException e) {
                    Logger.log((Exception)((Object)e));
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        return null;
    }

    protected void printingProductInformationLog(ExecutionEvent event) throws ExecutionException, OperationCanceledException, InterruptedException {
        if (!StringUtil.isEmpty((String)this.getPythonExecutablePath()) && !StringUtil.isEmpty((String)IDFUtil.getIDFPath())) {
            super.execute(event);
            Job.getJobManager().join((Object)Messages.ListInstalledToolsHandler_InstalledToolsListJobName, null);
        } else {
            this.activateIDFConsoleView();
        }
        this.showIDFEnvVars();
        this.console.println();
        this.console.println(Messages.OperatingSystemMsg + System.getProperty("os.name").toLowerCase());
        this.console.println(Messages.JavaRuntimeVersionMsg + Optional.ofNullable(System.getProperty("java.runtime.version")).orElse(Messages.NotFoundMsg));
        this.console.println(Messages.EclipseMsg + Optional.ofNullable(Platform.getBundle((String)"org.eclipse.platform")).map(o -> o.getVersion().toString()).orElse(Messages.NotFoundMsg));
        this.console.println(Messages.EclipseCDTMsg + Optional.ofNullable(Platform.getBundle((String)"org.eclipse.cdt")).map(o -> o.getVersion().toString()).orElse(Messages.NotFoundMsg));
        this.console.println(Messages.IdfEclipseMsg + Optional.ofNullable(Platform.getBundle((String)"com.espressif.idf.branding")).map(o -> o.getVersion().toString()).orElse(Messages.NotFoundMsg));
        this.showEspIdfVersion();
        this.console.println(Messages.PythonIdfEnvMsg + Optional.ofNullable(this.getPythonExeVersion(IDFUtil.getIDFPythonEnvPath())).orElse(Messages.NotFoundMsg));
    }

    private void showIDFEnvVars() {
        this.console.println(Messages.ProductInformationHandler_CDTBuildEnvVariables);
        Map envMap = new IDFEnvironmentVariables().getSystemEnvMap();
        for (Map.Entry entry : envMap.entrySet()) {
            String IDFEnvVarValue = (String)entry.getValue();
            IDFEnvVarValue = IDFEnvVarValue.isEmpty() ? Messages.NotFoundMsg : IDFEnvVarValue;
            this.console.println((String)entry.getKey() + ": " + IDFEnvVarValue);
        }
    }

    private void showEspIdfVersion() {
        if (IDFUtil.getIDFPath() != null && IDFUtil.getIDFPythonEnvPath() != null) {
            ArrayList<String> commands = new ArrayList<String>();
            commands.add(IDFUtil.getIDFPythonEnvPath());
            commands.add(IDFUtil.getIDFPythonScriptFile().getAbsolutePath());
            commands.add("--version");
            Map envMap = new IDFEnvironmentVariables().getSystemEnvMap();
            this.console.println(this.runCommand(commands, envMap));
        } else {
            this.console.println(Messages.MissingIdfPathMsg);
        }
    }

    private String getPythonExeVersion(String pythonExePath) {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(pythonExePath);
        commands.add("--version");
        return pythonExePath != null ? this.runCommand(commands, IDFUtil.getSystemEnv()) : null;
    }

    private String runCommand(List<String> arguments, Map<String, String> env) {
        String exportCmdOp = "";
        ProcessBuilderFactory processRunner = new ProcessBuilderFactory();
        try {
            IStatus status = processRunner.runInBackground(arguments, (IPath)Path.ROOT, env);
            if (status == null) {
                Logger.log((Plugin)IDFCorePlugin.getPlugin(), (IStatus)IDFCorePlugin.errorStatus((String)"Status can't be null", null));
            }
            exportCmdOp = status.getMessage();
            Logger.log((String)exportCmdOp);
        }
        catch (Exception e1) {
            Logger.log((Plugin)IDFCorePlugin.getPlugin(), (Exception)e1);
        }
        return exportCmdOp;
    }
}

