/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.dialogs;

import com.espressif.idf.ui.UIPlugin;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class HelpPopupDialog
extends PopupDialog {
    private static final String IMG_TOOL_CLOSE = "icons/close.gif";
    private static final String IMG_TOOL_CLOSE_HOT = "icons/close_hot.gif";
    private static final int POPUP_OFFSET = 20;
    private MouseListener clickListener;
    private String message;

    public HelpPopupDialog(Shell parentShell, String title, String message) {
        this(parentShell, title, message, null);
    }

    public HelpPopupDialog(Shell parentShell, String title, String message, final Runnable runnable) {
        super(parentShell, 16, false, true, true, false, false, title, null);
        this.message = message;
        this.clickListener = new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (runnable != null) {
                    runnable.run();
                }
                HelpPopupDialog.this.close();
            }
        };
    }

    protected Control createDialogArea(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)GridLayoutFactory.swtDefaults().create());
        main.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        if (this.clickListener != null) {
            main.addMouseListener(this.clickListener);
        }
        Label infoLabel = new Label(main, 64);
        infoLabel.setText(this.message);
        infoLabel.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        if (this.clickListener != null) {
            infoLabel.addMouseListener(this.clickListener);
        }
        return main;
    }

    protected Control createTitleControl(Composite parent) {
        Control control = super.createTitleControl(parent);
        Object data = control.getLayoutData();
        if (data instanceof GridData) {
            ((GridData)data).horizontalSpan = 1;
        }
        return control;
    }

    protected Control createTitleMenuArea(Composite parent) {
        Composite main = (Composite)super.createTitleMenuArea(parent);
        if (this.clickListener != null) {
            main.addMouseListener(this.clickListener);
        }
        ToolBar toolBar = new ToolBar(main, 0x800000);
        toolBar.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                HelpPopupDialog.this.close();
            }
        });
        ToolItem closeButton = new ToolItem(toolBar, 8, 0);
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)toolBar);
        closeButton.setImage(UIPlugin.getImage(IMG_TOOL_CLOSE));
        closeButton.setHotImage(UIPlugin.getImage(IMG_TOOL_CLOSE_HOT));
        closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HelpPopupDialog.this.close();
            }
        });
        return main;
    }

    protected Point getInitialLocation(Point initialSize) {
        Point parentLocation;
        Point parentSize;
        Shell parent = this.getParentShell();
        if (parent != null) {
            parentSize = parent.getSize();
            parentLocation = parent.getLocation();
        } else {
            Rectangle bounds = this.getShell().getDisplay().getBounds();
            parentSize = new Point(bounds.width, bounds.height);
            parentLocation = new Point(0, 0);
        }
        return new Point(parentSize.x - initialSize.x + parentLocation.x - 20, parentSize.y - initialSize.y + parentLocation.y - 20);
    }
}

